/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="activeTeachers")
public class ActiveTeachersGroup
extends GroupStrategy {
    private static final long serialVersionUID = -819881356666615761L;

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.ActiveTeachersGroup", (String[])new String[0]);
    }

    public Set<User> getMembers() {
        return Bennu.getInstance().getTeachersSet().stream().filter(teacher -> teacher.hasTeacherAuthorization()).map(teacher -> teacher.getPerson().getUser()).collect(Collectors.toSet());
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        return user != null && user.getPerson() != null && user.getPerson().getTeacher() != null && user.getPerson().getTeacher().hasTeacherAuthorization();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

