/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.ProjectSubmissionLog_Base;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProjectSubmissionLog
extends ProjectSubmissionLog_Base {
    public static Comparator<ProjectSubmissionLog> COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE = new Comparator<ProjectSubmissionLog>(){

        @Override
        public int compare(ProjectSubmissionLog leftProjectSubmissionLog, ProjectSubmissionLog rightProjectSubmissionLog) {
            int comparationResult = leftProjectSubmissionLog.getSubmissionDateTime().compareTo((ReadableInstant)rightProjectSubmissionLog.getSubmissionDateTime());
            return comparationResult == 0 ? leftProjectSubmissionLog.getExternalId().compareTo(rightProjectSubmissionLog.getExternalId()) : -comparationResult;
        }
    };

    public ProjectSubmissionLog() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ProjectSubmissionLog(DateTime submissionDateTime, String filename, String fileMimeType, String fileChecksum, String fileChecksumAlgorithm, Integer fileSize, StudentGroup studentGroup, Attends attends, Project project) {
        this();
        this.setSubmissionDateTime(submissionDateTime);
        this.setFilename(filename);
        this.setFileMimeType(fileMimeType);
        this.setFileChecksum(fileChecksum);
        this.setFileChecksumAlgorithm(fileChecksumAlgorithm);
        this.setFileSize(fileSize);
        this.setStudentGroup(studentGroup);
        this.setAttends(attends);
        this.setProject(project);
    }

    @Deprecated
    public Date getSubmission() {
        DateTime dt = this.getSubmissionDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setSubmission(Date date) {
        if (date == null) {
            this.setSubmissionDateTime(null);
        } else {
            this.setSubmissionDateTime(new DateTime(date.getTime()));
        }
    }
}

