/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.icalendar.EvaluationEventBean;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.Season;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;

public class Exam
extends Exam_Base {
    public Exam(Date examDay, Date examStartTime, Date examEndTime, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms, GradeScale gradeScale, Season season) {
        this.checkScopeAndSeasonConstrains(executionCoursesToAssociate, curricularCourseScopesToAssociate, season);
        this.setAttributesAndAssociateRooms(examDay, examStartTime, examEndTime, executionCoursesToAssociate, curricularCourseScopesToAssociate, rooms);
        this.setSeason(season);
        if (gradeScale == null) {
            this.setGradeScale(GradeScale.TYPE20);
        } else {
            this.setGradeScale(gradeScale);
        }
        this.checkIntervalBetweenEvaluations();
        this.logCreate();
    }

    public void edit(Date examDay, Date examStartTime, Date examEndTime, List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, List<Space> rooms, GradeScale gradeScale, Season season) {
        this.getAssociatedExecutionCoursesSet().clear();
        this.getAssociatedCurricularCourseScopeSet().clear();
        this.getAssociatedContextsSet().clear();
        this.checkScopeAndSeasonConstrains(executionCoursesToAssociate, curricularCourseScopesToAssociate, season);
        super.edit(examDay, examStartTime, examEndTime, executionCoursesToAssociate, curricularCourseScopesToAssociate, rooms, gradeScale);
        this.setSeason(season);
        this.checkIntervalBetweenEvaluations();
        this.logEdit();
    }

    private boolean checkScopeAndSeasonConstrains(List<ExecutionCourse> executionCoursesToAssociate, List<DegreeModuleScope> curricularCourseScopesToAssociate, Season season) {
        for (ExecutionCourse executionCourse : executionCoursesToAssociate) {
            for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                Exam existingExam;
                if (!(evaluation instanceof Exam) || !(existingExam = (Exam)((Object)evaluation)).getSeason().equals(season)) continue;
                for (DegreeModuleScope scope : existingExam.getDegreeModuleScopes()) {
                    if (!curricularCourseScopesToAssociate.contains(scope)) continue;
                    throw new DomainException("error.existingExam", new String[0]);
                }
            }
        }
        return true;
    }

    public boolean isExamsMapPublished() {
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
                DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
                for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                    if (executionCourse.getExecutionPeriod().getExecutionYear() != executionDegree.getExecutionYear() || !executionDegree.isPublishedExam(executionCourse.getExecutionPeriod())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getIsExamsMapPublished() {
        return this.isExamsMapPublished();
    }

    public static List<Exam> getAllByRoomAndExecutionPeriod(String room, String executionPeriod, String year) {
        ArrayList<Exam> result = new ArrayList<Exam>();
        block0: for (Exam exam : Exam.readExams()) {
            for (WrittenEvaluationSpaceOccupation occupation : exam.getWrittenEvaluationSpaceOccupationsSet()) {
                if (occupation.getRoom().getName().equals(room)) continue;
                continue block0;
            }
            for (ExecutionCourse course : exam.getAssociatedExecutionCoursesSet()) {
                if (course.getExecutionPeriod().getName().equals(executionPeriod) && course.getExecutionPeriod().getExecutionYear().getYear().equals(year)) continue;
                continue block0;
            }
            result.add(exam);
        }
        return result;
    }

    public static List<Exam> getAllByDate(Calendar examDay, Calendar examStartTime) {
        return Exam.getAllByDate(examDay, examStartTime, null);
    }

    public static List<Exam> getAllByDate(Calendar examDay, Calendar examStartTime, Calendar examEndTime) {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (Exam exam : Exam.readExams()) {
            if (!DateFormatUtil.equalDates("dd/MM/yyyy", examDay.getTime(), exam.getDayDate()) || examStartTime != null && !DateFormatUtil.equalDates("HH:mm", examStartTime.getTime(), exam.getBeginningDate()) || examEndTime != null && !DateFormatUtil.equalDates("HH:mm", examEndTime.getTime(), exam.getEndDate())) continue;
            result.add(exam);
        }
        return result;
    }

    public static List<Exam> readExams() {
        ArrayList<Exam> result = new ArrayList<Exam>();
        for (Evaluation evaluation : Bennu.getInstance().getEvaluationsSet()) {
            if (!(evaluation instanceof Exam)) continue;
            result.add((Exam)((Object)evaluation));
        }
        return result;
    }

    public boolean isExam() {
        return true;
    }

    public boolean isForSeason(Season season) {
        return this.getSeason().equals(season);
    }

    public boolean isSpecialSeason() {
        return this.isForSeason(Season.SPECIAL_SEASON_OBJ);
    }

    public boolean canBeAssociatedToRoom(Space room) {
        return SpaceUtils.isFree(room, this.getBeginningDateTime().toYearMonthDay(), this.getEndDateTime().toYearMonthDay(), this.getBeginningDateHourMinuteSecond(), this.getEndDateHourMinuteSecond(), this.getDayOfWeek(), null, null, null);
    }

    public List<EvaluationEventBean> getAllEvents(Registration registration) {
        return this.getAllEvents("Exame (" + this.getSeason() + ")", registration);
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.exam", (String[])new String[0]) + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)this.getSeason().getKey(), (String[])new String[0]);
    }

    public InfoEvaluation newInfoFromDomain() {
        return InfoExam.newInfoFromDomain(this);
    }
}

