/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.EmptyDegree_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class EmptyDegree
extends EmptyDegree_Base {
    private static volatile EmptyDegree instance = null;

    private EmptyDegree() {
        this.setRootDomainObject(Bennu.getInstance());
        super.setDegreeType(DegreeType.matching(DegreeType::isEmpty).orElseGet(() -> {
            DegreeType type = new DegreeType(BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)"DegreeType.EMPTY", (String[])new String[0]));
            type.setEmpty(true);
            return type;
        }));
        super.setGradeScale(GradeScale.TYPE20);
    }

    public boolean isEmpty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EmptyDegree getInstance() {
        if (instance != null) return instance;
        Class<EmptyDegree> clazz = EmptyDegree.class;
        synchronized (EmptyDegree.class) {
            if (instance != null) return instance;
            for (Degree degree : Bennu.getInstance().getDegreesSet()) {
                if (!degree.isEmpty()) continue;
                instance = (EmptyDegree)((Object)degree);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Class<EmptyDegree> clazz = EmptyDegree.class;
        synchronized (EmptyDegree.class) {
            EmptyDegree existing = EmptyDegree.getInstance();
            if (existing == null) {
                EmptyDegree newinstance = new EmptyDegree();
                newinstance.setNomeOnSuper("Curso de Unidades Isoladas");
                instance = newinstance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void setNomeOnSuper(String nome) {
        super.setNome(nome);
    }

    public void edit(String name, String nameEn, String code, DegreeType degreeType, GradeScale gradeScale, ExecutionYear executionYear) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void edit(String name, String nameEn, String acronym, DegreeType degreeType, Double ectsCredits, GradeScale gradeScale, String prevailingScientificArea, ExecutionYear executionYear) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"EmptyDegree.not.available", (String[])new String[0]));
    }

    public DegreeCurricularPlan createDegreeCurricularPlan(String name, GradeScale gradeScale, Person creator, AcademicPeriod duration) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void setNome(String nome) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void setNameEn(String nameEn) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void setSigla(String sigla) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public String getSigla() {
        return "";
    }

    public Double getEctsCredits() {
        return null;
    }

    public void setEctsCredits(Double ectsCredits) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public boolean hasEctsCredits() {
        return false;
    }

    public void setGradeScale(GradeScale gradeScale) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void setPrevailingScientificArea(String prevailingScientificArea) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public void setDegreeType(DegreeType degreeType) {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public boolean isBolonhaDegree() {
        return true;
    }

    public boolean isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() {
        return false;
    }

    public List<DegreeCurricularPlan> findDegreeCurricularPlansByState(DegreeCurricularPlanState state) {
        if (state == DegreeCurricularPlanState.ACTIVE) {
            return this.getActiveDegreeCurricularPlans();
        }
        return Collections.emptyList();
    }

    public List<DegreeCurricularPlan> getActiveDegreeCurricularPlans() {
        return Collections.singletonList(this.getMostRecentDegreeCurricularPlan());
    }

    public List<DegreeCurricularPlan> getPastDegreeCurricularPlans() {
        return Collections.emptyList();
    }

    public List<CurricularCourse> getExecutedCurricularCoursesByExecutionYear(ExecutionYear executionYear) {
        return Collections.emptyList();
    }

    public List<CurricularCourse> getExecutedCurricularCoursesByExecutionYearAndYear(ExecutionYear ey, Integer cy) {
        return Collections.emptyList();
    }

    public List<ExecutionCourse> getExecutionCourses(String curricularCourseAcronym, ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    @Deprecated
    public final String getName() {
        return this.getPresentationName();
    }

    public String getNameEn() {
        return this.getPresentationName();
    }

    public final String getPresentationName(ExecutionYear executionYear) {
        return this.getNameFor(null).getContent(MultiLanguageString.pt);
    }

    public final String getFilteredName(ExecutionYear executionYear, Locale locale) {
        return this.getNameFor(executionYear).getContent(locale);
    }

    public DegreeCurricularPlan getMostRecentDegreeCurricularPlan() {
        return (DegreeCurricularPlan)((Object)this.getDegreeCurricularPlansSet().iterator().next());
    }

    public DegreeCurricularPlan getLastActiveDegreeCurricularPlan() {
        return this.getMostRecentDegreeCurricularPlan();
    }

    public MultiLanguageString getQualificationLevel(ExecutionYear executionYear) {
        return new MultiLanguageString();
    }

    public MultiLanguageString getProfessionalExits(ExecutionYear executionYear) {
        return new MultiLanguageString();
    }

    public DegreeInfo getMostRecentDegreeInfo() {
        return null;
    }

    public DegreeInfo getDegreeInfoFor(ExecutionYear executionYear) {
        return this.getMostRecentDegreeInfo();
    }

    public DegreeInfo getMostRecentDegreeInfo(ExecutionYear executionYear) {
        return this.getMostRecentDegreeInfo();
    }

    public DegreeInfo createCurrentDegreeInfo() {
        throw new DomainException("EmptyDegree.not.available", new String[0]);
    }

    public List<Integer> buildFullCurricularYearList() {
        return Collections.emptyList();
    }

    public final boolean isCoordinator(Person person, ExecutionYear executionYear) {
        return false;
    }

    public final Collection<Coordinator> getResponsibleCoordinators(ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public final Collection<Coordinator> getCurrentCoordinators() {
        return Collections.emptySet();
    }

    public final Collection<Coordinator> getCurrentResponsibleCoordinators() {
        return Collections.emptySet();
    }

    public final Collection<Teacher> getResponsibleCoordinatorsTeachers(ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public final Collection<Teacher> getCurrentResponsibleCoordinatorsTeachers() {
        return Collections.emptySet();
    }

    public String constructSchoolClassPrefix(Integer curricularYear) {
        return "";
    }

    public boolean isFirstCycle() {
        return false;
    }

    public boolean isSecondCycle() {
        return false;
    }

    public boolean isAnyPublishedThesisAvailable() {
        return false;
    }

    public boolean isAnyThesisAvailable() {
        return false;
    }

    public Set<CurricularCourse> getAllCurricularCourses(ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public Set<CurricularCourse> getCurricularCoursesFromGivenCurricularYear(int curricularYear, ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public Set<CurricularCourse> getFirstCycleCurricularCourses(ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public Set<CurricularCourse> getSecondCycleCurricularCourses(ExecutionYear executionYear) {
        return Collections.emptySet();
    }

    public boolean canCreateGratuityEvent() {
        return false;
    }
}

