/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum StudentPersonalDataAuthorizationChoice {
    PROFESSIONAL_ENDS(false),
    SEVERAL_ENDS(false),
    ALL_ENDS(true),
    NO_END(false),
    STUDENTS_ASSOCIATION(true);

    private boolean forStudentsAssociation;

    private StudentPersonalDataAuthorizationChoice(boolean forStudentsAssociation) {
        this.setForStudentsAssociation(forStudentsAssociation);
    }

    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return StudentPersonalDataAuthorizationChoice.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return StudentPersonalDataAuthorizationChoice.class.getName() + "." + this.name();
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public static List<StudentPersonalDataAuthorizationChoice> getGeneralPersonalDataAuthorizationsTypes() {
        StudentPersonalDataAuthorizationChoice[] values;
        ArrayList<StudentPersonalDataAuthorizationChoice> authorizationsTypes = new ArrayList<StudentPersonalDataAuthorizationChoice>();
        for (StudentPersonalDataAuthorizationChoice studentPersonalDataAuthorizationChoice : values = StudentPersonalDataAuthorizationChoice.values()) {
            if (studentPersonalDataAuthorizationChoice.isForStudentsAssociation()) continue;
            authorizationsTypes.add(studentPersonalDataAuthorizationChoice);
        }
        return authorizationsTypes;
    }

    public static StudentPersonalDataAuthorizationChoice getPersonalDataAuthorizationForStudentsAssociationType(boolean allowsForStudentAssociation) {
        if (allowsForStudentAssociation) {
            return STUDENTS_ASSOCIATION;
        }
        return NO_END;
    }

    public void setForStudentsAssociation(boolean forStudentsAssociation) {
        this.forStudentsAssociation = forStudentsAssociation;
    }

    public boolean isForStudentsAssociation() {
        return this.forStudentsAssociation;
    }
}

