/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.UserPrivateKey;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.messaging.RegistrationsBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentViewApp.class, descriptionKey="label.title.sync", path="sync", bundle="MessagingResources", titleKey="label.title.sync")
@Mapping(path="/ICalTimeTable", module="student")
@Forwards(value={@Forward(name="viewOptions", path="/student/iCalendar/viewCalendarInformation.jsp"), @Forward(name="chooseRegistration", path="/student/iCalendar/chooseRegistration.jsp")})
public class ICalStudentTimeTable
extends FenixDispatchAction {
    public ActionForward show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getRenderedObject("bean") == null) {
            Registration registration = (Registration)FenixFramework.getDomainObject((String)request.getParameter("registrationId"));
            return this.forwardToShow(registration, mapping, request);
        }
        if (((RegistrationsBean)this.getRenderedObject("bean")).getSelected() != null) {
            return this.forwardToShow(((RegistrationsBean)this.getRenderedObject("bean")).getSelected(), mapping, request);
        }
        return this.prepare(mapping, form, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Registration> registrations = ICalStudentTimeTable.getUserView(request).getPerson().getStudent().getActiveRegistrations();
        if (registrations.size() == 1) {
            return this.forwardToShow(registrations.iterator().next(), mapping, request);
        }
        RegistrationsBean bean = new RegistrationsBean();
        bean.setRegistrations(registrations);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("chooseRegistration");
    }

    public ActionForward generateKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserPrivateKey.generateNewKeyForUser(Authenticate.getUser());
        }
        catch (Exception E) {
            throw new DomainException("error.impossible.to.generate.sha256.key", new String[0]);
        }
        return this.redirect("/ICalTimeTable.do?method=show&registrationId=" + request.getParameter("registrationId"), request);
    }

    private ActionForward forwardToShow(Registration registration, ActionMapping mapping, HttpServletRequest request) throws Exception {
        request.setAttribute("registrationId", (Object)registration.getExternalId());
        UserPrivateKey privateKey = Authenticate.getUser().getPrivateKey();
        if (privateKey != null && privateKey.getPrivateKeyValidity() != null && privateKey.getPrivateKeyValidity().isAfter((ReadableInstant)new DateTime())) {
            if (privateKey.getPrivateKeyValidity() != null) {
                request.setAttribute("expirationDate", (Object)privateKey.getPrivateKeyValidity().toString("dd/MM/yyyy HH:mm"));
                request.setAttribute("user", (Object)Authenticate.getUser().getUsername());
                request.setAttribute("classURL", (Object)ICalStudentTimeTable.getUrl("syncClasses", registration, request));
                request.setAttribute("examsURL", (Object)ICalStudentTimeTable.getUrl("syncExams", registration, request));
            }
            request.setAttribute("stillValid", (Object)true);
        } else {
            request.setAttribute("stillValid", (Object)false);
            request.setAttribute("payload", (Object)"");
        }
        return mapping.findForward("viewOptions");
    }

    public static String calculatePayload(String to, Registration reg, User user) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        SecretKeySpec skeySpec = new SecretKeySpec(user.getPrivateKey().getPrivateKey(), "AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(("This is for " + to + " calendar ##1.6180339##Sistema Fenix##" + user.getPrivateKey().getPrivateKeyCreation().toString() + "##" + reg.getExternalId() + "##" + user.getPrivateKey().getPrivateKeyValidity().toString() + "#### This is for " + to + " calendar").getBytes(StandardCharsets.UTF_8));
        return Hashing.sha1().hashBytes(encrypted).toString();
    }

    public static String getUrl(String to, Registration registration, HttpServletRequest request) throws Exception {
        try {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String url = scheme + "://" + serverName + (serverPort == 80 || serverPort == 443 ? "" : ":" + serverPort) + request.getContextPath();
            url = url + "/external/iCalendarSync.do?method=" + to + "&user=" + Authenticate.getUser().getUsername() + "&registrationID=" + registration.getExternalId() + "&payload=" + ICalStudentTimeTable.calculatePayload(to, registration, Authenticate.getUser());
            return url;
        }
        catch (Exception e) {
            return null;
        }
    }
}

