/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.program;

import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramInformation;
import org.fenixedu.academic.domain.phd.PhdProgramInformationBean;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/phdProgramInformation", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="listPhdPrograms", path="/phd/academicAdminOffice/program/information/listPhdPrograms.jsp"), @Forward(name="listPhdProgramInformations", path="/phd/academicAdminOffice/program/information/listPhdProgramInformations.jsp"), @Forward(name="createPhdInformation", path="/phd/academicAdminOffice/program/information/createPhdInformation.jsp"), @Forward(name="editPhdProgramInformation", path="/phd/academicAdminOffice/program/information/editPhdProgramInformation.jsp")})
public class PhdProgramInformationDA
extends FenixDispatchAction {
    public ActionForward listPhdPrograms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdPrograms", AcademicAccessRule.getPhdProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESSES, Authenticate.getUser()).collect(Collectors.toSet()));
        return mapping.findForward("listPhdPrograms");
    }

    public ActionForward listPhdProgramInformations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdProgram", (Object)this.readPhdProgram(request));
        return mapping.findForward("listPhdProgramInformations");
    }

    private PhdProgram readPhdProgram(HttpServletRequest request) {
        return (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
    }

    private PhdProgramInformationBean readPhdInformationBean() {
        return (PhdProgramInformationBean)this.getRenderedObject("phdProgramInformationBean");
    }

    public ActionForward prepareCreatePhdInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = this.readPhdProgram(request);
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("phdProgramInformationBean", (Object)new PhdProgramInformationBean(phdProgram));
        return mapping.findForward("createPhdInformation");
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramInformationBean readPhdInformationBean = this.readPhdInformationBean();
        try {
            PhdProgramInformation.createInformation(readPhdInformationBean);
        }
        catch (PhdDomainOperationException e) {
            request.setAttribute("phdProgramInformationBean", (Object)readPhdInformationBean);
            this.setError(request, mapping, null, null, (Object)e);
            return mapping.findForward("createPhdInformation");
        }
        return this.listPhdProgramInformations(mapping, form, request, response);
    }

    public ActionForward createInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgram phdProgram = this.readPhdProgram(request);
        request.setAttribute("phdProgram", (Object)phdProgram);
        request.setAttribute("phdProgramInformationBean", (Object)this.readPhdInformationBean());
        return mapping.findForward("createPhdInformation");
    }

    public ActionForward prepareEditPhdProgramInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramInformation phdProgramInformation = this.readPhdProgramInformation(request);
        request.setAttribute("phdProgramInformation", (Object)phdProgramInformation);
        request.setAttribute("phdProgramInformationBean", (Object)new PhdProgramInformationBean(phdProgramInformation));
        return mapping.findForward("editPhdProgramInformation");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramInformation phdProgramInformation = this.readPhdProgramInformation(request);
        PhdProgramInformationBean readPhdInformationBean = this.readPhdInformationBean();
        try {
            phdProgramInformation.edit(readPhdInformationBean);
        }
        catch (PhdDomainOperationException e) {
            request.setAttribute("phdProgramInformation", (Object)phdProgramInformation);
            request.setAttribute("phdProgramInformationBean", (Object)readPhdInformationBean);
            this.setError(request, mapping, null, null, (Object)e);
            return mapping.findForward("editPhdProgramInformation");
        }
        return this.listPhdProgramInformations(mapping, form, request, response);
    }

    public ActionForward editInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramInformation phdProgramInformation = this.readPhdProgramInformation(request);
        request.setAttribute("phdProgramInformation", (Object)phdProgramInformation);
        request.setAttribute("phdProgramInformationBean", (Object)this.readPhdInformationBean());
        return mapping.findForward("editPhdProgramInformation");
    }

    private PhdProgramInformation readPhdProgramInformation(HttpServletRequest request) {
        return (PhdProgramInformation)((Object)this.getDomainObject(request, "phdProgramInformationId"));
    }
}

