/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.EmptyDegree;
import org.fenixedu.academic.domain.EmptyDegreeCurricularPlan;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.AggregateUnit;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManageAssociatedObjects$callable$createAcademicOffice;
import org.fenixedu.academic.ui.struts.action.manager.ManageAssociatedObjects$callable$createCompetenceCourseGroup;
import org.fenixedu.academic.ui.struts.action.manager.ManageAssociatedObjects$callable$createDepartment;
import org.fenixedu.academic.ui.struts.action.manager.ManageAssociatedObjects$callable$createEmptyDegree;
import org.fenixedu.academic.ui.struts.action.manager.ManageAssociatedObjects$callable$createScientificArea;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=ManagerApplications.ManagerSystemManagementApp.class, path="manage-associated-objects", titleKey="title.manage.associated.objects")
@Mapping(path="/manageAssociatedObjects", module="manager")
@Forwards(value={@Forward(name="show", path="/manager/listAssociatedObjects.jsp"), @Forward(name="list", path="/manager/listAssociatedObjects.jsp"), @Forward(name="createDepartment", path="/manager/createDepartment.jsp"), @Forward(name="createEmptyDegree", path="/manager/createEmptyDegree.jsp"), @Forward(name="createScientificArea", path="/manager/createScientificArea.jsp"), @Forward(name="editDepartment", path="/manager/editDepartment.jsp"), @Forward(name="createCompetenceCourseGroup", path="/manager/createCompetenceCourseGroup.jsp"), @Forward(name="associatePersonUnit", path="/manager/associatePersonUnit.jsp"), @Forward(name="createAcademicOffice", path="/manager/createAcademicOffice.jsp"), @Forward(name="createDegreeType", path="/manager/createDegreeType.jsp")})
public class ManageAssociatedObjects
extends FenixDispatchAction {
    public static final Advice advice$createDepartment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicOffice = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createEmptyDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createScientificArea = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createCompetenceCourseGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @EntryPoint
    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set departments = Bennu.getInstance().getDepartmentsSet();
        Set offices = Bennu.getInstance().getAdministrativeOfficesSet();
        request.setAttribute("departments", (Object)departments);
        request.setAttribute("offices", (Object)offices);
        request.setAttribute("emptyDegree", (Object)EmptyDegree.getInstance());
        request.setAttribute("degreeTypes", (Object)Bennu.getInstance().getDegreeTypeSet());
        return mapping.findForward("list");
    }

    public ActionForward prepareCreateDegreeType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeType currentType = (DegreeType)this.getDomainObject(request, "degreeTypeId");
        request.setAttribute("bean", (Object)(currentType == null ? new DegreeTypeBean() : new DegreeTypeBean(currentType)));
        return mapping.findForward("createDegreeType");
    }

    public ActionForward createDegreeType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeTypeBean bean = (DegreeTypeBean)this.getRenderedObject("bean");
        if (bean != null) {
            this.atomic(() -> {
                DegreeType type = bean.getSelected() == null ? new DegreeType(bean.getName()) : bean.getSelected();
                type.setName(bean.getName());
                type.setEmpty(bean.isEmpty());
                type.setBolonha(bean.isBolonha());
                type.setDegreeType(bean.isDegree());
                type.setMasterDegree(bean.isMasterDegree());
                type.setDea(bean.isDea());
                type.setDfa(bean.isDfa());
                type.setCycleTypes(bean.getCycleTypes());
                type.setCycleTypesToEnrol(bean.getCyclesToEnrol());
            });
        }
        return this.list(mapping, form, request, response);
    }

    public ActionForward prepareCreateDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("bean", (Object)new AssociatedObjectsBean());
        return mapping.findForward("createDepartment");
    }

    public ActionForward createDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject("department");
        this.createDepartment(bean);
        return this.list(mapping, form, request, response);
    }

    private void createDepartment(AssociatedObjectsBean associatedObjectsBean) {
        Object object = advice$createDepartment.perform((Callable)new ManageAssociatedObjects$callable$createDepartment(this, associatedObjectsBean));
    }

    static /* synthetic */ void advised$createDepartment(ManageAssociatedObjects this_, AssociatedObjectsBean bean) {
        Department department = new Department();
        department.setCompetenceCourseMembersGroup(RoleType.MANAGER.actualGroup());
        department.setActive(bean.isActive());
        department.setCode(bean.getCode());
        department.setName(bean.getName());
        department.setRealName(bean.getRealName());
        department.setName(bean.getName());
        department.setRealNameEn(bean.getRealNameEn());
        department.setRootDomainObject(Bennu.getInstance());
        Unit departmentParent = Bennu.getInstance().getInstitutionUnit().getSubUnits().stream().filter(x -> ((AggregateUnit)((Object)((Object)x))).getName().equals("Departments")).findAny().orElse(Bennu.getInstance().getInstitutionUnit());
        DepartmentUnit.createNewInternalDepartmentUnit(department.getNameI18n(), null, null, department.getCode(), new YearMonthDay(), null, departmentParent, AccountabilityType.readByType(AccountabilityTypeEnum.ACADEMIC_STRUCTURE), null, department, null, false, null);
    }

    public ActionForward prepareAcademicOffice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = new AssociatedObjectsBean();
        bean.setBuildings(Space.getAllSpaces().sorted().collect(Collectors.toList()));
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("createAcademicOffice");
    }

    public ActionForward createAcademicOffice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject("office");
        this.createAcademicOffice(bean);
        return this.list(mapping, form, request, response);
    }

    private void createAcademicOffice(AssociatedObjectsBean associatedObjectsBean) {
        Object object = advice$createAcademicOffice.perform((Callable)new ManageAssociatedObjects$callable$createAcademicOffice(this, associatedObjectsBean));
    }

    static /* synthetic */ void advised$createAcademicOffice(ManageAssociatedObjects this_, AssociatedObjectsBean bean) {
        AdministrativeOffice office = new AdministrativeOffice();
        office.setAdministrativeOfficeType(bean.getType());
        new AdministrativeOfficeServiceAgreementTemplate(office);
        office.setCampus(bean.getBuilding());
        office.setName(bean.getNameLS());
        office.setCoordinator(User.findByUsername((String)bean.getUsername()));
        office.setRootDomainObject(Bennu.getInstance());
        Unit servicesParent = Bennu.getInstance().getInstitutionUnit().getSubUnits().stream().filter(x -> x.getName().equals("Services")).findAny().orElse(Bennu.getInstance().getInstitutionUnit());
        Unit.createNewUnit(MultiLanguageString.fromLocalizedString(office.getName()), null, null, null, new YearMonthDay(), null, servicesParent, AccountabilityType.readByType(AccountabilityTypeEnum.ADMINISTRATIVE_STRUCTURE), null, UnitClassification.CENTRAL_ORG, office, false, bean.getBuilding());
    }

    public ActionForward prepareEmptyDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean associatedObjectsBean = new AssociatedObjectsBean();
        associatedObjectsBean.setOffices(Bennu.getInstance().getAdministrativeOfficesSet());
        request.setAttribute("bean", (Object)associatedObjectsBean);
        return mapping.findForward("createEmptyDegree");
    }

    public ActionForward createEmptyDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject("admOffice");
        this.createEmptyDegree(bean);
        return this.list(mapping, form, request, response);
    }

    private void createEmptyDegree(AssociatedObjectsBean associatedObjectsBean) {
        Object object = advice$createEmptyDegree.perform((Callable)new ManageAssociatedObjects$callable$createEmptyDegree(this, associatedObjectsBean));
    }

    static /* synthetic */ void advised$createEmptyDegree(ManageAssociatedObjects this_, AssociatedObjectsBean bean) {
        AdministrativeOffice adminOffice = bean.getOffice();
        EmptyDegree emptyDegree = EmptyDegree.getInstance();
        if (emptyDegree == null) {
            EmptyDegree.init();
        }
        EmptyDegree.getInstance().setAdministrativeOffice(adminOffice);
        EmptyDegreeCurricularPlan emptyDCP = EmptyDegreeCurricularPlan.getInstance();
        if (emptyDCP == null) {
            EmptyDegreeCurricularPlan.init();
        }
    }

    public ActionForward prepareAssociatePersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean associatedObjectsBean = new AssociatedObjectsBean();
        associatedObjectsBean.setUnits(Unit.readAllUnits());
        request.setAttribute("bean", (Object)associatedObjectsBean);
        return mapping.findForward("associatePersonUnit");
    }

    public ActionForward prepareCreateScientificArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean associatedObjectsBean = new AssociatedObjectsBean();
        request.setAttribute("bean", (Object)associatedObjectsBean);
        associatedObjectsBean.setDepartments(Department.readActiveDepartments().stream().filter(x -> x.getDepartmentUnit() != null).collect(Collectors.toList()));
        return mapping.findForward("createScientificArea");
    }

    public ActionForward createScientificArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject("admOffice");
        this.createScientificArea(bean);
        return this.list(mapping, form, request, response);
    }

    private void createScientificArea(AssociatedObjectsBean associatedObjectsBean) {
        Object object = advice$createScientificArea.perform((Callable)new ManageAssociatedObjects$callable$createScientificArea(this, associatedObjectsBean));
    }

    static /* synthetic */ void advised$createScientificArea(ManageAssociatedObjects this_, AssociatedObjectsBean bean) {
        ScientificAreaUnit.createNewInternalScientificArea(MultiLanguageString.fromLocalizedString(bean.getNameLS()), null, null, bean.getCode(), new YearMonthDay(), null, (Unit)((Object)bean.getDepartment().getDepartmentUnit()), AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE), null, null, false, null);
    }

    public ActionForward prepareCreateCompetenceCourseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean associatedObjectsBean = new AssociatedObjectsBean();
        associatedObjectsBean.setScientificAreaUnit((ScientificAreaUnit)FenixFramework.getDomainObject((String)request.getParameter("oid")));
        request.setAttribute("bean", (Object)associatedObjectsBean);
        return mapping.findForward("createCompetenceCourseGroup");
    }

    public ActionForward createCompetenceCourseGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject("admOffice");
        this.createCompetenceCourseGroup(bean);
        return this.list(mapping, form, request, response);
    }

    private void createCompetenceCourseGroup(AssociatedObjectsBean associatedObjectsBean) {
        Object object = advice$createCompetenceCourseGroup.perform((Callable)new ManageAssociatedObjects$callable$createCompetenceCourseGroup(this, associatedObjectsBean));
    }

    static /* synthetic */ void advised$createCompetenceCourseGroup(ManageAssociatedObjects this_, AssociatedObjectsBean bean) {
        CompetenceCourseGroupUnit.createNewInternalCompetenceCourseGroupUnit(MultiLanguageString.fromLocalizedString(bean.getNameLS()), null, null, bean.getCode(), new YearMonthDay(), null, (Unit)((Object)bean.getScientificAreaUnit()), AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE), null, null, false, null);
    }

    public ActionForward prepareEditDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean associatedObjectsBean = new AssociatedObjectsBean();
        Department d = (Department)FenixFramework.getDomainObject((String)request.getParameter("oid"));
        associatedObjectsBean.setDepartment(d);
        associatedObjectsBean.setCode(d.getCode());
        associatedObjectsBean.setName(d.getName());
        associatedObjectsBean.setRealName(d.getRealName());
        associatedObjectsBean.setRealNameEn(d.getRealNameEn());
        associatedObjectsBean.setUsername(d.getCompetenceCourseMembersGroup().getExpression());
        request.setAttribute("bean", (Object)associatedObjectsBean);
        return mapping.findForward("editDepartment");
    }

    public ActionForward editDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AssociatedObjectsBean bean = (AssociatedObjectsBean)this.getRenderedObject();
        this.atomic(() -> {
            Department d = bean.getDepartment();
            d.setCode(bean.getCode());
            d.setName(bean.getName());
            d.setRealName(bean.getRealName());
            d.setRealNameEn(bean.getRealNameEn());
            d.setCompetenceCourseMembersGroup(Group.parse((String)bean.getUsername()));
        });
        return this.list(mapping, form, request, response);
    }

    public static class DegreeTypeBean
    implements Serializable {
        private static final long serialVersionUID = 387599179531038042L;
        private LocalizedString name;
        private DegreeType selected;
        private boolean empty;
        private boolean bolonha = true;
        private boolean degree;
        private boolean masterDegree;
        private boolean dea;
        private boolean dfa;
        private List<CycleType> cycleTypes;
        private List<CycleType> cyclesToEnrol;

        public DegreeTypeBean() {
        }

        public DegreeTypeBean(DegreeType type) {
            this.selected = type;
            this.name = type.getName();
            this.empty = type.getEmpty();
            this.bolonha = type.getBolonha();
            this.degree = type.getDegreeType();
            this.masterDegree = type.getMasterDegree();
            this.dea = type.getDea();
            this.dfa = type.getDfa();
            this.cycleTypes = new ArrayList<CycleType>(type.getCycleTypes());
            this.cyclesToEnrol = new ArrayList<CycleType>(type.getSupportedCyclesToEnrol());
        }

        public LocalizedString getName() {
            return this.name;
        }

        public void setName(LocalizedString name) {
            this.name = name;
        }

        public DegreeType getSelected() {
            return this.selected;
        }

        public void setSelected(DegreeType selected) {
            this.selected = selected;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void setEmpty(boolean empty) {
            this.empty = empty;
        }

        public boolean isBolonha() {
            return this.bolonha;
        }

        public void setBolonha(boolean bolonha) {
            this.bolonha = bolonha;
        }

        public boolean isDegree() {
            return this.degree;
        }

        public void setDegree(boolean degree) {
            this.degree = degree;
        }

        public boolean isMasterDegree() {
            return this.masterDegree;
        }

        public void setMasterDegree(boolean masterDegree) {
            this.masterDegree = masterDegree;
        }

        public boolean isDea() {
            return this.dea;
        }

        public void setDea(boolean dea) {
            this.dea = dea;
        }

        public boolean isDfa() {
            return this.dfa;
        }

        public void setDfa(boolean dfa) {
            this.dfa = dfa;
        }

        public List<CycleType> getCycleTypes() {
            return this.cycleTypes;
        }

        public void setCycleTypes(List<CycleType> cycleTypes) {
            this.cycleTypes = cycleTypes;
        }

        public List<CycleType> getCyclesToEnrol() {
            return this.cyclesToEnrol;
        }

        public void setCyclesToEnrol(List<CycleType> cyclesToEnrol) {
            this.cyclesToEnrol = cyclesToEnrol;
        }

        public Collection<CycleType> getPossibleCycleTypes() {
            return Arrays.asList(CycleType.values());
        }
    }

    public static class AssociatedObjectsBean
    implements Serializable {
        private boolean active;
        private String code;
        private String name;
        private String realName;
        private String realNameEn;
        private YearMonthDay start;
        private AccountabilityTypeEnum accTypeEnum;
        private AdministrativeOfficeType type;
        private AdministrativeOffice office;
        private List<Unit> units = new ArrayList<Unit>();
        private Unit unit;
        private String username;
        private LocalizedString nameLS;
        private boolean teacher;
        private Space building;
        private List<Space> buildings;
        private Department department;
        private List<Department> departments;
        private final List<AdministrativeOffice> offices = new ArrayList<AdministrativeOffice>();
        public ScientificAreaUnit scientificAreaUnit;

        public Department getDepartment() {
            return this.department;
        }

        public void setDepartment(Department department) {
            this.department = department;
        }

        public List<Department> getDepartments() {
            return this.departments;
        }

        public void setDepartments(List<Department> departments) {
            this.departments = departments;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRealName() {
            return this.realName;
        }

        public void setRealName(String realName) {
            this.realName = realName;
        }

        public String getRealNameEn() {
            return this.realNameEn;
        }

        public void setRealNameEn(String realNameEn) {
            this.realNameEn = realNameEn;
        }

        public AdministrativeOfficeType getType() {
            return this.type;
        }

        public void setType(AdministrativeOfficeType type) {
            this.type = type;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public void setUnit(Unit unit) {
            this.unit = unit;
        }

        public List<Unit> getUnits() {
            return this.units;
        }

        public void setUnits(List<Unit> units) {
            this.units = units;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public YearMonthDay getStart() {
            return this.start;
        }

        public void setStart(YearMonthDay start) {
            this.start = start;
        }

        public AccountabilityTypeEnum getAccTypeEnum() {
            return this.accTypeEnum;
        }

        public void setAccTypeEnum(AccountabilityTypeEnum accTypeEnum) {
            this.accTypeEnum = accTypeEnum;
        }

        public boolean isTeacher() {
            return this.teacher;
        }

        public void setTeacher(boolean teacher) {
            this.teacher = teacher;
        }

        public AdministrativeOffice getOffice() {
            return this.office;
        }

        public void setOffice(AdministrativeOffice office) {
            this.office = office;
        }

        public List<AdministrativeOffice> getOffices() {
            return this.offices;
        }

        public void setOffices(Set<AdministrativeOffice> officesSet) {
            this.offices.addAll(officesSet);
        }

        public LocalizedString getNameLS() {
            return this.nameLS;
        }

        public void setNameLS(LocalizedString nameLS) {
            this.nameLS = nameLS;
        }

        public Space getBuilding() {
            return this.building;
        }

        public void setBuilding(Space building) {
            this.building = building;
        }

        public List<Space> getBuildings() {
            return this.buildings;
        }

        public void setBuildings(List<Space> buildings) {
            this.buildings = buildings;
        }

        public ScientificAreaUnit getScientificAreaUnit() {
            return this.scientificAreaUnit;
        }

        public void setScientificAreaUnit(ScientificAreaUnit scientificAreaUnit) {
            this.scientificAreaUnit = scientificAreaUnit;
        }
    }
}

