/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalServices.epfl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.util.MultiLanguageString;

public class ExportEPFLPhdProgramCandidacies {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] run() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, Charset.defaultCharset().name());
        try (PrintWriter writer = new PrintWriter(outputStreamWriter);){
            writer.println("<?xml version=\"1.0\" encoding=\"" + Charset.defaultCharset().name() + "\" ?>");
            writer.println("<data>");
            List<PhdIndividualProgramProcess> list = PhdIndividualProgramProcess.search(ExecutionYear.readCurrentExecutionYear(), new Predicate<PhdIndividualProgramProcess>(){

                @Override
                public boolean test(PhdIndividualProgramProcess t) {
                    if (t.getExecutionYear() != ExecutionYear.readCurrentExecutionYear()) {
                        return false;
                    }
                    if (!PhdIndividualProgramCollaborationType.EPFL.equals((Object)t.getCollaborationType())) {
                        return false;
                    }
                    return PhdIndividualProgramProcessState.CANDIDACY.equals(t.getActiveState());
                }
            });
            for (PhdIndividualProgramProcess process2 : list) {
                ExportEPFLPhdProgramCandidacies.writePersonInfo(process2, writer);
            }
            writer.println("</data>");
        }
        return outputStream.toByteArray();
    }

    private static void writePersonInfo(PhdIndividualProgramProcess process2, PrintWriter writer) {
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(1) + "<personne action=\"AUTO\">");
        Person person = process2.getPerson();
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + String.format("<nom>%s</nom>", person.getGivenNames()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + String.format("<prenom>%s</prenom>", person.getFamilyNames()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + String.format("<sexe>%s</sexe>", Gender.MALE.equals((Object)person.getGender()) ? "SEXH" : "SEXF"));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + String.format("<naissance>%s</naissance>", person.getDateOfBirthYearMonthDay().toString("dd.MM.yyyy")));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + "<detailPersonne action=\"AUTO\">");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + "<domaine>DOMAINEACADEMIQUE</domaine>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format("<datePersonne action=\"AUTO\" type=\"TYPE_DATE_ENTREE\">%s</datePersonne>", process2.getCandidacyProcess().getCandidacyDate().toString("dd.MM.yyyy")));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format("<lieuPersonne action=\"AUTO\" type=\"LIEUNAI\" identificationLieu=\"iso\" iso=\"%s\" typeLieu=\"PAYS\">%s</lieuPersonne>", person.getCountry().getCode(), person.getCountry().getCountryNationality().getContent(MultiLanguageString.en)));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format("<lieuPersonne action=\"AUTO\" type=\"LIEUNAIETRA\" typeLieu=\"LOCETRNONCON\" forceTo=\"LOCETRNONCON\">%s</lieuPersonne>", person.getDistrictSubdivisionOfBirth()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format("<lieuPersonne action=\"AUTO\" type=\"LIEUORI\" identificationLieu=\"iso\" iso=\"%s\" typeLieu=\"PAYS\">%s</lieuPersonne>", person.getCountry().getCode(), person.getCountry().getLocalizedName().getContent(MultiLanguageString.en)));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + "<adresse type=\"ADR_ECH\" action=\"AUTO\">");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + String.format("<ligne n=\"1\">%s</ligne>", person.getAddress()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + String.format("<localite typeLieu=\"LOCALITE;LOCETRNONCON\" identificationLieu=\"zip\" zip=\"%s\" b_returnfirst=\"1\">%s</localite>", person.getAreaCode(), person.getArea()));
        if (person.getCountryOfResidence() != null) {
            writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + String.format("<pays identificationLieu=\"iso\" iso=\"%s\" b_returnfirst=\"1\">%s</pays>", person.getCountryOfResidence().getCode(), person.getCountryOfResidence().getLocalizedName().getContent(MultiLanguageString.en)));
        } else {
            writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + "<pays identificationLieu=\"iso\" iso=\"\" b_returnfirst=\"1\"></pays>");
        }
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + String.format("<moyen action=\"AUTO\" type=\"EMAIL\">%s</moyen>", person.getEmail()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + String.format("<moyen action=\"AUTO\" type=\"PORTABLE\">%s</moyen>", person.getMobile()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + "</adresse>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + "</detailPersonne>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + "<inscription action=\"AUTO\">");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + "<gps domaine=\"DOMAINEACADEMIQUE\">");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + "<modelegps>CDOC</modelegps>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + "<unite type=\"ACAD\" format=\"LIBELLE\">IST-EPFL</unite>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + "<periode type=\"PEDAGO\" format=\"LIBCOU\">Eval sep</periode>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(4) + "<periode type=\"ACAD\">2010</periode>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + "</gps>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format(" <detail type=\"URL_IST-EPFL\">%s</detail>", ExportEPFLPhdProgramCandidacies.getUrlForProcess(process2)));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format(" <detail type=\"URL_IST-EPFL_DOCUMENTS\">%s</detail>", ExportEPFLPhdProgramCandidacies.getUrlForProcessDocs(process2)));
        Photograph photo = person.getPersonalPhotoEvenIfPending();
        if (photo != null) {
            writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format(" <detail type=\"URL_IST-EPFL_PHOTO\">%s</detail>", ExportEPFLPhdProgramCandidacies.getUrlForPhoto(photo)));
        }
        if (process2.getExternalPhdProgram() != null) {
            writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format("<detail type=\"PDOC_AT_EPFL\" format=\"COURTU\">%s</detail>", process2.getExternalPhdProgram().getAcronym()));
        }
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(3) + String.format(" <detail type=\"GPSDOMFOCUS\" conversion=\"IMPORT_IST:GPSDOMFOCUS\">%s</detail> ", process2.getPhdProgramFocusArea().getName()));
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(2) + "</inscription>");
        writer.println(ExportEPFLPhdProgramCandidacies.addTabs(1) + "</personne>");
    }

    private static String getUrlForProcess(PhdIndividualProgramProcess process2) {
        return String.format("https://fenix.ist.utl.pt/phd/epfl/applications/show?process=%s", process2.getCandidacyProcessHashCode().getValue());
    }

    private static String getUrlForProcessDocs(PhdIndividualProgramProcess process2) {
        return String.format("https://fenix.ist.utl.pt/phd/epfl/applications/candidateDocuments?candidateOid=%s", process2.getCandidacyProcessHashCode().getExternalId());
    }

    private static String getUrlForPhoto(Photograph photo) {
        return String.format("https://fenix.ist.utl.pt/phd/epfl/applications/photo?photoOid=%s", photo.getExternalId());
    }

    private static String addTabs(int level) {
        String returnString = "";
        for (int i = 1; i <= level; ++i) {
            returnString = returnString + '\t';
        }
        return returnString;
    }
}

