/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExportGrouping;
import org.fenixedu.academic.domain.ExportGrouping_Base;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.ui.spring.controller.teacher.AttendsBean;
import org.fenixedu.academic.ui.spring.controller.teacher.ExecutionCourseController;
import org.fenixedu.academic.ui.spring.controller.teacher.ProjectGroupBean;
import org.fenixedu.academic.ui.spring.controller.teacher.StudentGroupService;
import org.fenixedu.academic.ui.spring.controller.teacher.TeacherView;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.RedirectView;
import pt.ist.fenixframework.FenixFramework;

@Controller
@RequestMapping(value={"/teacher/{executionCourse}/student-groups/"})
public class GroupingController
extends ExecutionCourseController {
    @Autowired
    StudentGroupService studentGroupService;

    @Override
    protected Class<?> getFunctionalityType() {
        return ManageExecutionCourseDA.class;
    }

    @Override
    Boolean getPermission(Professorship prof) {
        return prof.getPermissions().getGroups();
    }

    @RequestMapping(value={"/show"}, method={RequestMethod.GET})
    public TeacherView showStudentGroups(Model model) {
        return new TeacherView("executionCourse/groupings/viewProjectsAndLink", this.executionCourse);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public TeacherView create(Model model) {
        model.addAttribute("projectGroup", (Object)new ProjectGroupBean(this.executionCourse));
        return new TeacherView("executionCourse/groupings/insertGroupProperties", this.executionCourse);
    }

    @RequestMapping(value={"/edit/{grouping}"}, method={RequestMethod.GET})
    public TeacherView edit(Model model, Grouping grouping) {
        model.addAttribute("projectGroup", (Object)new ProjectGroupBean(grouping, this.executionCourse));
        return new TeacherView("executionCourse/groupings/insertGroupProperties", this.executionCourse);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public AbstractUrlBasedView create(Model model, @ModelAttribute(value="projectGroup") ProjectGroupBean projectGroup, BindingResult bindingResult) {
        ShiftType shiftType;
        Grouping groupingWithSameName;
        ArrayList<String> errors = new ArrayList<String>();
        if (bindingResult.hasErrors()) {
            errors.add("error.groupProperties.errorsDetected");
        }
        if (projectGroup.getName().isEmpty()) {
            errors.add("error.groupProperties.missingName");
        }
        if ((groupingWithSameName = this.executionCourse.getGroupingByName(projectGroup.getName())) != null && !groupingWithSameName.getExternalId().equals(projectGroup.getExternalId())) {
            errors.add("error.exception.existing.groupProperties");
        }
        ShiftType shiftType2 = shiftType = projectGroup.getShiftType() == null || projectGroup.getShiftType().isEmpty() ? null : ShiftType.valueOf(projectGroup.getShiftType());
        if (projectGroup.getDifferentiatedCapacity().booleanValue() && projectGroup.getMaximumGroupCapacity() != null && projectGroup.getDifferentiatedCapacityShifts().entrySet().stream().anyMatch(entry -> ((Shift)FenixFramework.getDomainObject((String)((String)entry.getKey()))).getTypes().contains((Object)shiftType) && entry.getValue() != null && ((Shift)FenixFramework.getDomainObject((String)((String)entry.getKey()))).getLotacao() != 0 && (Integer)entry.getValue() * projectGroup.getMaximumGroupCapacity() > ((Shift)FenixFramework.getDomainObject((String)((String)entry.getKey()))).getLotacao())) {
            errors.add("error.groupProperties.capacityOverflow");
        }
        if (projectGroup.getMaximumGroupCapacity() == null || projectGroup.getMaximumGroupCapacity() < 0) {
            errors.add("error.groupProperties.capacity.negative");
        }
        if (projectGroup.getMinimumGroupCapacity() == null || projectGroup.getMinimumGroupCapacity() < 0) {
            errors.add("error.groupProperties.capacity.negative");
        }
        if (projectGroup.getMaxGroupNumber() == null || projectGroup.getMaxGroupNumber() < 0) {
            errors.add("error.groupProperties.capacity.negative");
        }
        if (projectGroup.getIdealGroupCapacity() != null && projectGroup.getIdealGroupCapacity() < 0) {
            errors.add("error.groupProperties.capacity.negative");
        }
        if (GroupingController.smallerThan(projectGroup.getMaximumGroupCapacity(), projectGroup.getMinimumGroupCapacity()).booleanValue()) {
            errors.add("error.groupProperties.minimum");
        }
        if (GroupingController.smallerThan(projectGroup.getMaximumGroupCapacity(), projectGroup.getIdealGroupCapacity()).booleanValue()) {
            errors.add("error.groupProperties.ideal.maximum");
        }
        if (GroupingController.smallerThan(projectGroup.getIdealGroupCapacity(), projectGroup.getMinimumGroupCapacity()).booleanValue()) {
            errors.add("error.groupProperties.ideal.minimum");
        }
        if (projectGroup.getEnrolmentBeginDay() == null) {
            errors.add("error.groupProperties.missingEnrolmentBeginDay");
        }
        if (projectGroup.getEnrolmentEndDay() == null) {
            errors.add("error.groupProperties.missingEnrolmentEndDay");
        }
        if (projectGroup.getEnrolmentEndDay() != null && projectGroup.getEnrolmentEndDay() != null && projectGroup.getEnrolmentEndDay().isBefore((ReadableInstant)projectGroup.getEnrolmentBeginDay())) {
            errors.add("error.manager.wrongDates");
        }
        if (!errors.isEmpty()) {
            model.addAttribute("errors", errors);
            return new TeacherView("executionCourse/groupings/insertGroupProperties", this.executionCourse);
        }
        Grouping grouping = this.studentGroupService.createOrEditGrouping(projectGroup, this.executionCourse);
        return new RedirectView("/teacher/" + this.executionCourse.getExternalId() + "/student-groups/view/" + grouping.getExternalId(), true);
    }

    private static Boolean smallerThan(Integer a, Integer b) {
        return a != null && b != null && a < b;
    }

    @RequestMapping(value={"/view/{grouping}"}, method={RequestMethod.GET})
    public TeacherView viewGrouping(Model model, @PathVariable Grouping grouping) {
        List<Object> shiftList = new ArrayList();
        if (grouping.getShiftType() != null) {
            shiftList = grouping.getExportGroupingsSet().stream().map(ExportGrouping_Base::getExecutionCourse).flatMap(ec -> ec.getAssociatedShifts().stream()).sorted(Shift.SHIFT_COMPARATOR_BY_NAME).filter(shift -> shift.containsType(grouping.getShiftType())).collect(Collectors.toList());
        }
        HashMap<Shift, TreeSet<StudentGroup>> studentGroupsByShift = new HashMap<Shift, TreeSet<StudentGroup>>();
        for (Shift shift2 : shiftList) {
            TreeSet<StudentGroup> tree = new TreeSet<StudentGroup>(StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
            tree.addAll(shift2.getAssociatedStudentGroups(grouping));
            studentGroupsByShift.put(shift2, tree);
        }
        if (shiftList.isEmpty()) {
            TreeSet<StudentGroup> studentGroups = new TreeSet<StudentGroup>(StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
            studentGroups.addAll(grouping.getStudentGroupsSet());
            model.addAttribute("studentGroups", studentGroups);
        }
        model.addAttribute("studentGroupsByShift", studentGroupsByShift);
        model.addAttribute("grouping", (Object)grouping);
        model.addAttribute("shifts", shiftList);
        return new TeacherView("executionCourse/groupings/viewShiftsAndGroups", this.executionCourse);
    }

    @RequestMapping(value={"/viewAttends/{grouping}"}, method={RequestMethod.GET})
    public TeacherView viewAttends(Model model, @PathVariable Grouping grouping) {
        model.addAttribute("grouping", (Object)grouping);
        ArrayList studentsNotAttending = new ArrayList();
        for (ExportGrouping exportGrouping : grouping.getExportGroupingsSet()) {
            if (exportGrouping.getProposalState().getState() != 2 && exportGrouping.getProposalState().getState() != 1) continue;
            exportGrouping.getExecutionCourse().getAttendsSet().stream().filter(attend -> !grouping.getAttendsSet().contains(attend)).forEach(attend -> studentsNotAttending.add(attend.getRegistration()));
        }
        model.addAttribute("studentsNotAttending", studentsNotAttending);
        return new TeacherView("executionCourse/groupings/viewAttendsSet", this.executionCourse);
    }

    @RequestMapping(value={"/editAttends/{grouping}"}, method={RequestMethod.POST})
    public TeacherView editAttends(Model model, @PathVariable Grouping grouping, @ModelAttribute(value="attends") @Validated AttendsBean attendsBean, BindingResult bindingResult) {
        Map<String, Boolean> studentsToRemove = attendsBean.getRemoveStudent();
        Map<String, Boolean> studentsToAdd = attendsBean.getAddStudent();
        if (bindingResult.hasErrors()) {
            model.addAttribute("removeStudent", studentsToRemove);
            model.addAttribute("addStudent", studentsToAdd);
            model.addAttribute("errors", (Object)("binding error " + bindingResult.getAllErrors()));
            return this.viewAttends(model, grouping);
        }
        this.studentGroupService.updateGroupingAttends(grouping, studentsToRemove, studentsToAdd);
        return this.viewAttends(model, grouping);
    }

    @RequestMapping(value={"/viewAllStudentsAndGroups/{grouping}"}, method={RequestMethod.GET})
    public TeacherView viewAllStudentsAndGroups(Model model, @PathVariable Grouping grouping) {
        model.addAttribute("grouping", (Object)grouping);
        model.addAttribute("studentsInStudentGroupsSize", (Object)grouping.getStudentGroupsSet().stream().mapToInt(sg -> sg.getAttendsSet().size()).sum());
        return new TeacherView("executionCourse/groupings/viewAllStudentsAndGroups", this.executionCourse);
    }

    @RequestMapping(value={"/viewStudentsAndGroupsByShift/{grouping}"}, method={RequestMethod.GET})
    public TeacherView viewStudentsAndGroupsByShift(Model model, @PathVariable Grouping grouping) {
        model.addAttribute("grouping", (Object)grouping);
        return new TeacherView("executionCourse/groupings/viewStudentsAndGroupsByShift", this.executionCourse);
    }

    @RequestMapping(value={"/viewStudentsAndGroupsByShift/{grouping}/shift/{shift}"}, method={RequestMethod.GET})
    public TeacherView viewStudentsAndGroupsByShift(Model model, @PathVariable Grouping grouping, @PathVariable Shift shift) {
        model.addAttribute("shift", (Object)shift);
        model.addAttribute("grouping", (Object)grouping);
        TreeSet<StudentGroup> studentsByGroup = new TreeSet<StudentGroup>(StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
        studentsByGroup.addAll(shift.getAssociatedStudentGroups(grouping));
        model.addAttribute("studentsByGroup", studentsByGroup);
        return new TeacherView("executionCourse/groupings/viewStudentsAndGroupsByShift", this.executionCourse);
    }

    @RequestMapping(value={"/deleteGrouping/{grouping}"}, method={RequestMethod.POST})
    public RedirectView deleteGrouping(Model model, @PathVariable Grouping grouping) {
        this.studentGroupService.deleteGrouping(grouping);
        return new RedirectView("/teacher/" + this.executionCourse.getExternalId() + "/student-groups/show", true);
    }
}

