/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.student.curriculum;

import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class CurriculumRenderer
extends InputRenderer {
    private String studentCurricularPlanClass = "scplan";
    private String curriculumGroupRowClass = "scplangroup";
    private String enrolmentRowClass = "scplanenrollment";
    private String dismissalRowClass = "scplandismissal";
    private String temporaryDismissalRowClass = "scplantemporarydismissal";
    private String cellClasses = "scplancolident, scplancolcurricularcourse, scplancoldegreecurricularplan, scplancolenrollmentstate, scplancolenrollmenttype, scplancolgrade, scplancolweight, scplancolects, scplancolenrolmentevaluationtype, scplancolyear, scplancolsemester, scplancolexamdate, scplancolgraderesponsible";
    private String selectionName;
    private boolean visibleCurricularYearEntries = true;
    private static Function<CurriculumRenderer, Layout> layoutProvider = renderer -> new AverageLayout((CurriculumRenderer)((Object)renderer));

    public boolean isVisibleCurricularYearEntries() {
        return this.visibleCurricularYearEntries;
    }

    public void setVisibleCurricularYearEntries(boolean visibleCurricularYearEntries) {
        this.visibleCurricularYearEntries = visibleCurricularYearEntries;
    }

    public String getTableClass() {
        return this.studentCurricularPlanClass;
    }

    public void setStudentCurricularPlanClass(String studentCurricularPlanClass) {
        this.studentCurricularPlanClass = studentCurricularPlanClass;
    }

    public String getHeaderRowClass() {
        return this.curriculumGroupRowClass;
    }

    public void setCurriculumGroupRowClass(String curriculumGroupRowClass) {
        this.curriculumGroupRowClass = curriculumGroupRowClass;
    }

    public String getEnrolmentRowClass() {
        return this.enrolmentRowClass;
    }

    public void setEnrolmentRowClass(String enrolmentRowClass) {
        this.enrolmentRowClass = enrolmentRowClass;
    }

    public String getDismissalRowClass() {
        return this.dismissalRowClass;
    }

    public void setDismissalRowClass(String dismissalRowClass) {
        this.dismissalRowClass = dismissalRowClass;
    }

    public String getTemporaryDismissalRowClass() {
        return this.temporaryDismissalRowClass;
    }

    public void setTemporaryDismissalRowClass(String temporaryDismissalRowClass) {
        this.temporaryDismissalRowClass = temporaryDismissalRowClass;
    }

    public void setCellClasses(String cellClasses) {
        this.cellClasses = cellClasses;
    }

    public String[] getCellClasses() {
        return this.cellClasses.split(",");
    }

    public String getTabCellClass() {
        return this.getCellClasses()[0];
    }

    public String getLabelCellClass() {
        return this.getCellClasses()[1];
    }

    public String getGradeCellClass() {
        return this.getCellClasses()[5];
    }

    public String getWeightCellClass() {
        return this.getCellClasses()[6];
    }

    public String getEctsCreditsCellClass() {
        return this.getCellClasses()[7];
    }

    public String getEnrolmentExecutionYearCellClass() {
        return this.getCellClasses()[9];
    }

    public String getEnrolmentSemesterCellClass() {
        return this.getCellClasses()[10];
    }

    public String getSelectionName() {
        return this.selectionName;
    }

    public void setSelectionName(String selectionName) {
        this.selectionName = selectionName;
    }

    public static void setLayoutProvider(Function<CurriculumRenderer, Layout> layoutProvider) {
        CurriculumRenderer.layoutProvider = layoutProvider;
    }

    protected Layout getLayout(Object object, Class type) {
        return layoutProvider.apply(this);
    }

    public static class AverageLayout
    extends Layout {
        private static final int MAX_COL_SPAN_FOR_TEXT_ON_CURRICULUM_LINES = 14;
        private CurriculumRenderer renderer;
        private Curriculum curriculum;

        public AverageLayout(CurriculumRenderer renderer) {
            this.renderer = renderer;
        }

        public HtmlComponent createComponent(Object object, Class type) {
            this.curriculum = (Curriculum)object;
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.curriculum == null) {
                container.addChild((HtmlComponent)this.createHtmlTextItalic(BundleUtil.getString((String)"resources.StudentResources", (String)"message.no.average", (String[])new String[0])));
                return container;
            }
            if (this.curriculum.isEmpty()) {
                container.addChild((HtmlComponent)this.createHtmlTextItalic(BundleUtil.getString((String)"resources.StudentResources", (String)"message.no.approvals", (String[])new String[0])));
                return container;
            }
            if (this.curriculum.getCurriculumEntries().isEmpty()) {
                container.addChild((HtmlComponent)this.createHtmlTextItalic(BundleUtil.getString((String)"resources.StudentResources", (String)"message.empty.curriculum", (String[])new String[0])));
            } else {
                HtmlBlockContainer averageContainer = new HtmlBlockContainer();
                averageContainer.setStyle("padding-bottom: 3.5em;");
                container.addChild((HtmlComponent)averageContainer);
                HtmlTable averageEntriesTable = new HtmlTable();
                averageContainer.addChild((HtmlComponent)averageEntriesTable);
                averageEntriesTable.setClasses(this.renderer.getTableClass());
                this.generateAverageRows(averageEntriesTable);
            }
            if (this.renderer.isVisibleCurricularYearEntries()) {
                HtmlBlockContainer curricularYearContainer = new HtmlBlockContainer();
                container.addChild((HtmlComponent)curricularYearContainer);
                HtmlTable curricularYearTable = new HtmlTable();
                curricularYearContainer.addChild((HtmlComponent)curricularYearTable);
                curricularYearTable.setClasses(this.renderer.getTableClass());
                this.generateCurricularYearRows(curricularYearTable);
                this.generateCurricularYearSums(curricularYearTable);
            }
            return container;
        }

        private HtmlText createHtmlTextItalic(String message) {
            HtmlText htmlText = new HtmlText(message);
            htmlText.setClasses("italic");
            return htmlText;
        }

        private void generateAverageRows(HtmlTable mainTable) {
            TreeSet<ICurriculumEntry> sortedIAverageEntries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            sortedIAverageEntries.addAll(this.curriculum.getEnrolmentRelatedEntries());
            if (!sortedIAverageEntries.isEmpty()) {
                this.generateGroupRowWithText(mainTable, "Inscri\u00e7\u00f5es", true, 0);
                this.generateRows(mainTable, sortedIAverageEntries, 0);
            }
            TreeSet<ICurriculumEntry> sortedEquivalenceEntries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            TreeSet<ICurriculumEntry> sortedSubstitutionsEntries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            for (ICurriculumEntry entry : this.curriculum.getDismissalRelatedEntries()) {
                if (entry instanceof Dismissal) {
                    sortedEquivalenceEntries.add(entry);
                    continue;
                }
                sortedSubstitutionsEntries.add(entry);
            }
            if (!sortedSubstitutionsEntries.isEmpty()) {
                this.generateGroupRowWithText(mainTable, "Substitui\u00e7\u00f5es", true, 0);
                this.generateRows(mainTable, sortedSubstitutionsEntries, 0);
            }
            if (!sortedEquivalenceEntries.isEmpty()) {
                this.generateGroupRowWithText(mainTable, "Equival\u00eancias", true, 0);
                this.generateRows(mainTable, sortedEquivalenceEntries, 0);
            }
        }

        private void generateGroupRowWithText(HtmlTable mainTable, String text, boolean addHeaders, int level) {
            HtmlTableRow groupRow = mainTable.createRow();
            groupRow.setClasses(this.renderer.getHeaderRowClass());
            HtmlTableCell textCell = groupRow.createCell();
            textCell.setText(text);
            textCell.setClasses(this.renderer.getLabelCellClass());
            textCell.setColspan(Integer.valueOf(14));
            this.generateCellWithText(groupRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade", (String[])new String[0]), this.renderer.getGradeCellClass());
            this.generateCellWithText(groupRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.weight", (String[])new String[0]), this.renderer.getEctsCreditsCellClass());
            HtmlTableCell executionYearCell = groupRow.createCell();
            executionYearCell.setText("Ano Lectivo");
            executionYearCell.setClasses(this.renderer.getGradeCellClass());
            executionYearCell.setColspan(Integer.valueOf(2));
        }

        private void generateRows(HtmlTable mainTable, Set<ICurriculumEntry> entries, int level) {
            for (ICurriculumEntry entry : entries) {
                this.generateRow(mainTable, entry, level, true);
            }
        }

        private void generateRow(HtmlTable mainTable, ICurriculumEntry entry, int level, boolean allowSelection) {
            HtmlTableRow enrolmentRow = mainTable.createRow();
            enrolmentRow.setClasses(this.renderer.getEnrolmentRowClass());
            this.generateCodeAndNameCell(enrolmentRow, entry, level, allowSelection);
            if (entry instanceof ExternalEnrolment) {
                this.generateExternalEnrolmentLabelCell(enrolmentRow, (ExternalEnrolment)entry, level);
            }
            this.generateGradeCell(enrolmentRow, entry);
            this.generateWeightCell(enrolmentRow, entry);
            this.generateExecutionYearCell(enrolmentRow, entry);
            this.generateSemesterCell(enrolmentRow, entry);
        }

        private void generateCodeAndNameCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry, int level, boolean allowSelection) {
            HtmlInlineContainer inlineContainer = new HtmlInlineContainer();
            inlineContainer.addChild((HtmlComponent)new HtmlText(this.getPresentationNameFor(entry)));
            HtmlTableCell cell = enrolmentRow.createCell();
            cell.setClasses(this.renderer.getLabelCellClass());
            cell.setColspan(Integer.valueOf(14 - (entry instanceof ExternalEnrolment ? 1 : 0) - level));
            cell.setBody((HtmlComponent)inlineContainer);
        }

        private String getPresentationNameFor(ICurriculumEntry entry) {
            String code;
            String string = code = !StringUtils.isEmpty((String)entry.getCode()) ? entry.getCode() + " - " : "";
            if (entry instanceof OptionalEnrolment) {
                OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)entry);
                return code + optionalEnrolment.getCurricularCourse().getNameI18N(entry.getExecutionPeriod()).getContent();
            }
            return code + entry.getName().getContent();
        }

        private void generateExternalEnrolmentLabelCell(HtmlTableRow externalEnrolmentRow, ExternalEnrolment externalEnrolment, int level) {
            this.generateCellWithText(externalEnrolmentRow, externalEnrolment.getDescription(), this.renderer.getLabelCellClass(), 1);
        }

        private void generateGradeCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry) {
            Grade grade = entry.getGrade();
            this.generateCellWithText(enrolmentRow, grade.isEmpty() ? "-" : grade.getValue(), this.renderer.getGradeCellClass());
        }

        private void generateWeightCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry) {
            this.generateCellWithText(enrolmentRow, entry.getGrade().isNumeric() ? entry.getWeigthForCurriculum().toString() : "-", this.renderer.getWeightCellClass());
        }

        private void generateEctsCreditsCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry) {
            this.generateCellWithText(enrolmentRow, entry.getEctsCreditsForCurriculum().toString(), this.renderer.getEctsCreditsCellClass());
        }

        private void generateExecutionYearCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry) {
            this.generateCellWithText(enrolmentRow, entry.getExecutionYear() == null ? "-" : entry.getExecutionYear().getYear(), this.renderer.getEnrolmentExecutionYearCellClass());
        }

        private void generateSemesterCell(HtmlTableRow enrolmentRow, ICurriculumEntry entry) {
            String semester = entry.getExecutionPeriod() == null ? "-" : entry.getExecutionPeriod().getSemester().toString() + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.semester.short", (String[])new String[0]);
            this.generateCellWithText(enrolmentRow, semester, this.renderer.getEnrolmentSemesterCellClass());
        }

        private void generateCellWithText(HtmlTableRow row, String text, String cssClass) {
            this.generateCellWithText(row, text, cssClass, 1);
        }

        private void generateCellWithText(HtmlTableRow row, String text, String cssClass, Integer colSpan) {
            HtmlTableCell cell = row.createCell();
            cell.setClasses(cssClass);
            cell.setText(text);
            cell.setColspan(colSpan);
        }

        private void generateCurricularYearRows(HtmlTable table) {
            TreeSet<ICurriculumEntry> sortedEntries = new TreeSet<ICurriculumEntry>(ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
            sortedEntries.addAll(this.curriculum.getCurricularYearEntries());
            if (!sortedEntries.isEmpty()) {
                this.generateCurricularYearHeaderRowWithText(table, "", true, 0);
                this.generateCurricularYearRows(table, sortedEntries, 0);
            }
        }

        private void generateCurricularYearHeaderRowWithText(HtmlTable table, String text, boolean addHeaders, int level) {
            HtmlTableRow groupRow = table.createRow();
            groupRow.setClasses(this.renderer.getHeaderRowClass());
            HtmlTableCell textCell = groupRow.createCell();
            textCell.setText(text);
            textCell.setClasses(this.renderer.getLabelCellClass());
            textCell.setRowspan(Integer.valueOf(2));
            textCell.setColspan(Integer.valueOf(14));
            HtmlTableCell curricularYearCell = groupRow.createCell();
            curricularYearCell.setText("Ano Curricular");
            curricularYearCell.setClasses(this.renderer.getGradeCellClass());
            curricularYearCell.setColspan(Integer.valueOf(1));
            HtmlTableCell executionYearCell = groupRow.createCell();
            executionYearCell.setText("Ano Lectivo");
            executionYearCell.setClasses(this.renderer.getGradeCellClass());
            executionYearCell.setColspan(Integer.valueOf(2));
            executionYearCell.setRowspan(Integer.valueOf(2));
            HtmlTableRow groupSubRow = table.createRow();
            groupSubRow.setClasses(this.renderer.getHeaderRowClass());
            this.generateCellWithText(groupSubRow, BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.ects", (String[])new String[0]), this.renderer.getEctsCreditsCellClass());
        }

        private void generateCurricularYearRows(HtmlTable mainTable, Set<ICurriculumEntry> entries, int level) {
            for (ICurriculumEntry entry : entries) {
                this.generateCurricularYearRow(mainTable, entry, level, true);
            }
        }

        private void generateCurricularYearRow(HtmlTable mainTable, ICurriculumEntry entry, int level, boolean allowSelection) {
            HtmlTableRow enrolmentRow = mainTable.createRow();
            enrolmentRow.setClasses(this.renderer.getEnrolmentRowClass());
            this.generateCodeAndNameCell(enrolmentRow, entry, level, allowSelection);
            if (entry instanceof ExternalEnrolment) {
                this.generateExternalEnrolmentLabelCell(enrolmentRow, (ExternalEnrolment)entry, level);
            }
            this.generateEctsCreditsCell(enrolmentRow, entry);
            this.generateExecutionYearCell(enrolmentRow, entry);
            this.generateSemesterCell(enrolmentRow, entry);
        }

        private void generateCurricularYearSums(HtmlTable mainTable) {
            HtmlTableRow row = mainTable.createRow();
            row.setClasses(this.renderer.getHeaderRowClass());
            HtmlTableCell sumsCell = row.createCell();
            sumsCell.setText("Somat\u00f3rios");
            sumsCell.setStyle("text-align: right;");
            sumsCell.setColspan(Integer.valueOf(14));
            HtmlTableCell sumEctsCreditsCell = row.createCell();
            sumEctsCreditsCell.setText(this.curriculum.getSumEctsCredits().toString());
            sumEctsCreditsCell.setClasses(this.renderer.getGradeCellClass());
            HtmlTableCell emptyCell = row.createCell();
            emptyCell.setClasses(this.renderer.getGradeCellClass());
            emptyCell.setColspan(Integer.valueOf(2));
        }
    }
}

