/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.teacher.gradeSubmission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.DataTranferObject;
import org.fenixedu.academic.dto.teacher.gradeSubmission.MarkSheetTeacherMarkBean;

public class MarkSheetTeacherGradeSubmissionBean
extends DataTranferObject {
    private ExecutionCourse executionCourse;
    private CurricularCourse selectedCurricularCourse;
    private Date evaluationDate;
    private Collection<MarkSheetTeacherMarkBean> marksToSubmit;
    private transient Teacher responsibleTeacher;

    public CurricularCourse getSelectedCurricularCourse() {
        return this.selectedCurricularCourse;
    }

    public void setSelectedCurricularCourse(CurricularCourse selectedCurricularCourse) {
        this.selectedCurricularCourse = selectedCurricularCourse;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public Collection<MarkSheetTeacherMarkBean> getMarksToSubmit() {
        return this.marksToSubmit;
    }

    public void setMarksToSubmit(Collection<MarkSheetTeacherMarkBean> marksToSubmit) {
        this.marksToSubmit = marksToSubmit;
    }

    public Date getEvaluationDate() {
        return this.evaluationDate;
    }

    public void setEvaluationDate(Date evaluationDate) {
        this.evaluationDate = evaluationDate;
    }

    public Collection<CurricularCourse> getAllCurricularCourses() {
        return this.getSelectedCurricularCourse() != null ? Collections.singletonList(this.getSelectedCurricularCourse()) : this.getExecutionCourse().getAssociatedCurricularCoursesSet();
    }

    public Collection<MarkSheetTeacherMarkBean> getSelectedMarksToSubmit() {
        ArrayList<MarkSheetTeacherMarkBean> result = new ArrayList<MarkSheetTeacherMarkBean>();
        for (MarkSheetTeacherMarkBean markBean : this.getMarksToSubmit()) {
            if (!markBean.isToSubmitMark()) continue;
            result.add(markBean);
        }
        return result;
    }

    public Teacher getResponsibleTeacher() {
        return this.responsibleTeacher;
    }

    public void setResponsibleTeacher(Teacher responsibleTeacher) {
        this.responsibleTeacher = responsibleTeacher;
    }

    public List<CurricularCourse> getCurricularCoursesAvailableToGradeSubmission() {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        for (CurricularCourse curricularCourse : this.getAllCurricularCourses()) {
            if (!curricularCourse.isGradeSubmissionAvailableFor(this.getExecutionCourse().getExecutionPeriod())) continue;
            result.add(curricularCourse);
        }
        return result;
    }
}

