/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.candidacy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.fenixedu.academic.domain.candidacy.CandidacyDocument;
import org.fenixedu.academic.domain.candidacy.CandidacyDocumentFile;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.academic.util.LabelFormatter;

public class CandidacyDocumentUploadBean
implements Serializable {
    private transient InputStream inputStream;
    private File temporaryFile;
    private String filename;
    private String documentDescription;
    private String actualFile;
    private CandidacyDocument candidacyDocument;

    public CandidacyDocumentUploadBean(CandidacyDocument candidacyDocument) {
        CandidacyDocumentFile file = candidacyDocument.getFile();
        this.documentDescription = candidacyDocument.getDocumentDescription();
        this.actualFile = file != null ? file.getFilename() + " - " + file.getCreationDate().toString("dd/MM/yyyy hh:mm") : null;
        this.candidacyDocument = candidacyDocument;
    }

    public String getActualFile() {
        return this.actualFile == null ? new LabelFormatter().appendLabel("label.file.not.uploaded.yet", "resources.CandidateResources").toString() : this.actualFile;
    }

    public CandidacyDocument getCandidacyDocument() {
        return this.candidacyDocument;
    }

    public InputStream getFileInputStream() {
        return this.inputStream;
    }

    public void setFileInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDocumentDescription() {
        return new LabelFormatter().appendLabel("label." + this.documentDescription, "resources.CandidateResources").toString();
    }

    public boolean getIsFileUploaded() {
        return this.actualFile != null;
    }

    public void createTemporaryFile() {
        try {
            this.temporaryFile = this.inputStream != null ? FileUtils.copyToTemporaryFile(this.inputStream) : null;
        }
        catch (IOException exception) {
            this.temporaryFile = null;
        }
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }

    public void deleteTemporaryFile() {
        this.temporaryFile.delete();
    }
}

