/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Senior_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class Senior
extends Senior_Base {
    public Senior(Registration registration) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRegistration(registration);
    }

    public void delete() {
        if (!this.isEmpty()) {
            throw new DomainException("error.Senior.not.empty", new String[0]);
        }
        super.setStudent(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public boolean isEmpty() {
        return !(this.getExpectedDegreeAverageGrade() != null || this.getExpectedDegreeTerminationDateTime() != null || this.getExtracurricularActivities() != null && !StringUtils.isEmpty((String)this.getExtracurricularActivities().trim()) || this.getInformaticsSkills() != null && !StringUtils.isEmpty((String)this.getInformaticsSkills().trim()) || this.getLanguageSkills() != null && !StringUtils.isEmpty((String)this.getLanguageSkills().trim()) || this.getProfessionalExperience() != null && !StringUtils.isEmpty((String)this.getProfessionalExperience().trim()) || this.getProfessionalInterests() != null && !StringUtils.isEmpty((String)this.getProfessionalInterests().trim()) || this.getSpecialtyField() != null && !StringUtils.isEmpty((String)this.getSpecialtyField().trim()));
    }

    public void setExpectedDegreeTerminationYearMonthDay(YearMonthDay date) {
        this.setExpectedDegreeTerminationDateTime(date != null ? date.toDateTimeAtMidnight() : null);
    }

    public YearMonthDay getExpectedDegreeTerminationYearMonthDay() {
        return this.getExpectedDegreeTerminationDateTime() != null ? this.getExpectedDegreeTerminationDateTime().toYearMonthDay() : null;
    }

    @Deprecated
    public void setStudent(Registration registration) {
        this.setRegistration(registration);
    }

    public void setRegistration(Registration registration) {
        if (registration == null) {
            throw new DomainException("error.senior.empty.senior", new String[0]);
        }
        super.setStudent(registration);
    }

    @Deprecated
    public Registration getStudent() {
        return this.getRegistration();
    }

    public Registration getRegistration() {
        return super.getStudent();
    }

    public Person getPerson() {
        return this.getRegistration().getPerson();
    }

    public void setExpectedDegreeAverageGrade(Integer expectedDegreeAverageGrade) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setExpectedDegreeAverageGrade(expectedDegreeAverageGrade);
    }

    public void setExpectedDegreeTerminationDateTime(DateTime expectedDegreeTerminationDateTime) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setExpectedDegreeTerminationDateTime(expectedDegreeTerminationDateTime);
    }

    public void setExtracurricularActivities(String extracurricularActivities) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setExtracurricularActivities(extracurricularActivities);
    }

    public void setInformaticsSkills(String informaticsSkills) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setInformaticsSkills(informaticsSkills);
    }

    public void setLanguageSkills(String languageSkills) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setLanguageSkills(languageSkills);
    }

    public void setProfessionalExperience(String professionalExperience) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setProfessionalExperience(professionalExperience);
    }

    public void setProfessionalInterests(String professionalInterests) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setProfessionalInterests(professionalInterests);
    }

    public void setSpecialtyField(String specialtyField) {
        this.setLastModificationDateDateTime(new DateTime());
        super.setSpecialtyField(specialtyField);
    }

    public boolean isSenior(ExecutionYear executionYear) {
        return this.getExpectedDegreeTerminationYearMonthDay().isAfter((ReadablePartial)executionYear.getBeginDateYearMonthDay());
    }

    @Deprecated
    public Date getExpectedDegreeTermination() {
        DateTime dt = this.getExpectedDegreeTerminationDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setExpectedDegreeTermination(Date date) {
        if (date == null) {
            this.setExpectedDegreeTerminationDateTime(null);
        } else {
            this.setExpectedDegreeTerminationDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getLastModificationDate() {
        DateTime dt = this.getLastModificationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setLastModificationDate(Date date) {
        if (date == null) {
            this.setLastModificationDateDateTime(null);
        } else {
            this.setLastModificationDateDateTime(new DateTime(date.getTime()));
        }
    }
}

