/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationProtocol$callable$addSupervisor;
import org.fenixedu.academic.domain.student.RegistrationProtocol$callable$removeSupervisor;
import org.fenixedu.academic.domain.student.RegistrationProtocol_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegistrationProtocol
extends RegistrationProtocol_Base
implements Comparable<RegistrationProtocol> {
    public static final Comparator<RegistrationProtocol> AGREEMENT_COMPARATOR;
    public static final Advice advice$addSupervisor;
    public static final Advice advice$removeSupervisor;

    @Override
    public int compareTo(RegistrationProtocol rp) {
        int c = this.getCode().compareTo(rp.getCode());
        return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)this, (DomainObject)rp) : c;
    }

    public RegistrationProtocol(String code, LocalizedString description, Boolean enrolmentByStudentAllowed, Boolean payGratuity, Boolean allowsIDCard, Boolean onlyAllowedDegreeEnrolment, Boolean isAlien, Boolean exempted, Boolean mobility, Boolean military, Boolean allowDissertationCandidacyWithoutChecks, Boolean forOfficialMobilityReporting, Boolean attemptAlmaMatterFromPrecedent) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCode(code);
        this.setDescription(description);
        this.setEnrolmentByStudentAllowed(enrolmentByStudentAllowed);
        this.setPayGratuity(payGratuity);
        this.setAllowsIDCard(allowsIDCard);
        this.setOnlyAllowedDegreeEnrolment(onlyAllowedDegreeEnrolment);
        this.setAlien(isAlien);
        this.setExempted(exempted);
        this.setMobility(mobility);
        this.setMilitary(military);
        this.setAllowDissertationCandidacyWithoutChecks(allowDissertationCandidacyWithoutChecks);
        this.setForOfficialMobilityReporting(forOfficialMobilityReporting);
        this.setAttemptAlmaMatterFromPrecedent(attemptAlmaMatterFromPrecedent);
    }

    public void addSupervisor(Person person) {
        Object object = advice$addSupervisor.perform((Callable)new RegistrationProtocol$callable$addSupervisor(this, person));
    }

    static /* synthetic */ void advised$addSupervisor(RegistrationProtocol this_, Person supervisor) {
        this_.addSupervisors(supervisor);
    }

    public void removeSupervisor(Person person) {
        Object object = advice$removeSupervisor.perform((Callable)new RegistrationProtocol$callable$removeSupervisor(this, person));
    }

    static /* synthetic */ void advised$removeSupervisor(RegistrationProtocol this_, Person supervisor) {
        this_.removeSupervisors(supervisor);
    }

    public static RegistrationProtocol getDefault() {
        return Bennu.getInstance().getRegistrationProtocolsSet().stream().filter(RegistrationProtocol_Base::getDefaultStatus).findFirst().orElse(null);
    }

    public void setDefaultStatus(boolean input) {
        if (input) {
            RegistrationProtocol current = RegistrationProtocol.getDefault();
            if (current != null) {
                throw new DomainException("error.RegistrationProtocol.default.duplicate", current.getDescription().getContent(), this.getDescription().getContent());
            }
            if (!this.isEnrolmentByStudentAllowed()) {
                throw new DomainException("error.RegistrationProtocol.default.required.EnrolmentByStudentAllowed", this.getDescription().getContent());
            }
            if (this.isAlien()) {
                throw new DomainException("error.RegistrationProtocol.default.not.Alien", this.getDescription().getContent());
            }
        }
        super.setDefaultStatus(input);
    }

    public boolean isAlien() {
        return this.getAlien() != null && this.getAlien() != false;
    }

    public boolean isEnrolmentByStudentAllowed() {
        return this.getEnrolmentByStudentAllowed() != null && this.getEnrolmentByStudentAllowed() != false;
    }

    public boolean isMilitaryAgreement() {
        return this.getMilitary() != null && this.getMilitary() != false;
    }

    public boolean isToPayGratuity() {
        return this.getPayGratuity() != null && this.getPayGratuity() != false;
    }

    public boolean allowDissertationCandidacyWithoutChecks() {
        return this.getAllowDissertationCandidacyWithoutChecks() != null && this.getAllowDissertationCandidacyWithoutChecks() != false;
    }

    public boolean isMobilityAgreement() {
        return this.getMobility() != null && this.getMobility() != false;
    }

    public boolean isOnlyAllowedDegreeEnrolment() {
        return this.getOnlyAllowedDegreeEnrolment() != null && this.getOnlyAllowedDegreeEnrolment() != false;
    }

    public boolean isExempted() {
        return this.getExempted() != null && this.getExempted() != false;
    }

    public boolean isForOfficialMobilityReporting() {
        return this.getForOfficialMobilityReporting() != null && this.getForOfficialMobilityReporting() != false;
    }

    public boolean allowsIDCard() {
        return this.getAllowsIDCard() != null && this.getAllowsIDCard() != false;
    }

    public boolean attemptAlmaMatterFromPrecedent() {
        return this.getAttemptAlmaMatterFromPrecedent() != null && this.getAttemptAlmaMatterFromPrecedent() != false;
    }

    static {
        advice$addSupervisor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeSupervisor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        AGREEMENT_COMPARATOR = new Comparator<RegistrationProtocol>(){

            @Override
            public int compare(RegistrationProtocol o1, RegistrationProtocol o2) {
                return o1.compareTo(o2);
            }
        };
    }
}

