/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalCourseLoadRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class ExternalCourseLoadRequest
extends ExternalCourseLoadRequest_Base {
    protected ExternalCourseLoadRequest() {
    }

    public ExternalCourseLoadRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setNumberOfCourseLoads(bean.getNumberOfCourseLoads());
        super.setInstitution(bean.getInstitution());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getNumberOfCourseLoads() == null || bean.getNumberOfCourseLoads() == 0) {
            throw new DomainException("error.ExternalCourseLoadRequest.invalid.numberOfCourseLoads", new String[0]);
        }
        if (bean.getInstitution() == null) {
            throw new DomainException("error.ExternalCourseLoadRequest.invalid.institution", new String[0]);
        }
    }

    public Set<Enrolment> getEnrolmentsSet() {
        return Collections.unmodifiableSet(super.getEnrolmentsSet());
    }

    public void addEnrolments(Enrolment enrolments) {
        throw new DomainException("error.ExternalCourseLoadRequest.cannot.add.enrolments", new String[0]);
    }

    public void removeEnrolments(Enrolment enrolments) {
        throw new DomainException("error.ExternalCourseLoadRequest.cannot.remove.enrolments", new String[0]);
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.EXTERNAL_COURSE_LOAD;
    }

    public EventType getEventType() {
        return EventType.EXTERNAL_COURSE_LOAD_REQUEST;
    }

    protected void disconnect() {
        super.setInstitution(null);
        super.disconnect();
    }
}

