/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.academic.domain.reports.SummaryOccupancyReportFile_Base;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

public class SummaryOccupancyReportFile
extends SummaryOccupancyReportFile_Base {
    public String getJobName() {
        return "Listagem de Presencas em Aulas com base em Sumarios";
    }

    protected String getPrefix() {
        return "summaryOccupancy";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        spreadsheet.setHeader("Ano Lectivo");
        spreadsheet.setHeader("Semestre");
        spreadsheet.setHeader("C\u00f3digo Execu\u00e7\u00e3o Disciplina");
        spreadsheet.setHeader("Nome da Disciplina");
        spreadsheet.setHeader("Tipo do Turno");
        spreadsheet.setHeader("Turno");
        spreadsheet.setHeader("ID Docente");
        spreadsheet.setHeader("Nome do Docente");
        spreadsheet.setHeader("Horario");
        spreadsheet.setHeader("Sala");
        spreadsheet.setHeader("Numero Presencas");
        for (ExecutionSemester executionSemester : this.getExecutionYear().getExecutionPeriodsSet()) {
            for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
                for (Summary summary : executionCourse.getAssociatedSummariesSet()) {
                    Spreadsheet.Row row = spreadsheet.addRow();
                    row.setCell(this.getExecutionYear().getYear());
                    row.setCell(executionSemester.getSemester());
                    row.setCell(GepReportFile.getExecutionCourseCode(executionCourse));
                    row.setCell(executionCourse.getName());
                    LessonInstance lessonInstance = summary.getLessonInstance();
                    CourseLoad courseLoad = lessonInstance == null ? null : lessonInstance.getCourseLoad();
                    ShiftType shiftType = courseLoad == null ? null : courseLoad.getType();
                    row.setCell(shiftType == null ? "" : shiftType.getName());
                    Shift shift = summary.getShift();
                    row.setCell(shift == null ? "" : shift.getNome());
                    row.setCell(this.getTeacherId(summary));
                    row.setCell(this.getTeacherName(summary));
                    row.setCell(this.getSchedule(summary));
                    Space room = summary.getRoom();
                    row.setCell(room == null ? "" : room.getName());
                    row.setCell(summary.getStudentsNumber());
                }
            }
        }
    }

    private String getSchedule(Summary summary) {
        LessonInstance lessonInstance = summary.getLessonInstance();
        if (lessonInstance != null) {
            DateTime begin = lessonInstance.getBeginDateTime();
            DateTime end = lessonInstance.getEndDateTime();
            return begin.toString("yyyy-MM-dd HH:mm - ") + end.toString("yyyy-MM-dd HH:mm");
        }
        DateTime summaryDateTime = summary.getSummaryDateTime();
        return summaryDateTime.toString("yyyy-MM-dd HH:mm");
    }

    private String getTeacherName(Summary summary) {
        Professorship professorship = summary.getProfessorship();
        if (professorship != null) {
            return professorship.getPerson().getName();
        }
        Teacher teacher = summary.getTeacher();
        if (teacher != null) {
            return teacher.getPerson().getName();
        }
        return summary.getTeacherName();
    }

    private String getTeacherId(Summary summary) {
        Professorship professorship = summary.getProfessorship();
        if (professorship != null) {
            return professorship.getPerson().getUsername();
        }
        Teacher teacher = summary.getTeacher();
        if (teacher != null) {
            return teacher.getPerson().getUsername();
        }
        return null;
    }
}

