/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.phd.ExternalPhdParticipant;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.reports.RaidesPhdReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaidesPhdReportFile
extends RaidesPhdReportFile_Base {
    private static final Logger logger = LoggerFactory.getLogger(RaidesPhdReportFile.class);

    public String getJobName() {
        return "Listagem RAIDES - PHD";
    }

    protected String getPrefix() {
        return "phdRAIDES";
    }

    public DegreeType getDegreeType() {
        return DegreeType.matching(DegreeType::isAdvancedSpecializationDiploma).get();
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        ExecutionYear executionYear = this.getExecutionYear();
        int civilYear = executionYear.getBeginCivilYear();
        this.fillSpreadsheet(spreadsheet);
        logger.info("BEGIN report for " + this.getDegreeType().getName().getContent());
        List<PhdIndividualProgramProcess> retrieveProcesses = this.retrieveProcesses(executionYear);
        for (PhdIndividualProgramProcess phdIndividualProgramProcess : retrieveProcesses) {
            LocalDate conclusionDate;
            if (phdIndividualProgramProcess.isConcluded() && ((conclusionDate = phdIndividualProgramProcess.getThesisProcess().getConclusionDate()) == null || conclusionDate.getYear() != civilYear && conclusionDate.getYear() != civilYear - 1 && conclusionDate.getYear() != civilYear + 1) || !phdIndividualProgramProcess.isConcluded() && !phdIndividualProgramProcess.getHasStartedStudies()) continue;
            this.reportRaidesGraduate(spreadsheet, phdIndividualProgramProcess, executionYear);
        }
    }

    private List<PhdIndividualProgramProcess> retrieveProcesses(ExecutionYear executionYear) {
        ArrayList<PhdIndividualProgramProcess> phdIndividualProgramProcessList = new ArrayList<PhdIndividualProgramProcess>();
        for (PhdProgram program : Bennu.getInstance().getPhdProgramsSet()) {
            phdIndividualProgramProcessList.addAll(program.getIndividualProgramProcessesSet());
        }
        return phdIndividualProgramProcessList;
    }

    private Set<StudentCurricularPlan> getStudentCurricularPlansToProcess(ExecutionYear executionYear) {
        HashSet<StudentCurricularPlan> result = new HashSet<StudentCurricularPlan>();
        this.collectStudentCurricularPlansFor(executionYear, result);
        if (executionYear.getPreviousExecutionYear() != null) {
            this.collectStudentCurricularPlansFor(executionYear.getPreviousExecutionYear(), result);
        }
        return result;
    }

    private void collectStudentCurricularPlansFor(ExecutionYear executionYear, Set<StudentCurricularPlan> result) {
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesByType(this.getDegreeType())) {
            result.addAll(executionDegree.getDegreeCurricularPlan().getStudentCurricularPlansSet());
        }
    }

    private String getReportName(String prefix, ExecutionYear executionYear) {
        StringBuilder result = new StringBuilder();
        result.append(new LocalDateTime().toString("yyyyMMddHHmm"));
        result.append("_").append(prefix).append("_").append(executionYear.getName().replace('/', '_'));
        return result.toString();
    }

    private void fillSpreadsheet(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("Matriculado de acordo com o plano de estudos?");
        spreadsheet.setHeader("ciclo");
        spreadsheet.setHeader("conclu\u00eddo (ano anterior)?");
        spreadsheet.setHeader("m\u00e9dia do ciclo");
        spreadsheet.setHeader("Data de conclus\u00e3o");
        spreadsheet.setHeader("Data de In\u00edcio");
        spreadsheet.setHeader("n\u00famero aluno");
        spreadsheet.setHeader("tipo identifica\u00e7\u00e3o");
        spreadsheet.setHeader("n\u00famero identifica\u00e7\u00e3o");
        spreadsheet.setHeader("digitos controlo");
        spreadsheet.setHeader("vers\u00e3o doc identifica\u00e7\u00e3o");
        spreadsheet.setHeader("nome");
        spreadsheet.setHeader("g\u00e9nero");
        spreadsheet.setHeader("data nascimento");
        spreadsheet.setHeader("pa\u00eds nascimento");
        spreadsheet.setHeader("pa\u00eds nacionalidade");
        spreadsheet.setHeader("sigla programa doutoral");
        spreadsheet.setHeader("programa doutoral");
        spreadsheet.setHeader("tipo curso");
        spreadsheet.setHeader("nome curso");
        spreadsheet.setHeader("sigla curso");
        spreadsheet.setHeader("ramo");
        spreadsheet.setHeader("n\u00ba. anos lectivos inscri\u00e7\u00e3o curso actual");
        spreadsheet.setHeader("\u00daltimo ano inscrito neste curso");
        spreadsheet.setHeader("estabelecimento habl anterior compl");
        spreadsheet.setHeader("curso habl anterior compl");
        spreadsheet.setHeader("estado civil");
        spreadsheet.setHeader("pa\u00eds resid\u00eancia permanente");
        spreadsheet.setHeader("distrito resid\u00eancia permanente");
        spreadsheet.setHeader("concelho resid\u00eancia permanente");
        spreadsheet.setHeader("deslocado resid\u00eancia permanente");
        spreadsheet.setHeader("n\u00edvel escolaridade pai");
        spreadsheet.setHeader("n\u00edvel escolaridade m\u00e3e");
        spreadsheet.setHeader("condi\u00e7\u00e3o perante profiss\u00e3o pai");
        spreadsheet.setHeader("condi\u00e7\u00e3o perante profiss\u00e3o m\u00e3e");
        spreadsheet.setHeader("profiss\u00e3o pai");
        spreadsheet.setHeader("profiss\u00e3o m\u00e3e");
        spreadsheet.setHeader("profiss\u00e3o aluno");
        spreadsheet.setHeader("Data preenchimento dados RAIDES");
        spreadsheet.setHeader("estatuto trabalhador estudante introduzido (info. RAIDES)");
        spreadsheet.setHeader("bolseiro (info. RAIDES)");
        spreadsheet.setHeader("bolseiro (info. oficial)");
        spreadsheet.setHeader("Grau Precedente");
        spreadsheet.setHeader("grau habl anterior compl");
        spreadsheet.setHeader("outro grau habl anterior compl");
        spreadsheet.setHeader("pa\u00eds habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("pa\u00eds habilita\u00e7\u00e3o 12\u00ba ano ou equivalente");
        spreadsheet.setHeader("ano de conclus\u00e3o da habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("nota da habilita\u00e7\u00e3o anterior");
        spreadsheet.setHeader("N\u00ba inscri\u00e7\u00f5es no curso preced.");
        spreadsheet.setHeader("Dura\u00e7\u00e3o programa mobilidade");
        spreadsheet.setHeader("tipo estabelecimento ensino secund\u00e1rio");
        spreadsheet.setHeader("total ECTS inscritos no ano");
        spreadsheet.setHeader("total ECTS conclu\u00eddos fim ano lectivo anterior (1\u00ba Semestre do ano lectivo actual)");
        spreadsheet.setHeader("total ECTS equival\u00eancia/substitui\u00e7\u00e3o/dispensa");
        spreadsheet.setHeader("total ECTS necess\u00e1rios para a conclus\u00e3o");
        spreadsheet.setHeader("doutoramento: inscrito parte curricular");
        spreadsheet.setHeader("n\u00ba doutoramento");
        spreadsheet.setHeader("istId orientadores");
        spreadsheet.setHeader("istId co-orientadores");
        spreadsheet.setHeader("Nome do Orientador Externo");
        spreadsheet.setHeader("Nome do Co-Orientador Externo");
        spreadsheet.setHeader("estado processo doutoramento");
        spreadsheet.setHeader("Ambito");
        spreadsheet.setHeader("data de candidatura");
        spreadsheet.setHeader("data de homologa\u00e7\u00e3o");
        spreadsheet.setHeader("data de inicio dos estudos");
        spreadsheet.setHeader("data e hora da prova");
        spreadsheet.setHeader("tipo de acordo");
        spreadsheet.setHeader("Data de Apresenta\u00e7\u00e3o P\u00fablica da CAT");
    }

    private void reportRaidesGraduate(Spreadsheet spreadsheet, PhdIndividualProgramProcess process2, ExecutionYear executionYear) {
        String grade;
        YearMonthDay registrationConclusionDate;
        Spreadsheet.Row row = spreadsheet.addRow();
        Person graduate = process2.getPerson();
        PersonalInformationBean personalInformationBean = process2.getPersonalInformationBean(executionYear);
        Registration registration = process2.getRegistration();
        boolean concluded = process2.isConcluded();
        LocalDate conclusionDate = process2.getConclusionDate();
        if (registration != null && !registration.isBolonha()) {
            return;
        }
        YearMonthDay yearMonthDay = registrationConclusionDate = registration != null ? registration.getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getConclusionDate() : null;
        if (registration != null && registrationConclusionDate == null) {
            registrationConclusionDate = registration.getLastStudentCurricularPlan().calculateConclusionDate(CycleType.THIRD_CYCLE);
        }
        row.setCell(String.valueOf(registration != null && !registration.isCanceled()));
        row.setCell(CycleType.THIRD_CYCLE.getDescription());
        row.setCell(String.valueOf(process2.isConcluded()));
        String string = grade = concluded ? process2.getFinalGrade().getLocalizedName() : "n/a";
        if (concluded && registration != null && registration.isConcluded()) {
            grade = grade + " " + registration.getLastStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getCurriculum(registrationConclusionDate.toDateTimeAtMidnight()).getRawGrade().getValue();
        }
        row.setCell(grade);
        row.setCell(conclusionDate != null ? conclusionDate.toString("dd-MM-yyyy") : "");
        row.setCell(process2.getCandidacyDate().toString("dd-MM-yyyy"));
        row.setCell(process2.getStudent().getNumber());
        row.setCell(graduate.getIdDocumentType().getLocalizedName());
        row.setCell(graduate.getDocumentIdNumber());
        row.setCell(graduate.getIdentificationDocumentExtraDigitValue());
        row.setCell(graduate.getIdentificationDocumentSeriesNumberValue());
        row.setCell(registration != null ? registration.getName() : (process2.getPerson() != null ? process2.getPerson().getName() : "n/a"));
        row.setCell(graduate.getGender().toString());
        row.setCell(graduate.getDateOfBirthYearMonthDay() != null ? graduate.getDateOfBirthYearMonthDay().toString("dd-MM-yyyy") : "n/a");
        row.setCell(graduate.getCountryOfBirth() != null ? graduate.getCountryOfBirth().getName() : "n/a");
        row.setCell(graduate.getCountry() != null ? graduate.getCountry().getName() : "n/a");
        row.setCell(process2.getPhdProgram().getAcronym());
        row.setCell(process2.getPhdProgram().getName().getContent());
        row.setCell(registration != null ? registration.getDegreeType().getName().getContent() : "n/a");
        row.setCell(registration != null ? registration.getDegree().getNameI18N().getContent() : "n/a");
        row.setCell(registration != null ? registration.getDegree().getSigla() : "n/a");
        row.setCell("n\u00e3o determin\u00e1vel");
        if (registration != null) {
            row.setCell(Integer.valueOf(this.calculateNumberOfEnrolmentYears(registration, executionYear)));
            row.setCell(registration.getLastEnrolmentExecutionYear() != null ? registration.getLastEnrolmentExecutionYear().getName() : "");
        } else {
            row.setCell("n/a");
            row.setCell("n/a");
        }
        row.setCell(personalInformationBean.getInstitution() != null ? personalInformationBean.getInstitution().getName() : "");
        row.setCell(personalInformationBean.getDegreeDesignation());
        row.setCell(personalInformationBean.getMaritalStatus() != null ? personalInformationBean.getMaritalStatus().toString() : process2.getPerson().getMaritalStatus().toString());
        if (personalInformationBean.getCountryOfResidence() != null) {
            row.setCell(personalInformationBean.getCountryOfResidence().getName());
        } else {
            row.setCell(process2.getStudent().getPerson().getCountryOfResidence() != null ? process2.getStudent().getPerson().getCountryOfResidence().getName() : "");
        }
        if (personalInformationBean.getDistrictSubdivisionOfResidence() != null) {
            row.setCell(personalInformationBean.getDistrictSubdivisionOfResidence().getDistrict().getName());
        } else {
            row.setCell(process2.getStudent().getPerson().getDistrictOfResidence());
        }
        if (personalInformationBean.getDistrictSubdivisionOfResidence() != null) {
            row.setCell(personalInformationBean.getDistrictSubdivisionOfResidence().getName());
        } else {
            row.setCell(process2.getStudent().getPerson().getDistrictSubdivisionOfResidence());
        }
        if (personalInformationBean.getDislocatedFromPermanentResidence() != null) {
            row.setCell(personalInformationBean.getDislocatedFromPermanentResidence().toString());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherSchoolLevel() != null) {
            row.setCell(personalInformationBean.getFatherSchoolLevel().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherSchoolLevel() != null) {
            row.setCell(personalInformationBean.getMotherSchoolLevel().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getFatherProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getMotherProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getFatherProfessionType() != null) {
            row.setCell(personalInformationBean.getFatherProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getMotherProfessionType() != null) {
            row.setCell(personalInformationBean.getMotherProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getProfessionType() != null) {
            row.setCell(personalInformationBean.getProfessionType().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getLastModifiedDate() != null) {
            DateTime dateTime = personalInformationBean.getLastModifiedDate();
            row.setCell(dateTime.getYear() + "-" + dateTime.getMonthOfYear() + "-" + dateTime.getDayOfMonth());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getProfessionalCondition() != null) {
            row.setCell(personalInformationBean.getProfessionalCondition().getName());
        } else {
            row.setCell("");
        }
        if (personalInformationBean.getGrantOwnerType() != null) {
            row.setCell(personalInformationBean.getGrantOwnerType().getName());
        } else {
            row.setCell("");
        }
        boolean sasFound = false;
        for (StudentStatute statute : process2.getStudent().getStudentStatutesSet()) {
            if (!statute.getType().isGrantOwnerStatute() || !statute.isValidInExecutionPeriod(executionYear.getFirstExecutionPeriod())) continue;
            sasFound = true;
            break;
        }
        row.setCell(String.valueOf(sasFound));
        row.setCell(personalInformationBean.getPrecedentSchoolLevel() != null ? personalInformationBean.getPrecedentSchoolLevel().getName() : "");
        row.setCell(personalInformationBean.getSchoolLevel() != null ? personalInformationBean.getSchoolLevel().getName() : "");
        row.setCell(personalInformationBean.getOtherSchoolLevel() != null ? personalInformationBean.getOtherSchoolLevel() : "");
        row.setCell(personalInformationBean.getCountryWhereFinishedPreviousCompleteDegree() != null ? personalInformationBean.getCountryWhereFinishedPreviousCompleteDegree().getName() : "");
        row.setCell(personalInformationBean.getCountryWhereFinishedHighSchoolLevel() != null ? personalInformationBean.getCountryWhereFinishedHighSchoolLevel().getName() : "");
        row.setCell(personalInformationBean.getConclusionYear());
        row.setCell(personalInformationBean.getConclusionGrade() != null ? personalInformationBean.getConclusionGrade() : "");
        row.setCell(personalInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree() != null ? personalInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree().toString() : "");
        row.setCell(personalInformationBean.getMobilityProgramDuration() != null ? BundleUtil.getString((String)"resources.EnumerationResources", (String)personalInformationBean.getMobilityProgramDuration().name(), (String[])new String[0]) : "");
        if (personalInformationBean.getHighSchoolType() != null) {
            row.setCell(personalInformationBean.getHighSchoolType().getName());
        } else {
            row.setCell("");
        }
        double totalEctsConcludedUntilPreviousYear = 0.0;
        if (registration != null) {
            double totalCreditsEnrolled = 0.0;
            for (Enrolment enrollment : registration.getLastStudentCurricularPlan().getEnrolmentsByExecutionYear(executionYear)) {
                totalCreditsEnrolled += enrollment.getEctsCredits().doubleValue();
            }
            row.setCell(Double.valueOf(totalCreditsEnrolled));
            for (CycleCurriculumGroup cycleCurriculumGroup : registration.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops()) {
                totalEctsConcludedUntilPreviousYear += cycleCurriculumGroup.getCreditsConcluded(executionYear).doubleValue();
            }
            row.setCell(Double.valueOf(totalEctsConcludedUntilPreviousYear));
            double totalCreditsDismissed = 0.0;
            for (Credits credits : registration.getLastStudentCurricularPlan().getCreditsSet()) {
                if (!credits.isEquivalence()) continue;
                totalCreditsDismissed += credits.getEnrolmentsEcts().doubleValue();
            }
            row.setCell(Double.valueOf(totalCreditsDismissed));
        } else {
            row.setCell("n/a");
            row.setCell("n/a");
            row.setCell("n/a");
        }
        if (registration != null) {
            if (concluded) {
                row.setCell(Integer.valueOf(0));
            } else {
                row.setCell(Double.valueOf(registration.getLastStudentCurricularPlan().getRoot().getDefaultEcts(executionYear) - totalEctsConcludedUntilPreviousYear));
            }
        } else {
            row.setCell("n/a");
        }
        if (registration != null && registration.isDEA()) {
            row.setCell(String.valueOf(registration.getLastStudentCurricularPlan().hasEnrolments(executionYear)));
        } else {
            row.setCell("not PhD");
        }
        row.setCell(process2.getPhdStudentNumber());
        int count = 0;
        StringBuilder guidings = new StringBuilder();
        for (PhdParticipant phdParticipant : process2.getGuidingsSet()) {
            if (!phdParticipant.isInternal()) continue;
            if (count > 0) {
                guidings.append(";");
            }
            guidings.append(((InternalPhdParticipant)((Object)phdParticipant)).getPerson().getUsername());
            ++count;
        }
        row.setCell(guidings.toString());
        int countAssistantGuidings = 0;
        StringBuilder assistantGuidings = new StringBuilder();
        for (PhdParticipant phdParticipant : process2.getAssistantGuidingsSet()) {
            if (!phdParticipant.isInternal()) continue;
            if (countAssistantGuidings > 0) {
                assistantGuidings.append(";");
            }
            assistantGuidings.append(((InternalPhdParticipant)((Object)phdParticipant)).getPerson().getUsername());
            ++countAssistantGuidings;
        }
        row.setCell(assistantGuidings.toString());
        int countExternalGuidings = 0;
        StringBuilder externalGuidingNames = new StringBuilder();
        for (PhdParticipant phdParticipant : process2.getGuidingsSet()) {
            if (phdParticipant.isInternal()) continue;
            if (countExternalGuidings > 0) {
                externalGuidingNames.append(";");
            }
            externalGuidingNames.append(((ExternalPhdParticipant)((Object)phdParticipant)).getName());
            externalGuidingNames.append(" (");
            externalGuidingNames.append(((ExternalPhdParticipant)((Object)phdParticipant)).getInstitution());
            externalGuidingNames.append(")");
            ++countExternalGuidings;
        }
        row.setCell(externalGuidingNames.toString());
        int countExternalAssistantGuidings = 0;
        StringBuilder externalAssistantGuidingNames = new StringBuilder();
        for (PhdParticipant phdParticipant : process2.getAssistantGuidingsSet()) {
            if (phdParticipant.isInternal()) continue;
            if (countExternalAssistantGuidings > 0) {
                externalAssistantGuidingNames.append(";");
            }
            externalAssistantGuidingNames.append(((ExternalPhdParticipant)((Object)phdParticipant)).getName());
            externalAssistantGuidingNames.append(" (");
            externalAssistantGuidingNames.append(((ExternalPhdParticipant)((Object)phdParticipant)).getInstitution());
            externalAssistantGuidingNames.append(")");
            ++countExternalAssistantGuidings;
        }
        row.setCell(externalAssistantGuidingNames.toString());
        PhdProgramProcessState lastActiveState = process2.getMostRecentState();
        row.setCell(lastActiveState != null ? lastActiveState.getType().getLocalizedName() : "n/a");
        if (process2.getCollaborationType() != null) {
            row.setCell(process2.getCollaborationType().getLocalizedName());
        } else {
            row.setCell("n/a");
        }
        if (process2.getCandidacyDate() != null) {
            row.setCell(process2.getCandidacyDate().toString("dd/MM/yyyy"));
        } else {
            row.setCell("n/a");
        }
        if (process2.getCandidacyProcess().getWhenRatified() != null) {
            row.setCell(process2.getCandidacyDate().toString("dd/MM/yyyy"));
        } else {
            row.setCell("n/a");
        }
        if (process2.getWhenStartedStudies() != null) {
            row.setCell(process2.getWhenStartedStudies().toString("dd/MM/yyyy"));
        } else {
            row.setCell("n/a");
        }
        if (process2.getThesisProcess() != null && process2.getThesisProcess().getDiscussionDate() != null) {
            row.setCell(process2.getThesisProcess().getDiscussionDate().toString("dd/MM/yyyy"));
        } else {
            row.setCell("n/a");
        }
        row.setCell(registration != null ? (registration.getRegistrationProtocol() != null ? registration.getRegistrationProtocol().getCode() : "") : "");
        if (process2.getSeminarProcess() != null && process2.getSeminarProcess().getPresentationDate() != null) {
            row.setCell(process2.getSeminarProcess().getPresentationDate().toString("dd/MM/yyyy"));
        } else {
            row.setCell("n/a");
        }
    }

    private int calculateNumberOfEnrolmentYears(Registration registration, ExecutionYear executionYear) {
        return registration.getNumberOfYearsEnrolledUntil(executionYear);
    }
}

