/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.enrolments;

import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.enrolments.PhdValidCurricularCoursesRule;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentManager;

public class PhdStudentCurricularPlanEnrolmentManager
extends StudentCurricularPlanEnrolmentManager {
    public PhdStudentCurricularPlanEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertOtherRolesPreConditions() {
        if (!this.isResponsiblePersonCoordinator()) {
            super.assertOtherRolesPreConditions();
        }
    }

    @Override
    protected void addRuntimeRules(Set<ICurricularRule> curricularRules, CurricularCourse curricularCourse) {
        super.addRuntimeRules(curricularRules, curricularCourse);
        if (this.mustValidateCurricularCourses()) {
            curricularRules.add(new PhdValidCurricularCoursesRule(curricularCourse));
        }
    }

    private boolean mustValidateCurricularCourses() {
        if (this.getRegistration().getPhdIndividualProgramProcess() == null) {
            return false;
        }
        return this.getRegistration().getPhdIndividualProgramProcess().hasCurricularCoursesToEnrol();
    }

    @Override
    protected RuleResult evaluateExtraRules(RuleResult actualResult) {
        return actualResult;
    }

    @Override
    protected EnrollmentCondition getEnrolmentCondition(Enrolment enrolment, EnrolmentResultType resultType) {
        if (enrolment == null) {
            return this.isResponsiblePersonStudent() ? EnrollmentCondition.TEMPORARY : super.getEnrolmentCondition(enrolment, resultType);
        }
        return this.wasPerformedByStudent(enrolment) ? EnrollmentCondition.TEMPORARY : super.getEnrolmentCondition(enrolment, resultType);
    }

    private boolean wasPerformedByStudent(Enrolment enrolment) {
        Person person = Person.readPersonByUsername(enrolment.getCreatedBy());
        return RoleType.STUDENT.isMember(person.getUser()) && enrolment.getStudent().equals((Object)person.getStudent());
    }
}

