/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.log;

import java.util.Date;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.CurriculumLineLog_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public abstract class CurriculumLineLog
extends CurriculumLineLog_Base {
    protected CurriculumLineLog() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setDateDateTime(new DateTime());
    }

    protected void init(EnrolmentAction action, Registration registration, DegreeModule degreeModule, ExecutionSemester executionSemester, String who) {
        this.checkParameters(action, registration, degreeModule, executionSemester);
        this.setAction(action);
        this.setStudent(registration);
        this.setDegreeModule(degreeModule);
        this.setExecutionPeriod(executionSemester);
        this.setWho(who);
    }

    private void checkParameters(EnrolmentAction action, Registration registration, DegreeModule degreeModule, ExecutionSemester executionSemester) {
        String[] args = new String[]{};
        if (action == null) {
            throw new DomainException("error.log.EnrolmentLog.invalid.action", args);
        }
        String[] args1 = new String[]{};
        if (registration == null) {
            throw new DomainException("error.log.EnrolmentLog.invalid.registration", args1);
        }
        String[] args2 = new String[]{};
        if (degreeModule == null) {
            throw new DomainException("error.log.DismissalLog.invalid.degreeModule", args2);
        }
        String[] args3 = new String[]{};
        if (executionSemester == null) {
            throw new DomainException("error.log.EnrolmentLog.invalid.executionSemester", args3);
        }
    }

    public void delete() {
        this.disconnect();
        super.deleteDomainObject();
    }

    protected void disconnect() {
        this.setRootDomainObject(null);
        this.setStudent(null);
        this.setDegreeModule(null);
        this.setExecutionPeriod(null);
    }

    public abstract String getDescription();

    public boolean isFor(ExecutionSemester executionSemester) {
        return this.getExecutionPeriod() == executionSemester;
    }

    @Deprecated
    public Date getDate() {
        DateTime dt = this.getDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setDate(Date date) {
        if (date == null) {
            this.setDateDateTime(null);
        } else {
            this.setDateDateTime(new DateTime(date.getTime()));
        }
    }
}

