/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.MinimumNumberOfCreditsToEnrol_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;

public class MinimumNumberOfCreditsToEnrol
extends MinimumNumberOfCreditsToEnrol_Base {
    private MinimumNumberOfCreditsToEnrol(Double minimumNumberOfCredits) {
        this.checkCredits(minimumNumberOfCredits);
        this.setMinimumCredits(minimumNumberOfCredits);
        this.setCurricularRuleType(CurricularRuleType.MINIMUM_NUMBER_OF_CREDITS_TO_ENROL);
    }

    private void checkCredits(Double minimumNumberOfCredits) throws DomainException {
        if (minimumNumberOfCredits == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    public MinimumNumberOfCreditsToEnrol(DegreeModule degreeModuleToApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Double minimumNumberOfCredits) {
        this(minimumNumberOfCredits);
        this.init(degreeModuleToApplyRule, contextCourseGroup, begin, end);
    }

    protected void edit(CourseGroup contextCourseGroup, Double minimumNumberOfCredits) {
        this.checkCredits(minimumNumberOfCredits);
        this.setContextCourseGroup(contextCourseGroup);
        this.setMinimumCredits(minimumNumberOfCredits);
    }

    protected void removeOwnParameters() {
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.minimumNumberOfCreditsToEnrol", true));
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inGroup", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    public boolean allowCredits(Double credits) {
        return credits >= this.getMinimumCredits();
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

