/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.standalone;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcess;
import org.fenixedu.academic.dto.commons.CurricularCourseByExecutionSemesterBean;
import org.fenixedu.academic.dto.commons.SearchCurricularCourseByDegree;
import org.joda.time.LocalDate;

public class StandaloneIndividualCandidacyProcessBean
extends IndividualCandidacyProcessBean {
    private SearchCurricularCourseByDegree searchCurricularCourseByDegree;
    private List<CurricularCourseByExecutionSemesterBean> curricularCourseBeans;

    public StandaloneIndividualCandidacyProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.setCurricularCourseBeans(new ArrayList<CurricularCourseByExecutionSemesterBean>(4));
    }

    public StandaloneIndividualCandidacyProcessBean(StandaloneIndividualCandidacyProcess process2) {
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setCurricularCourseBeans(process2.getCurricularCourseBeans());
    }

    public StandaloneCandidacyProcess getCandidacyProcess() {
        return (StandaloneCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    public ExecutionSemester getCandidacyExecutionInterval() {
        return (ExecutionSemester)((Object)super.getCandidacyExecutionInterval());
    }

    public SearchCurricularCourseByDegree getSearchCurricularCourseByDegree() {
        return this.searchCurricularCourseByDegree;
    }

    public void setSearchCurricularCourseByDegree(SearchCurricularCourseByDegree searchCurricularCourseByDegree) {
        this.searchCurricularCourseByDegree = searchCurricularCourseByDegree;
    }

    public List<CurricularCourseByExecutionSemesterBean> getCurricularCourseBeans() {
        return this.curricularCourseBeans;
    }

    public void setCurricularCourseBeans(List<CurricularCourseByExecutionSemesterBean> curricularCourseBeans) {
        this.curricularCourseBeans = curricularCourseBeans;
    }

    public List<CurricularCourse> getCurricularCourses() {
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>(this.getCurricularCourseBeans().size());
        for (CurricularCourseByExecutionSemesterBean bean : this.getCurricularCourseBeans()) {
            result.add(bean.getCurricularCourse());
        }
        return result;
    }

    public void addSelectedCurricularCourseToResult() {
        if (this.getSearchCurricularCourseByDegree().hasCurricularCourseBean() && !this.containsCurricularCourseByDegree()) {
            this.curricularCourseBeans.add(this.getSearchCurricularCourseByDegree().getCurricularCourseBean());
        }
    }

    private boolean containsCurricularCourseByDegree() {
        return this.curricularCourseBeans.contains(this.getSearchCurricularCourseByDegree().getCurricularCourseBean());
    }

    public void removeCurricularCourseFromResult(CurricularCourseByExecutionSemesterBean bean) {
        this.curricularCourseBeans.remove(bean);
    }

    public String getTotalEctsCredits() {
        double total = 0.0;
        for (CurricularCourseByExecutionSemesterBean bean : this.curricularCourseBeans) {
            total += bean.getCurricularCourseEcts().doubleValue();
        }
        return String.valueOf(total);
    }

    @Override
    public boolean isStandalone() {
        return true;
    }
}

