/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile$callable$createCandidacyDocument;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class IndividualCandidacyDocumentFile
extends IndividualCandidacyDocumentFile_Base {
    public static final Advice advice$createCandidacyDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected IndividualCandidacyDocumentFile() {
        this.setCandidacyFileActive(Boolean.TRUE);
    }

    protected IndividualCandidacyDocumentFile(IndividualCandidacyDocumentFileType type, byte[] contents, String filename) {
        this();
        this.setCandidacyFileActive(Boolean.TRUE);
        this.setCandidacyFileType(type);
        this.init(filename, filename, contents);
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    public static IndividualCandidacyDocumentFile createCandidacyDocument(byte[] byArray, String string, IndividualCandidacyDocumentFileType individualCandidacyDocumentFileType, String string2, String string3) {
        return (IndividualCandidacyDocumentFile)((Object)advice$createCandidacyDocument.perform((Callable)new IndividualCandidacyDocumentFile$callable$createCandidacyDocument(byArray, string, individualCandidacyDocumentFileType, string2, string3)));
    }

    static /* synthetic */ IndividualCandidacyDocumentFile advised$createCandidacyDocument(byte[] contents, String filename, IndividualCandidacyDocumentFileType type, String processName, String documentIdNumber) {
        return new IndividualCandidacyDocumentFile(type, contents, filename);
    }

    public boolean isAccessible(User user) {
        if (user == null || user.getPerson() == null) {
            return false;
        }
        Person person = user.getPerson();
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, person.getUser()).collect(Collectors.toSet())) {
            for (IndividualCandidacy individualCandidacy : this.getIndividualCandidacySet()) {
                if (!individualCandidacy.getAllDegrees().contains((Object)program)) continue;
                return true;
            }
        }
        if (RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(person.getUser())) {
            return true;
        }
        for (IndividualCandidacy individualCandidacy : this.getIndividualCandidacySet()) {
            for (Degree degree : individualCandidacy.getAllDegrees()) {
                if (!degree.isCurrentCoordinator(person)) continue;
                return true;
            }
        }
        if (person.getTeacher() != null && !person.getTeacher().getMobilityCoordinationsSet().isEmpty()) {
            return true;
        }
        for (IndividualCandidacy individualCandidacy : this.getIndividualCandidacySet()) {
            IndividualCandidacyPersonalDetails personalDetails = individualCandidacy.getPersonalDetails();
            if (personalDetails == null || !person.equals((Object)personalDetails.getPerson())) continue;
            return true;
        }
        return false;
    }
}

