/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.rectorate.RectoratePaymentCode;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectoratePaymentCodeGenerator
extends PaymentCodeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RectoratePaymentCodeGenerator.class);
    public static Comparator<PaymentCode> COMPARATOR_BY_PAYMENT_SEQUENTIAL_DIGITS = new Comparator<PaymentCode>(){

        @Override
        public int compare(PaymentCode leftPaymentCode, PaymentCode rightPaymentCode) {
            String leftSequentialNumber = RectoratePaymentCodeGenerator.getSequentialNumber(leftPaymentCode);
            String rightSequentialNumber = RectoratePaymentCodeGenerator.getSequentialNumber(rightPaymentCode);
            int comparationResult = leftSequentialNumber.compareTo(rightSequentialNumber);
            logger.info("left [{}], right [{}], result [{}]", new Object[]{leftSequentialNumber, rightSequentialNumber, comparationResult});
            return comparationResult == 0 ? leftPaymentCode.getExternalId().compareTo(rightPaymentCode.getExternalId()) : comparationResult;
        }
    };
    private static final String CODE_FILLER = "0";
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 6;
    private static final String START = "9";

    @Override
    public boolean canGenerateNewCode(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode();
        return lastPaymentCode == null ? true : Integer.valueOf(RectoratePaymentCodeGenerator.getSequentialNumber(lastPaymentCode)) < 999999;
    }

    private PaymentCode findLastPaymentCode() {
        List<RectoratePaymentCode> rectoratePaymentCodes = RectoratePaymentCode.getAllRectoratePaymentCodes();
        return rectoratePaymentCodes.isEmpty() ? null : Collections.max(rectoratePaymentCodes, COMPARATOR_BY_PAYMENT_SEQUENTIAL_DIGITS);
    }

    @Override
    public String generateNewCodeFor(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode();
        int nextSequentialNumber = lastPaymentCode == null ? 0 : Integer.valueOf(RectoratePaymentCodeGenerator.getSequentialNumber(lastPaymentCode)) + 1;
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)6, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        return START + sequentialNumberPadded + controDigitsPadded;
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentCode paymentCode) {
        return paymentCode.getCode().startsWith(START);
    }

    private static String getSequentialNumber(PaymentCode paymentCode) {
        String sequentialNumber = paymentCode.getCode().substring(1, paymentCode.getCode().length() - 2);
        return sequentialNumber;
    }
}

