/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.ImprovementOfApprovedEnrolmentEvent;
import org.fenixedu.academic.domain.accounting.events.ImprovementOfApprovedEnrolmentPenaltyExemption;
import org.fenixedu.academic.domain.accounting.postingRules.ImprovementOfApprovedEnrolmentPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class ImprovementOfApprovedEnrolmentPR
extends ImprovementOfApprovedEnrolmentPR_Base {
    protected ImprovementOfApprovedEnrolmentPR() {
    }

    public ImprovementOfApprovedEnrolmentPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        super.init(EntryType.IMPROVEMENT_OF_APPROVED_ENROLMENT_FEE, EventType.IMPROVEMENT_OF_APPROVED_ENROLMENT, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(fixedAmount, fixedAmountPenalty);
        super.setFixedAmount(fixedAmount);
        super.setFixedAmountPenalty(fixedAmountPenalty);
    }

    private void checkParameters(Money fixedAmount, Money fixedAmountPenalty) {
        if (fixedAmount == null) {
            throw new DomainException("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.fixedAmount.cannot.be.null", new String[0]);
        }
        if (fixedAmountPenalty == null) {
            throw new DomainException("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.fixedAmountPenalty.cannot.be.null", new String[0]);
        }
    }

    public void setFixedAmountPenalty(Money fixedAmountPenalty) {
        throw new DomainException("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.cannot.modify.fixedAmountPenalty", new String[0]);
    }

    public ImprovementOfApprovedEnrolmentPR edit(Money fixedAmount, Money fixedAmountPenalty) {
        this.deactivate();
        return new ImprovementOfApprovedEnrolmentPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, fixedAmountPenalty);
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        ImprovementOfApprovedEnrolmentEvent improvementOfApprovedEnrolmentEvent = (ImprovementOfApprovedEnrolmentEvent)((Object)event);
        boolean hasPenalty = this.hasPenalty(event, when);
        Money result = Money.ZERO;
        for (int i = 0; i < improvementOfApprovedEnrolmentEvent.getImprovementEnrolmentEvaluationsSet().size(); ++i) {
            result = result.add(hasPenalty ? this.getFixedAmountPenalty() : this.getFixedAmount());
        }
        return result;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        return amountToPay;
    }

    private boolean hasPenalty(Event event, DateTime when) {
        if (event.hasAnyPenaltyExemptionsFor(ImprovementOfApprovedEnrolmentPenaltyExemption.class)) {
            return false;
        }
        ImprovementOfApprovedEnrolmentEvent improvementOfApprovedEnrolmentEvent = (ImprovementOfApprovedEnrolmentEvent)((Object)event);
        Set enrolmentEvaluations = improvementOfApprovedEnrolmentEvent.getImprovementEnrolmentEvaluationsSet();
        if (enrolmentEvaluations.isEmpty()) {
            return false;
        }
        return !this.getEnrolmentPeriodInImprovementOfApprovedEnrolment((EnrolmentEvaluation)((Object)enrolmentEvaluations.iterator().next())).containsDate(when);
    }

    private EnrolmentPeriodInImprovementOfApprovedEnrolment getEnrolmentPeriodInImprovementOfApprovedEnrolment(EnrolmentEvaluation enrolmentEvaluation) {
        DegreeCurricularPlan degreeCurricularPlan = enrolmentEvaluation.getDegreeCurricularPlan();
        EnrolmentPeriod enrolmentPeriodInImprovementOfApprovedEnrolment = enrolmentEvaluation.getExecutionPeriod().getEnrolmentPeriod(EnrolmentPeriodInImprovementOfApprovedEnrolment.class, degreeCurricularPlan);
        if (enrolmentPeriodInImprovementOfApprovedEnrolment == null) {
            throw new DomainException("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.enrolmentPeriodInImprovementOfApprovedEnrolment.must.not.be.null", new String[0]);
        }
        return (EnrolmentPeriodInImprovementOfApprovedEnrolment)((Object)enrolmentPeriodInImprovementOfApprovedEnrolment);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(event, when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, totalAmountToPay, Money.ZERO, totalAmountToPay, event.getDescriptionForEntryType(this.getEntryType()), totalAmountToPay));
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.compareTo(this.calculateTotalAmountToPay(event, when)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.ImprovementOfApprovedEnrolmentPR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }
}

