/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes;

import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.GratuitySituationPaymentCode_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class GratuitySituationPaymentCode
extends GratuitySituationPaymentCode_Base {
    protected GratuitySituationPaymentCode() {
    }

    private GratuitySituationPaymentCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, GratuitySituation gratuitySituation) {
        this();
        this.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, student, gratuitySituation);
    }

    private void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, GratuitySituation gratuitySituation) {
        super.init(paymentCodeType, startDate, endDate, minAmount, maxAmount, student.getPerson());
        this.checkParameters(gratuitySituation, student);
        super.setGratuitySituation(gratuitySituation);
    }

    private void checkParameters(GratuitySituation gratuitySituation, Student student) {
        if (gratuitySituation == null) {
            throw new DomainException("error.accounting.paymentCodes.GratuitySituationPaymentCode.gratuitySituation.cannot.be.null", new String[0]);
        }
        if (student == null) {
            throw new DomainException("error.accounting.paymentCodes.GratuitySituationPaymentCode.student.cannot.be.null", new String[0]);
        }
    }

    public static GratuitySituationPaymentCode create(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Student student, GratuitySituation gratuitySituation) {
        if (PaymentCode.canGenerateNewCode(GratuitySituationPaymentCode.class, paymentCodeType, student.getPerson())) {
            return new GratuitySituationPaymentCode(paymentCodeType, startDate, endDate, minAmount, maxAmount, student, gratuitySituation);
        }
        throw new DomainException("error.accounting.paymentCodes.MasterDegreeInsurancePaymentCode.could.not.generate.new.code", new String[0]);
    }

    public void setGratuitySituation(GratuitySituation gratuitySituation) {
        throw new DomainException("error.accounting.paymentCodes.GratuitySituationPaymentCode.cannot.modify.gratuitySituation", new String[0]);
    }

    protected void internalProcess(Person responsiblePerson, Money amount, DateTime whenRegistered, String sibsTransactionId, String comments) {
        this.getGratuitySituation().processAmount(responsiblePerson, amount, whenRegistered, PaymentType.SIBS);
    }

    public void delete() {
        super.setGratuitySituation(null);
        super.delete();
    }

    public void setPerson(Person student) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.person", new String[0]);
    }
}

