/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationByDispatch;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.joda.time.YearMonthDay;

public class GratuityExemptionJustificationFactory {
    public static GratuityExemptionJustification create(GratuityExemption gratuityExemption, GratuityExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        switch (justificationType) {
            case INSTITUTION: 
            case INSTITUTION_GRANT_OWNER: 
            case OTHER_INSTITUTION: 
            case PALOP_TEACHER: 
            case SON_OF_DECORATED_MILITARY: 
            case SOCIAL_SHARE_GRANT_OWNER: 
            case STUDENT_TEACH: 
            case SEPARATION_CYCLES_AUTHORIZATION: {
                return new GratuityExemptionJustification(gratuityExemption, justificationType, reason);
            }
            case DIRECTIVE_COUNCIL_AUTHORIZATION: {
                return new GratuityExemptionJustificationByDispatch(gratuityExemption, justificationType, reason, dispatchDate);
            }
        }
        throw new RuntimeException("Unknown justification type");
    }
}

