/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.enrollment.bolonha;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesCandidate;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentPreConditions;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.ui.struts.action.commons.student.enrollment.bolonha.AbstractBolonhaStudentEnrollmentDA;
import org.fenixedu.academic.ui.struts.action.student.enrollment.EnrolmentContextHandler;
import org.fenixedu.academic.ui.struts.action.student.enrollment.StudentEnrollmentManagementDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

@Mapping(module="student", path="/bolonhaStudentEnrollment", functionality=StudentEnrollmentManagementDA.class)
@Forwards(value={@Forward(name="notAuthorized", path="/student/notAuthorized_bd.jsp"), @Forward(name="chooseOptionalCurricularCourseToEnrol", path="/student/enrollment/bolonha/chooseOptionalCurricularCourseToEnrol.jsp"), @Forward(name="showDegreeModulesToEnrol", path="/student/enrollment/bolonha/showDegreeModulesToEnrol.jsp"), @Forward(name="showEnrollmentInstructions", path="/student/enrollment/bolonha/showEnrollmentInstructions.jsp"), @Forward(name="chooseCycleCourseGroupToEnrol", path="/student/enrollment/bolonha/chooseCycleCourseGroupToEnrol.jsp"), @Forward(name="welcome", path="/student/enrollment/welcome.jsp"), @Forward(name="chooseSemester", path="/student/enrollment/chooseSemester.jsp"), @Forward(name="welcome-dea-degree", path="/student/phdStudentEnrolment.do?method=showWelcome"), @Forward(name="showEnrollmentInstructions", path="/student/enrollment/bolonha/showEnrollmentInstructions.jsp"), @Forward(name="enrollmentCannotProceed", path="/student/enrollment/bolonha/enrollmentCannotProceed.jsp")})
public class BolonhaStudentEnrollmentDispatchAction
extends AbstractBolonhaStudentEnrollmentDA {
    private static final PeriodFormatter FORMATTER = new PeriodFormatterBuilder().printZeroAlways().appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").appendSeconds().appendSuffix("s").toFormatter();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward result = super.execute(mapping, actionForm, request, response);
        BolonhaStudentEnrollmentBean bolonhaStudentEnrollmentBean = (BolonhaStudentEnrollmentBean)request.getAttribute("bolonhaStudentEnrollmentBean");
        if (bolonhaStudentEnrollmentBean != null) {
            Optional<String> returnURL;
            Registration registration = bolonhaStudentEnrollmentBean.getRegistration();
            List openedEnrolmentPeriodsSemesters = Collections.EMPTY_LIST;
            if (registration != null) {
                ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
                DegreeCurricularPlan lastDegreeCurricularPlan = registration.getLastDegreeCurricularPlan();
                StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(lastDegreeCurricularPlan);
                openedEnrolmentPeriodsSemesters = lastDegreeCurricularPlan.getEnrolmentPeriodsSet().stream().filter(ep -> this.isValidPeriodForUser((EnrolmentPeriod)((Object)ep), studentCurricularPlan, currentExecutionYear)).map(ep -> ep.getExecutionPeriod()).distinct().sorted(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR).collect(Collectors.toList());
            }
            if (openedEnrolmentPeriodsSemesters.size() > 1) {
                request.setAttribute("openedEnrolmentPeriodsSemesters", (Object)openedEnrolmentPeriodsSemesters);
            }
            if ((returnURL = EnrolmentContextHandler.getRegisteredEnrolmentContextHandler().getReturnURLForStudentInCurricularCourses(request, registration)).isPresent()) {
                request.setAttribute("returnURL", (Object)returnURL.get());
            }
        }
        return result;
    }

    public ActionForward showWelcome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)request.getAttribute("registration"));
        ExecutionSemester executionSemester = (ExecutionSemester)request.getAttribute("executionSemester");
        request.setAttribute("registration", (Object)registration);
        request.setAttribute("executionSemester", (Object)executionSemester);
        return this.findForwardForRegistration(mapping, registration);
    }

    private ActionForward findForwardForRegistration(ActionMapping mapping, Registration registration) {
        if (registration.getDegree().isDEA()) {
            return mapping.findForward("welcome-dea-degree");
        }
        return mapping.findForward("welcome");
    }

    @Override
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationOid"));
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterID");
        request.setAttribute("registration", (Object)registration);
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, registration.getLastStudentCurricularPlan(), executionSemester);
    }

    @Override
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkPreConditionsToEnrol(studentCurricularPlan, executionSemester);
        if (!result.isValid()) {
            if (result.getEnrolmentPeriod() != null) {
                DateTime now = DateTime.now().withMillisOfSecond(0);
                DateTime start = result.getEnrolmentPeriod().getStartDateDateTime();
                Period period = new Period(start.getMillis() - now.getMillis());
                if (start.toLocalDate().equals((Object)now.toLocalDate())) {
                    request.setAttribute("now", (Object)now);
                    request.setAttribute("start", (Object)start);
                    request.setAttribute("remaining", (Object)FORMATTER.print((ReadablePeriod)period));
                }
            }
            this.addActionMessage(request, result.message(), result.args());
            return mapping.findForward("enrollmentCannotProceed");
        }
        return super.prepareShowDegreeModulesToEnrol(mapping, form, request, response, studentCurricularPlan, executionSemester);
    }

    public ActionForward showEnrollmentInstructions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("showEnrollmentInstructions");
    }

    @Override
    protected int[] getCurricularYearForCurricularCourses() {
        return null;
    }

    @Override
    protected CurricularRuleLevel getCurricularRuleLevel(ActionForm actionForm) {
        return CurricularRuleLevel.ENROLMENT_WITH_RULES;
    }

    @Override
    protected String getAction() {
        return "";
    }

    private boolean isValidPeriodForUser(EnrolmentPeriod ep, StudentCurricularPlan studentCurricularPlan, ExecutionYear currentExecutionYear) {
        if (ep.isValid()) {
            if (studentCurricularPlan.isInCandidateEnrolmentProcess(currentExecutionYear)) {
                return ep instanceof EnrolmentPeriodInCurricularCoursesCandidate;
            }
            return ep.isForCurricularCourses();
        }
        return false;
    }
}

