/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.student;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.OptionalCurricularCoursesLocationBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class CurriculumGroupsProviderForOptionalEnrolmentsLocationManagement
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        OptionalCurricularCoursesLocationBean.OptionalEnrolmentLocationBean bean = (OptionalCurricularCoursesLocationBean.OptionalEnrolmentLocationBean)source;
        TreeSet<CurriculumGroup> result = new TreeSet<CurriculumGroup>(CurriculumGroup.COMPARATOR_BY_FULL_PATH_NAME_AND_ID);
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, Authenticate.getUser()).collect(Collectors.toSet());
        for (Registration registration : bean.getStudent().getRegistrationsSet()) {
            if (!registration.isBolonha() || !programs.contains(registration.getDegree())) continue;
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            result.addAll(studentCurricularPlan.getCurricularCoursePossibleGroups(bean.getEnrolment().getCurricularCourse()));
        }
        return result;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

