/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.serviceRequests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalEnrolmentWrapper;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ApprovedEnrolmentsToCreateDocumentRequestProvider
implements DataProvider {
    public Converter getConverter() {
        return new DomainObjectKeyArrayConverter();
    }

    public Object provide(Object source, Object currentValue) {
        DocumentRequestCreateBean documentRequestCreateBean = (DocumentRequestCreateBean)source;
        Set degrees = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS, Authenticate.getUser()).collect(Collectors.toSet());
        TreeSet<Enrolment> aprovedEnrolments = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_NAME_AND_ID);
        for (Degree degree : degrees) {
            for (Registration registration : documentRequestCreateBean.getStudent().getRegistrationsFor(degree)) {
                aprovedEnrolments.addAll(registration.getApprovedEnrolments());
            }
        }
        documentRequestCreateBean.setEnrolments(new ArrayList<Enrolment>(aprovedEnrolments));
        this.filter(aprovedEnrolments, documentRequestCreateBean);
        return aprovedEnrolments;
    }

    private void filter(SortedSet<Enrolment> aprovedEnrolments, DocumentRequestCreateBean documentRequestCreateBean) {
        CycleType cycleType = documentRequestCreateBean.getRequestedCycle();
        if (cycleType != null) {
            Iterator elements = aprovedEnrolments.iterator();
            while (elements.hasNext()) {
                Enrolment enrolment = (Enrolment)elements.next();
                if (this.hasCycleType(enrolment, cycleType) || this.isSourceInAnyCycleGroup(enrolment, cycleType)) continue;
                elements.remove();
            }
        }
    }

    private boolean hasCycleType(Enrolment enrolment, CycleType cycleType) {
        CycleCurriculumGroup cycleCurriculumGroup = enrolment.getParentCycleCurriculumGroup();
        return cycleCurriculumGroup != null && cycleCurriculumGroup.getCycleType() == cycleType;
    }

    private boolean isSourceInAnyCycleGroup(Enrolment enrolment, CycleType cycleType) {
        for (InternalEnrolmentWrapper wrapper : enrolment.getEnrolmentWrappersSet()) {
            if (!wrapper.getCredits().hasAnyDismissalInCycle(cycleType)) continue;
            return true;
        }
        return false;
    }
}

