/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components.degreeStructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UICourseGroup;
import org.fenixedu.academic.ui.faces.components.degreeStructure.UICurricularCourse;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class UIDegreeCurricularPlan
extends UIInput {
    public static final String COMPONENT_TYPE = "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeCurricularPlan";
    public static final String COMPONENT_FAMILY = "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeCurricularPlan";
    protected static final int ROOT_DEPTH = 0;
    private static final String MODULE = "module";
    private static final String DCP = "dcp";
    private static final String TO_ORDER = "toOrder";
    private static final String EXECUTION_YEAR = "executionYear";
    private static final String REPORTS_AVAILABLE = "reportsAvailable";
    private static final String HIDE_COURSES = "hideCourses";
    private static final String ONLY_STRUCTURE = "onlyStructure";
    private static final String ORGANIZE_BY = "organizeBy";
    private static final String SHOW_RULES = "showRules";
    private static final String TO_EDIT = "toEdit";
    private static final String YEARS = "years";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String GROUP_EXPAND_ENABLED = "groupExpandEnabled";
    private static final int MAX_CONTEXTS_TO_RENDER = 1000;
    private boolean toEdit;
    private boolean showRules;
    private ExecutionYear executionYear;
    private String module;
    private FacesContext facesContext;
    private ResponseWriter writer;
    private final Map<CurricularPeriod, List<Context>> toRepeat = new HashMap<CurricularPeriod, List<Context>>();

    public UIDegreeCurricularPlan() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.fenixedu.academic.ui.faces.components.degreeStructure.UIDegreeCurricularPlan";
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        Boolean reportsAvailable;
        if (!this.isRendered()) {
            return;
        }
        this.module = facesContext.getExternalContext().getRequestContextPath() + (String)this.getAttributes().get(MODULE);
        DegreeCurricularPlan dcp = this.getDegreeCurricularPlanAttribute();
        this.toEdit = this.getBooleanAttribute(TO_EDIT) != null ? this.getBooleanAttribute(TO_EDIT) : Boolean.FALSE;
        this.showRules = this.getBooleanAttribute(SHOW_RULES) != null ? this.getBooleanAttribute(SHOW_RULES) : Boolean.FALSE;
        String organizeBy = this.getAttributes().get(ORGANIZE_BY) != null ? (String)this.getAttributes().get(ORGANIZE_BY) : "groups";
        Boolean onlyStructure = this.getOnlyStructureAttribute();
        Boolean toOrder = this.getBooleanAttribute(TO_ORDER) != null ? this.getBooleanAttribute(TO_ORDER) : Boolean.FALSE;
        Boolean hideCourses = this.getHideCourseAttribute();
        Boolean bl = reportsAvailable = this.getBooleanAttribute(REPORTS_AVAILABLE) != null ? this.getBooleanAttribute(REPORTS_AVAILABLE) : Boolean.FALSE;
        if (this.getAttributes().get(EXECUTION_YEAR) != null) {
            this.executionYear = (ExecutionYear)this.getAttributes().get(EXECUTION_YEAR);
        }
        if (this.incorrectUseOfComponent(organizeBy, onlyStructure, toOrder, hideCourses)) {
            throw new IOException("incorrect.component.usage");
        }
        if (organizeBy.equalsIgnoreCase(YEARS)) {
            this.encodeByYears(facesContext, dcp);
        } else {
            new UICourseGroup((DegreeModule)((Object)dcp.getRoot()), null, this.toEdit, this.showRules, 0, "", onlyStructure, toOrder, hideCourses, reportsAvailable, this.executionYear, this.module, this.getCurrentPageAttribute(), this.isToEnableGroupExpandOption()).encodeBegin(facesContext);
        }
        if (dcp.getDegreeStructure() != null && !dcp.getDegreeStructure().getChildsSet().isEmpty() && !onlyStructure.booleanValue()) {
            this.encodeSubtitles(facesContext);
        }
    }

    protected Boolean getGroupExpandEnabledAttribute() {
        return this.getBooleanAttribute(GROUP_EXPAND_ENABLED) != null ? this.getBooleanAttribute(GROUP_EXPAND_ENABLED) : Boolean.FALSE;
    }

    protected String getCurrentPageAttribute() {
        return (String)this.getAttributes().get(CURRENT_PAGE);
    }

    protected Boolean getHideCourseAttribute() {
        Boolean hideCourses = this.getBooleanAttribute(HIDE_COURSES) != null ? this.getBooleanAttribute(HIDE_COURSES) : Boolean.FALSE;
        return hideCourses;
    }

    protected Boolean getOnlyStructureAttribute() {
        Boolean onlyStructure = this.getBooleanAttribute(ONLY_STRUCTURE) != null ? this.getBooleanAttribute(ONLY_STRUCTURE) : Boolean.FALSE;
        return onlyStructure;
    }

    private boolean incorrectUseOfComponent(String organizeBy, Boolean onlyStructure, Boolean toOrder, Boolean hideCourses) {
        return onlyStructure != false && (this.showRules || organizeBy.equals(YEARS)) || toOrder != false && (onlyStructure == false || !this.toEdit);
    }

    private Boolean getBooleanAttribute(String attributeName) {
        if (this.getAttributes().get(attributeName) instanceof Boolean) {
            return (Boolean)this.getAttributes().get(attributeName);
        }
        return Boolean.valueOf((String)this.getAttributes().get(attributeName));
    }

    private void encodeByYears(FacesContext facesContext, DegreeCurricularPlan dcp) throws IOException {
        this.facesContext = facesContext;
        this.writer = facesContext.getResponseWriter();
        if (this.isLargeDegreeCurricularPlan()) {
            this.encodeLargeDegreeCurricularPlanByYearsInfo();
            return;
        }
        if (dcp.getRoot().getChildContextsSet().isEmpty()) {
            this.encodeEmptyCurricularPlanInfo();
        } else {
            CurricularPeriod degreeStructure = dcp.getDegreeStructure();
            if (degreeStructure == null || degreeStructure.getChildsSet().isEmpty()) {
                this.encodeEmptyDegreeStructureInfo();
            } else {
                for (CurricularPeriod child : degreeStructure.getSortedChilds()) {
                    this.encodePeriodTable(child);
                }
            }
        }
    }

    private void encodeEmptyCurricularPlanInfo() throws IOException {
        this.encodeInfoTable("empty.curricularPlan");
    }

    private void encodeEmptyDegreeStructureInfo() throws IOException {
        this.encodeInfoTable("empty.degreeStructure");
    }

    private void encodeLargeDegreeCurricularPlanByYearsInfo() throws IOException {
        this.encodeInfoTable("large.degree.curricular.plans.cannot.be.viewed.by.years");
    }

    private void encodeInfoTable(String info) throws IOException {
        this.writer.startElement("table", (UIComponent)this);
        this.writer.startElement("tr", (UIComponent)this);
        this.writer.startElement("td", (UIComponent)this);
        this.writer.writeAttribute("align", (Object)"center", null);
        this.writer.startElement("i", (UIComponent)this);
        this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)info, (String[])new String[0]));
        this.writer.endElement("i");
        this.writer.endElement("td");
        this.writer.endElement("tr");
        this.writer.endElement("table");
    }

    private void encodePeriodTable(CurricularPeriod curricularPeriod) throws IOException {
        if (!curricularPeriod.getChildsSet().isEmpty()) {
            for (CurricularPeriod child : curricularPeriod.getSortedChilds()) {
                this.encodePeriodTable(child);
            }
        } else {
            this.writer.startElement("table", (UIComponent)this);
            this.writer.writeAttribute("class", (Object)"showinfo3", null);
            this.writer.writeAttribute("style", (Object)"width: 70em;", null);
            this.encodeHeader(curricularPeriod);
            if (!this.encodeCurricularCourses(curricularPeriod)) {
                this.encodeEmptySemesterInfo();
            }
            this.writer.endElement("table");
        }
    }

    private void encodeHeader(CurricularPeriod curricularPeriod) throws IOException {
        this.writer.startElement("tr", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"bgcolor2", null);
        this.writer.startElement("th", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"aleft", null);
        this.writer.writeAttribute("colspan", (Object)(this.toEdit ? 3 : 5), null);
        this.writer.append((CharSequence)curricularPeriod.getFullLabel());
        this.writer.endElement("th");
        if (this.toEdit) {
            this.encodeCourseGroupOptions(curricularPeriod);
        }
        this.writer.endElement("tr");
    }

    private void encodeCourseGroupOptions(CurricularPeriod curricularPeriod) throws IOException {
        this.writer.startElement("th", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"aright", null);
        this.writer.writeAttribute("colspan", (Object)3, null);
        if (!this.showRules && this.loggedPersonCanManageDegreeCurricularPlans(this.getDegreeCurricularPlanAttribute()).booleanValue()) {
            this.encodeLink(this.module + "/createCurricularCourse.faces", "&curricularYearID=" + curricularPeriod.getParent().getChildOrder() + "&curricularSemesterID=" + curricularPeriod.getChildOrder(), false, "create.curricular.course");
            this.writer.append((CharSequence)" , ");
            this.encodeLink(this.module + "/associateCurricularCourse.faces", "&curricularYearID=" + curricularPeriod.getParent().getChildOrder() + "&curricularSemesterID=" + curricularPeriod.getChildOrder(), false, "associate.curricular.course");
        }
        this.writer.endElement("th");
    }

    private boolean encodeCurricularCourses(CurricularPeriod curricularPeriod) throws IOException {
        boolean anyCurricularCourseEncoded = false;
        for (Context context : curricularPeriod.getContextsSet()) {
            if (!context.getChildDegreeModule().isLeaf() || this.executionYear != null && !context.isValid(this.executionYear)) continue;
            anyCurricularCourseEncoded = true;
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            curricularCourse.getContactLoad(curricularPeriod, this.executionYear);
            curricularCourse.getAutonomousWorkHours(curricularPeriod, this.executionYear);
            curricularCourse.getTotalLoad(curricularPeriod, this.executionYear);
            curricularCourse.getEctsCredits(curricularPeriod, this.executionYear);
            new UICurricularCourse((DegreeModule)((Object)curricularCourse), context, this.toEdit, this.showRules, this.executionYear, this.module, null, false).encodeBegin(this.facesContext);
            if (!curricularCourse.isAnual()) continue;
            this.remindToEncodeInNextPeriod(curricularPeriod, context);
        }
        if (this.toRepeat.containsKey(curricularPeriod)) {
            anyCurricularCourseEncoded = true;
            for (Context check : this.toRepeat.get(curricularPeriod)) {
                new UICurricularCourse(check.getChildDegreeModule(), check, this.toEdit, this.showRules, this.executionYear, this.module, null, false).encodeInNextPeriod(this.facesContext);
            }
        }
        return anyCurricularCourseEncoded;
    }

    private void remindToEncodeInNextPeriod(CurricularPeriod curricularPeriod, Context context) {
        if (curricularPeriod.getNext() != null) {
            List<Context> toUpdate = this.toRepeat.get(curricularPeriod.getNext());
            if (toUpdate == null) {
                toUpdate = new ArrayList<Context>();
            }
            toUpdate.add(context);
            this.toRepeat.put(curricularPeriod.getNext(), toUpdate);
        }
    }

    private void encodeSumsLoadFooterElement(List<Double> sums, String acronym, int order) throws IOException {
        this.writer.startElement("span", (UIComponent)this);
        this.writer.writeAttribute("style", (Object)"color: #888", null);
        this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)acronym, (String[])new String[0])).append("-");
        this.writer.endElement("span");
        this.writer.append((CharSequence)String.valueOf(sums.get(order))).append(" ");
    }

    private void encodeEmptySemesterInfo() throws IOException {
        this.writer.startElement("tr", (UIComponent)this);
        this.writer.startElement("td", (UIComponent)this);
        if (this.toEdit) {
            this.writer.writeAttribute("colspan", (Object)5, null);
        } else {
            this.writer.writeAttribute("colspan", (Object)3, null);
        }
        this.writer.writeAttribute("align", (Object)"center", null);
        this.writer.startElement("i", (UIComponent)this);
        this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"no.associated.curricular.courses.to.year", (String[])new String[0]));
        this.writer.endElement("i");
        this.writer.endElement("td");
        this.writer.endElement("tr");
    }

    private void encodeLink(String page, String aditionalParameters, boolean blank, String ... bundleKeys) throws IOException {
        this.writer.startElement("a", (UIComponent)this);
        this.encodeLinkHref(page, aditionalParameters, blank);
        for (String bundleKey : bundleKeys) {
            this.writer.write(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)bundleKey, (String[])new String[0]));
        }
        this.writer.endElement("a");
    }

    private void encodeLinkHref(String page, String aditionalParameters, boolean blank) throws IOException {
        Map requestParameterMap = this.facesContext.getExternalContext().getRequestParameterMap();
        StringBuilder href = new StringBuilder();
        href.append(page).append("?");
        Object dcpId = null;
        if (requestParameterMap.get("degreeCurricularPlanID") != null) {
            dcpId = requestParameterMap.get("degreeCurricularPlanID");
        } else if (requestParameterMap.get("dcpId") != null) {
            dcpId = requestParameterMap.get("dcpId");
        }
        href.append("degreeCurricularPlanID=").append((Object)dcpId);
        if (this.executionYear != null) {
            href.append("&executionYearID=").append(this.executionYear.getExternalId());
        }
        if (aditionalParameters != null) {
            href.append(aditionalParameters);
        }
        href.append("&organizeBy=").append(requestParameterMap.get(ORGANIZE_BY));
        href.append("&showRules=").append(requestParameterMap.get(SHOW_RULES));
        href.append("&hideCourses=").append(requestParameterMap.get(HIDE_COURSES));
        href.append("&action=").append(requestParameterMap.get("action"));
        this.writer.writeAttribute("href", (Object)href.toString(), null);
        if (blank) {
            this.writer.writeAttribute("target", (Object)"_blank", null);
        }
    }

    private void encodeSubtitles(FacesContext facesContext) throws IOException {
        this.facesContext = facesContext;
        this.writer = facesContext.getResponseWriter();
        this.writer.startElement("p", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"mtop2 mbottom05", null);
        this.writer.startElement("em", (UIComponent)this);
        this.writer.append((CharSequence)BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"subtitle", (String[])new String[0])).append(":\n");
        this.writer.endElement("em");
        this.writer.endElement("p");
        this.writer.startElement("ul", (UIComponent)this);
        this.writer.writeAttribute("class", (Object)"nobullet mtop05 mbottom2", null);
        this.writer.writeAttribute("style", (Object)"padding-left: 0pt; font-style: italic;", null);
        this.encodeSubtitleElement("resources.EnumerationResources", RegimeType.SEMESTRIAL.toString() + ".ACRONYM", RegimeType.SEMESTRIAL.toString(), null);
        this.encodeSubtitleElement("resources.EnumerationResources", RegimeType.ANUAL.toString() + ".ACRONYM", RegimeType.ANUAL.toString(), null);
        this.encodeSubtitleElement("resources.BolonhaManagerResources", "contactLessonHoursAcronym", "contactLessonHours", null);
        this.encodeSubtitleElement("resources.BolonhaManagerResources", "autonomousWorkAcronym", "autonomousWork", null);
        StringBuilder explanation = new StringBuilder();
        explanation.append(" (");
        explanation.append(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"contactLessonHoursAcronym", (String[])new String[0]));
        explanation.append(" + ");
        explanation.append(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"autonomousWorkAcronym", (String[])new String[0]));
        explanation.append(")");
        this.encodeSubtitleElement("resources.BolonhaManagerResources", "totalLoadAcronym", "totalLoad", explanation);
        this.writer.endElement("ul");
    }

    private void encodeSubtitleElement(String bundle, String acronym, String full, StringBuilder explanation) throws IOException {
        this.writer.startElement("li", (UIComponent)this);
        this.writer.startElement("span", (UIComponent)this);
        this.writer.writeAttribute("style", (Object)"color: #888", null);
        this.writer.append((CharSequence)BundleUtil.getString((String)bundle, (String)acronym, (String[])new String[0])).append(" - ");
        this.writer.endElement("span");
        this.writer.append((CharSequence)BundleUtil.getString((String)bundle, (String)full, (String[])new String[0]));
        if (explanation != null) {
            this.writer.append((CharSequence)explanation);
        }
        this.writer.endElement("li");
    }

    private Boolean loggedPersonCanManageDegreeCurricularPlans(DegreeCurricularPlan degreeCurricularPlan) {
        return AcademicPredicates.MANAGE_DEGREE_CURRICULAR_PLANS.evaluate(degreeCurricularPlan.getDegree());
    }

    private DegreeCurricularPlan getDegreeCurricularPlanAttribute() {
        return (DegreeCurricularPlan)((Object)this.getAttributes().get(DCP));
    }

    private boolean isToEnableGroupExpandOption() {
        return this.getGroupExpandEnabledAttribute() != false && this.getOnlyStructureAttribute() == false && this.getHideCourseAttribute() == false && this.isLargeDegreeCurricularPlan();
    }

    protected boolean isLargeDegreeCurricularPlan() {
        int totalContexts = 0;
        for (CurricularCourse curricularCourse : this.getDegreeCurricularPlanAttribute().getCurricularCoursesSet()) {
            totalContexts += curricularCourse.getParentContextsByExecutionYear(this.executionYear).size();
        }
        return totalContexts > 1000;
    }
}

