/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons.student;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.dto.InfoStudentCurricularPlan;
import org.fenixedu.academic.service.services.commons.student.ReadStudentsFromDegreeCurricularPlan$callable$runReadStudentsFromDegreeCurricularPlan;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadStudentsFromDegreeCurricularPlan {
    private static final ReadStudentsFromDegreeCurricularPlan serviceInstance;
    public static final Advice advice$runReadStudentsFromDegreeCurricularPlan;

    protected List run(String degreeCurricularPlanID) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        Set students = degreeCurricularPlan.getStudentCurricularPlansSet();
        if (students == null || students.isEmpty()) {
            throw new NonExistingServiceException();
        }
        return (List)CollectionUtils.collect((Collection)students, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                StudentCurricularPlan studentCurricularPlan = (StudentCurricularPlan)((Object)arg0);
                return InfoStudentCurricularPlan.newInfoFromDomain(studentCurricularPlan);
            }
        });
    }

    public static List runReadStudentsFromDegreeCurricularPlan(String string) throws FenixServiceException, NotAuthorizedException {
        return (List)advice$runReadStudentsFromDegreeCurricularPlan.perform((Callable)new ReadStudentsFromDegreeCurricularPlan$callable$runReadStudentsFromDegreeCurricularPlan(string));
    }

    static /* synthetic */ List advised$runReadStudentsFromDegreeCurricularPlan(String degreeCurricularPlanID) throws FenixServiceException, NotAuthorizedException {
        return serviceInstance.run(degreeCurricularPlanID);
    }

    static {
        advice$runReadStudentsFromDegreeCurricularPlan = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadStudentsFromDegreeCurricularPlan();
    }
}

