/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter.framework;

import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DomainObjectAuthorizationFilter
extends AuthorizationByRoleFilter {
    private static final Logger logger = LoggerFactory.getLogger(DomainObjectAuthorizationFilter.class);

    @Override
    protected abstract RoleType getRoleType();

    public void execute(String externalId) throws NotAuthorizedException {
        try {
            boolean isNew;
            User id = Authenticate.getUser();
            boolean bl = isNew = externalId == null;
            if (id != null && !this.getRoleType().isMember(id.getPerson().getUser()) || id == null || !isNew && !this.verifyCondition(id, externalId)) {
                throw new NotAuthorizedException();
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotAuthorizedException(e.getMessage());
        }
    }

    protected abstract boolean verifyCondition(User var1, String var2);
}

