/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting.sibsPaymentFileProcessReport;

import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeCandidacyForGraduatedPersonEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeChangeIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeTransferIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.Over23IndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.DfaGratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.StandaloneEnrolmentGratuityEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.GratuitySituationPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.MasterDegreeInsurancePaymentCode;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyEvent;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.academic.util.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.joda.time.YearMonthDay;

public class SibsPaymentFileProcessReportDTO {
    private String filename;
    private YearMonthDay whenProcessedBySibs;
    private Integer fileVersion;
    private Money degreeGratuityTotalAmount = Money.ZERO;
    private Money bolonhaDegreeGratuityTotalAmount = Money.ZERO;
    private Money integratedMasterDegreeGratuityTotalAmount = Money.ZERO;
    private Money integratedBolonhaMasterDegreeGratuityTotalAmount = Money.ZERO;
    private Money administrativeOfficeTaxTotalAmount = Money.ZERO;
    private Money graduationInsuranceTotalAmount = Money.ZERO;
    private Money specializationGratuityTotalAmount = Money.ZERO;
    private Money masterDegreeGratuityTotalAmount = Money.ZERO;
    private Money bolonhaMasterDegreeGratuityTotalAmount = Money.ZERO;
    private Money dfaGratuityTotalAmount = Money.ZERO;
    private Money afterGraduationInsuranceTotalAmount = Money.ZERO;
    private Money phdGratuityTotalAmout = Money.ZERO;
    private Money transactionsTotalAmount = Money.ZERO;
    private Money residenceAmount;
    private Money degreeChangeIndividualCandidacyAmount;
    private Money degreeTransferIndividualCandidacyAmount;
    private Money secondCycleIndividualCandidacyAmount;
    private Money degreeCandidacyForGraduatedPersonAmount;
    private Money totalCost = Money.ZERO;
    private Money standaloneEnrolmentGratuityEventAmount;
    private Money over23IndividualCandidacyEventAmount;
    private Money institutionAffiliationEventAmount;
    private Money phdProgramCandidacyEventAmount;
    private Money rectorateAmount;

    public SibsPaymentFileProcessReportDTO() {
        this.residenceAmount = Money.ZERO;
        this.degreeChangeIndividualCandidacyAmount = Money.ZERO;
        this.degreeTransferIndividualCandidacyAmount = Money.ZERO;
        this.secondCycleIndividualCandidacyAmount = Money.ZERO;
        this.degreeCandidacyForGraduatedPersonAmount = Money.ZERO;
        this.standaloneEnrolmentGratuityEventAmount = Money.ZERO;
        this.over23IndividualCandidacyEventAmount = Money.ZERO;
        this.institutionAffiliationEventAmount = Money.ZERO;
        this.phdProgramCandidacyEventAmount = Money.ZERO;
        this.rectorateAmount = Money.ZERO;
    }

    public SibsPaymentFileProcessReportDTO(SibsIncommingPaymentFile sibsIncomingPaymentFile) {
        this();
        this.setWhenProcessedBySibs(sibsIncomingPaymentFile.getHeader().getWhenProcessedBySibs());
        this.setFilename(sibsIncomingPaymentFile.getFilename());
        this.setTransactionsTotalAmount(sibsIncomingPaymentFile.getFooter().getTransactionsTotalAmount());
        this.setTotalCost(sibsIncomingPaymentFile.getFooter().getTotalCost());
        this.setFileVersion(sibsIncomingPaymentFile.getHeader().getVersion());
    }

    private void addAdministrativeOfficeTaxAmount(Money amount) {
        this.administrativeOfficeTaxTotalAmount = this.administrativeOfficeTaxTotalAmount.add(amount);
    }

    public Money getAdministrativeOfficeTaxTotalAmount() {
        return this.administrativeOfficeTaxTotalAmount;
    }

    private void addBolonhaDegreeGratuityAmount(Money amount) {
        this.bolonhaDegreeGratuityTotalAmount = this.bolonhaDegreeGratuityTotalAmount.add(amount);
    }

    public Money getBolonhaDegreeGratuityTotalAmount() {
        return this.bolonhaDegreeGratuityTotalAmount;
    }

    private void addDegreeGratuityAmount(Money amount) {
        this.degreeGratuityTotalAmount = this.degreeGratuityTotalAmount.add(amount);
    }

    public Money getDegreeGratuityTotalAmount() {
        return this.degreeGratuityTotalAmount;
    }

    public Money getGraduationInsuranceTotalAmount() {
        return this.graduationInsuranceTotalAmount;
    }

    private void addGraduationInsuranceAmount(Money amount) {
        this.graduationInsuranceTotalAmount = this.graduationInsuranceTotalAmount.add(amount);
    }

    private void addDfaGratuityAmount(Money amount) {
        this.dfaGratuityTotalAmount = this.dfaGratuityTotalAmount.add(amount);
    }

    public Money getDfaGratuityTotalAmount() {
        return this.dfaGratuityTotalAmount;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Integer getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(Integer fileVersion) {
        this.fileVersion = fileVersion;
    }

    private void addAfterGraduationInsuranceAmount(Money amount) {
        this.afterGraduationInsuranceTotalAmount = this.afterGraduationInsuranceTotalAmount.add(amount);
    }

    public Money getAfterGraduationInsuranceTotalAmount() {
        return this.afterGraduationInsuranceTotalAmount;
    }

    private void addIntegratedBolonhaMasterDegreeGratuityAmount(Money amount) {
        this.integratedBolonhaMasterDegreeGratuityTotalAmount = this.integratedBolonhaMasterDegreeGratuityTotalAmount.add(amount);
    }

    public Money getIntegratedBolonhaMasterDegreeGratuityTotalAmount() {
        return this.integratedBolonhaMasterDegreeGratuityTotalAmount;
    }

    private void addIntegratedMasterDegreeGratuityAmount(Money amount) {
        this.integratedMasterDegreeGratuityTotalAmount = this.integratedMasterDegreeGratuityTotalAmount.add(amount);
    }

    public Money getIntegratedMasterDegreeGratuityTotalAmount() {
        return this.integratedMasterDegreeGratuityTotalAmount;
    }

    private void addMasterDegreeGratuityAmount(Money amount) {
        this.masterDegreeGratuityTotalAmount = this.masterDegreeGratuityTotalAmount.add(amount);
    }

    public Money getMasterDegreeGratuityTotalAmount() {
        return this.masterDegreeGratuityTotalAmount;
    }

    private void addBolonhaMasterDegreGratuityTotalAmount(Money amount) {
        this.bolonhaMasterDegreeGratuityTotalAmount = this.bolonhaMasterDegreeGratuityTotalAmount.add(amount);
    }

    public Money getBolonhaMasterDegreeGratuityTotalAmount() {
        return this.bolonhaMasterDegreeGratuityTotalAmount;
    }

    private void addSpecializationGratuityAmount(Money amount) {
        this.specializationGratuityTotalAmount = this.specializationGratuityTotalAmount.add(amount);
    }

    public Money getSpecializationGratuityTotalAmount() {
        return this.specializationGratuityTotalAmount;
    }

    private void addPhdGratuityAmount(Money amount) {
        this.phdGratuityTotalAmout = this.phdGratuityTotalAmout.add(amount);
    }

    public Money getPhdGratuityTotalAmout() {
        return this.phdGratuityTotalAmout;
    }

    public Money getOver23IndividualCandidacyEventAmount() {
        return this.over23IndividualCandidacyEventAmount;
    }

    public void addOver23IndividualCandidacyEventAmount(Money amount) {
        this.over23IndividualCandidacyEventAmount = this.over23IndividualCandidacyEventAmount.add(amount);
    }

    public Money getInstitutionAffiliationEventAmount() {
        return this.institutionAffiliationEventAmount;
    }

    public void addInstitutionAffiliationEventAmount(Money amount) {
        this.institutionAffiliationEventAmount = this.institutionAffiliationEventAmount.add(amount);
    }

    public Money getPhdProgramCandidacyEventAmount() {
        return this.phdProgramCandidacyEventAmount;
    }

    public void addPhdProgramCandidacyEventAmount(Money amount) {
        this.phdProgramCandidacyEventAmount = this.phdProgramCandidacyEventAmount.add(amount);
    }

    public Money getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(Money totalCost) {
        this.totalCost = totalCost;
    }

    public Money getTransactionsTotalAmount() {
        return this.transactionsTotalAmount;
    }

    public void setTransactionsTotalAmount(Money transactionsTotalAmount) {
        this.transactionsTotalAmount = transactionsTotalAmount;
    }

    public YearMonthDay getWhenProcessedBySibs() {
        return this.whenProcessedBySibs;
    }

    public void setWhenProcessedBySibs(YearMonthDay whenProcessedBySibs) {
        this.whenProcessedBySibs = whenProcessedBySibs;
    }

    public Money getResidenceAmount() {
        return this.residenceAmount;
    }

    public void addResidenceAmount(Money money) {
        this.residenceAmount = this.residenceAmount.add(money);
    }

    public void addAmount(SibsIncommingPaymentFileDetailLine detailLine, PaymentCode paymentCode) {
        if (paymentCode.isForRectorate()) {
            this.addAmountForRectorate(detailLine.getAmount());
        } else if (paymentCode instanceof AccountingEventPaymentCode) {
            this.addAmountForEvent(detailLine, paymentCode);
        } else if (paymentCode instanceof GratuitySituationPaymentCode) {
            this.addAmountForGratuitySituation(detailLine, (GratuitySituationPaymentCode)((Object)paymentCode));
        } else if (paymentCode instanceof MasterDegreeInsurancePaymentCode) {
            this.addAfterGraduationInsuranceAmount(detailLine.getAmount());
        } else {
            throw new UnsupportedOperationException("Unknown payment code type");
        }
    }

    private void addAmountForEvent(SibsIncommingPaymentFileDetailLine detailLine, PaymentCode paymentCode) {
        Event event = ((AccountingEventPaymentCode)((Object)paymentCode)).getAccountingEvent();
        if (event instanceof GratuityEventWithPaymentPlan) {
            this.addAmountForGratuityEvent(detailLine, (GratuityEventWithPaymentPlan)((Object)event));
        } else if (event instanceof AdministrativeOfficeFeeAndInsuranceEvent) {
            this.addAmountForAdministrativeOfficeAndInsuranceEvent(detailLine, (AdministrativeOfficeFeeAndInsuranceEvent)((Object)event));
        } else if (event instanceof DfaGratuityEvent) {
            this.addDfaGratuityAmount(detailLine.getAmount());
        } else if (event instanceof InsuranceEvent) {
            this.addAfterGraduationInsuranceAmount(detailLine.getAmount());
        } else if (event instanceof ResidenceEvent) {
            this.addResidenceAmount(detailLine.getAmount());
        } else if (event instanceof SecondCycleIndividualCandidacyEvent) {
            this.addSecondCycleIndividualCandidacyAmount(detailLine.getAmount());
        } else if (event instanceof DegreeChangeIndividualCandidacyEvent) {
            this.addDegreeChangeIndividualCandidacyAmount(detailLine.getAmount());
        } else if (event instanceof DegreeCandidacyForGraduatedPersonEvent) {
            this.addDegreeCandidacyForGraduatedPersonAmount(detailLine.getAmount());
        } else if (event instanceof DegreeTransferIndividualCandidacyEvent) {
            this.addDegreeTransferIndividualCandidacyAmount(detailLine.getAmount());
        } else if (event instanceof StandaloneEnrolmentGratuityEvent) {
            this.addStandaloneEnrolmentGratuityEventAmount(detailLine.getAmount());
        } else if (event instanceof Over23IndividualCandidacyEvent) {
            this.addOver23IndividualCandidacyEventAmount(detailLine.getAmount());
        } else if (event instanceof PhdProgramCandidacyEvent) {
            this.addPhdProgramCandidacyEventAmount(detailLine.getAmount());
        } else {
            throw new IllegalArgumentException("Unknown accounting event " + ((Object)((Object)event)).getClass().getName());
        }
    }

    private void addAmountForGratuityEvent(SibsIncommingPaymentFileDetailLine detailLine, GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan) {
        if (gratuityEventWithPaymentPlan.getDegree().getDegreeType().isPreBolonhaDegree()) {
            this.addDegreeGratuityAmount(detailLine.getAmount());
            return;
        }
        if (gratuityEventWithPaymentPlan.getDegree().getDegreeType().isBolonhaMasterDegree()) {
            this.addBolonhaMasterDegreGratuityTotalAmount(detailLine.getAmount());
            return;
        }
        if (gratuityEventWithPaymentPlan.getDegree().getDegreeType().isBolonhaDegree()) {
            this.addBolonhaDegreeGratuityAmount(detailLine.getAmount());
            return;
        }
        if (gratuityEventWithPaymentPlan.getDegree().getDegreeType().isIntegratedMasterDegree()) {
            this.addIntegratedBolonhaMasterDegreeGratuityAmount(detailLine.getAmount());
            return;
        }
        throw new IllegalArgumentException("unknown degree type for gratuity event");
    }

    private void addAmountForAdministrativeOfficeAndInsuranceEvent(SibsIncommingPaymentFileDetailLine detailLine, AdministrativeOfficeFeeAndInsuranceEvent administrativeOfficeFeeAndInsuranceEvent) {
        if (detailLine.getAmount().greaterOrEqualThan(administrativeOfficeFeeAndInsuranceEvent.getAmountToPay())) {
            this.addGraduationInsuranceAmount(administrativeOfficeFeeAndInsuranceEvent.getInsuranceAmount());
            this.addAdministrativeOfficeTaxAmount(detailLine.getAmount().subtract(administrativeOfficeFeeAndInsuranceEvent.getInsuranceAmount()));
        } else {
            this.addAdministrativeOfficeTaxAmount(detailLine.getAmount());
        }
    }

    private void addAmountForGratuitySituation(SibsIncommingPaymentFileDetailLine detailLine, GratuitySituationPaymentCode paymentCode) {
        GratuitySituation gratuitySituation = paymentCode.getGratuitySituation();
        switch (gratuitySituation.getStudentCurricularPlan().getSpecialization()) {
            case STUDENT_CURRICULAR_PLAN_MASTER_DEGREE: {
                this.addMasterDegreeGratuityAmount(detailLine.getAmount());
                break;
            }
            case STUDENT_CURRICULAR_PLAN_INTEGRATED_MASTER_DEGREE: {
                this.addIntegratedMasterDegreeGratuityAmount(detailLine.getAmount());
                break;
            }
            case STUDENT_CURRICULAR_PLAN_SPECIALIZATION: {
                this.addSpecializationGratuityAmount(detailLine.getAmount());
                break;
            }
            default: {
                throw new RuntimeException("Unknown specialization " + gratuitySituation.getStudentCurricularPlan().getSpecialization().name());
            }
        }
    }

    public Money getDegreeChangeIndividualCandidacyAmount() {
        return this.degreeChangeIndividualCandidacyAmount;
    }

    public Money getDegreeTransferIndividualCandidacyAmount() {
        return this.degreeTransferIndividualCandidacyAmount;
    }

    public Money getSecondCycleIndividualCandidacyAmount() {
        return this.secondCycleIndividualCandidacyAmount;
    }

    public Money getDegreeCandidacyForGraduatedPersonAmount() {
        return this.degreeCandidacyForGraduatedPersonAmount;
    }

    public Money getRectorateAmount() {
        return this.rectorateAmount;
    }

    public void addDegreeChangeIndividualCandidacyAmount(Money money) {
        this.degreeChangeIndividualCandidacyAmount = this.degreeChangeIndividualCandidacyAmount.add(money);
    }

    public void addDegreeTransferIndividualCandidacyAmount(Money money) {
        this.degreeTransferIndividualCandidacyAmount = this.degreeTransferIndividualCandidacyAmount.add(money);
    }

    public void addSecondCycleIndividualCandidacyAmount(Money money) {
        this.secondCycleIndividualCandidacyAmount = this.secondCycleIndividualCandidacyAmount.add(money);
    }

    public void addDegreeCandidacyForGraduatedPersonAmount(Money money) {
        this.degreeCandidacyForGraduatedPersonAmount = this.degreeCandidacyForGraduatedPersonAmount.add(money);
    }

    public Money getStandaloneEnrolmentGratuityEventAmount() {
        return this.standaloneEnrolmentGratuityEventAmount;
    }

    public void addStandaloneEnrolmentGratuityEventAmount(Money amount) {
        this.standaloneEnrolmentGratuityEventAmount = this.standaloneEnrolmentGratuityEventAmount.add(amount);
    }

    public void addAmountForRectorate(Money amount) {
        this.rectorateAmount = this.rectorateAmount.add(amount);
    }
}

