/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collection;
import java.util.HashSet;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.Substitution_Base;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class Substitution
extends Substitution_Base {
    public Substitution() {
    }

    public Substitution(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    public Substitution(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    public Substitution(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Double credits, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, curriculumGroup, enrolments, new HashSet<CurricularCourse>(0), credits, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        this.checkEnrolments(enrolments);
        super.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, ExecutionSemester executionSemester) {
        this.checkEnrolments(enrolments);
        super.init(studentCurricularPlan, curriculumGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, ExecutionSemester executionSemester) {
        this.checkEnrolments(enrolments);
        super.init(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    private void checkEnrolments(Collection<IEnrolment> enrolments) {
        if (enrolments == null || enrolments.isEmpty()) {
            throw new DomainException("error.substitution.wrong.arguments", new String[0]);
        }
    }

    public final boolean isSubstitution() {
        return true;
    }

    public boolean isEquivalence() {
        return false;
    }

    public Grade getGrade() {
        return this.getEnrolmentsAverageGrade();
    }

    private Grade getEnrolmentsAverageGrade() {
        return null;
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.StudentResources", (String)"label.dismissal.Substitution", (String[])new String[0]);
    }

    @ConsistencyPredicate
    protected boolean checkGrade() {
        return true;
    }

    protected Collection<ICurriculumEntry> getAverageEntries(Dismissal dismissal, ExecutionYear executionYear) {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        for (EnrolmentWrapper enrolmentWrapper : this.getEnrolmentsSetBefore(executionYear)) {
            result.add(enrolmentWrapper.getIEnrolment());
        }
        return result;
    }
}

