/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.registrationStates;

import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum RegistrationStateType {
    REGISTERED(true, true),
    MOBILITY(true, true),
    CANCELED(false, false),
    CONCLUDED(false, true),
    FLUNKED(false, false),
    INTERRUPTED(false, false),
    SCHOOLPARTCONCLUDED(false, true),
    INTERNAL_ABANDON(false, false),
    EXTERNAL_ABANDON(false, false),
    TRANSITION(false, true),
    TRANSITED(false, true),
    STUDYPLANCONCLUDED(false, true),
    INACTIVE(false, false);

    private boolean active;
    private boolean canHaveCurriculumLinesOnCreation;

    private RegistrationStateType(boolean active, boolean canHaveCurriculumLinesOnCreation) {
        this.active = active;
        this.canHaveCurriculumLinesOnCreation = canHaveCurriculumLinesOnCreation;
    }

    public String getName() {
        return this.name();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.active;
    }

    public boolean canHaveCurriculumLinesOnCreation() {
        return this.canHaveCurriculumLinesOnCreation;
    }

    public String getQualifiedName() {
        return RegistrationStateType.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return RegistrationStateType.class.getName() + "." + this.name();
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public boolean canReingress() {
        return this == FLUNKED || this == INTERRUPTED || this == INTERNAL_ABANDON || this == EXTERNAL_ABANDON || this == CANCELED || this == INACTIVE;
    }
}

