/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.candidacy.EPFLPhdCandidacyPeriod$callable$create;
import org.fenixedu.academic.domain.phd.candidacy.EPFLPhdCandidacyPeriod_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodType;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.phd.EPFLPhdCandidacyProcessProperties;
import org.fenixedu.academic.util.phd.PhdProperties;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EPFLPhdCandidacyPeriod
extends EPFLPhdCandidacyPeriod_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected EPFLPhdCandidacyPeriod() {
    }

    protected EPFLPhdCandidacyPeriod(ExecutionYear executionYear, DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        this();
        this.init(executionYear, start, end, type);
    }

    protected void init(ExecutionYear executionYear, DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        this.checkIfCanCreate(start, end);
        if (!PhdCandidacyPeriodType.EPFL.equals((Object)type)) {
            throw new DomainException("error.EPFLPhdCandidacyPeriod.type.must.be.epfl", new String[0]);
        }
        super.init(executionYear, start, end, type);
    }

    private void checkIfCanCreate(DateTime start, DateTime end) {
        for (CandidacyPeriod period : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (period.equals((Object)this) || !period.isEpflCandidacyPeriod() || !period.intercept(start, end)) continue;
            throw new DomainException("error.EPFLInstitutionPhdCandidacyPeriod.already.contains.candidacyPeriod.in.given.dates", new String[0]);
        }
    }

    public boolean isEpflCandidacyPeriod() {
        return true;
    }

    public static EPFLPhdCandidacyPeriod create(PhdCandidacyPeriodBean phdCandidacyPeriodBean) {
        return (EPFLPhdCandidacyPeriod)((Object)advice$create.perform((Callable)new EPFLPhdCandidacyPeriod$callable$create(phdCandidacyPeriodBean)));
    }

    static /* synthetic */ EPFLPhdCandidacyPeriod advised$create(PhdCandidacyPeriodBean phdCandidacyPeriodBean) {
        ExecutionYear executionYear = phdCandidacyPeriodBean.getExecutionYear();
        DateTime start = phdCandidacyPeriodBean.getStart();
        DateTime end = phdCandidacyPeriodBean.getEnd();
        PhdCandidacyPeriodType type = phdCandidacyPeriodBean.getType();
        return new EPFLPhdCandidacyPeriod(executionYear, start, end, type);
    }

    public static boolean isAnyEPFLPhdCandidacyPeriodActive() {
        return EPFLPhdCandidacyPeriod.isAnyEPFLPhdCandidacyPeriodActive(new DateTime());
    }

    public static boolean isAnyEPFLPhdCandidacyPeriodActive(DateTime date) {
        return EPFLPhdCandidacyPeriod.readEPFLPhdCandidacyPeriodForDateTime(date) != null;
    }

    public static EPFLPhdCandidacyPeriod readEPFLPhdCandidacyPeriodForDateTime(DateTime date) {
        for (CandidacyPeriod period : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!period.isEpflCandidacyPeriod() || !period.contains(date)) continue;
            return (EPFLPhdCandidacyPeriod)((Object)period);
        }
        return null;
    }

    public static EPFLPhdCandidacyPeriod getMostRecentCandidacyPeriod() {
        PhdCandidacyPeriod mostRecentCandidacyPeriod = null;
        for (CandidacyPeriod candidacyPeriod : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!candidacyPeriod.isEpflCandidacyPeriod() || candidacyPeriod.getStart().isAfterNow()) continue;
            if (mostRecentCandidacyPeriod == null) {
                mostRecentCandidacyPeriod = (PhdCandidacyPeriod)((Object)candidacyPeriod);
                continue;
            }
            if (!candidacyPeriod.getStart().isAfter((ReadableInstant)mostRecentCandidacyPeriod.getStart())) continue;
            mostRecentCandidacyPeriod = (PhdCandidacyPeriod)((Object)candidacyPeriod);
        }
        return (EPFLPhdCandidacyPeriod)((Object)mostRecentCandidacyPeriod);
    }

    public String getEmailMessageBodyForRefereeForm(PhdCandidacyReferee referee) {
        return String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.body.referee", (String[])new String[0]), referee.getPhdProgramCandidacyProcess().getIndividualProgramProcess().getPhdProgramFocusArea().getName().getContent(), EPFLPhdCandidacyProcessProperties.getConfiguration().getPublicCandidacyRefereeFormLink(), referee.getValue(), referee.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().getEnd().toString("yyyy-MM-dd HH:mm"));
    }

    public MultiLanguageString getEmailMessageSubjectForMissingCandidacyValidation(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString().with(MultiLanguageString.en, BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.subject.missing.candidacy.validation", (String[])new String[0]));
    }

    public MultiLanguageString getEmailMessageBodyForMissingCandidacyValidation(PhdIndividualProgramProcess process2) {
        String body = String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.body.missing.candidacy.validation", (String[])new String[0]), PhdProperties.getPublicCandidacyAccessLink(), process2.getCandidacyProcess().getCandidacyHashCode().getValue());
        return new MultiLanguageString().with(MultiLanguageString.en, body);
    }
}

