/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant_Base;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class InternalPhdParticipant
extends InternalPhdParticipant_Base {
    private InternalPhdParticipant() {
    }

    InternalPhdParticipant(PhdIndividualProgramProcess process2, PhdParticipantBean bean) {
        this();
        this.checkPerson(process2, bean.getPerson());
        this.init(process2);
        this.setPerson(bean.getPerson());
        this.setTitle(bean.getTitle());
        this.setInstitution(bean.getInstitution());
        this.setWorkLocation(bean.getWorkLocation());
    }

    private void checkPerson(PhdIndividualProgramProcess process2, Person person) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.InternalPhdParticipant.process.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (person == null) {
            throw new DomainException("error.InternalPhdParticipant.person.cannot.be.null", args1);
        }
        for (PhdParticipant participant : process2.getParticipantsSet()) {
            if (!participant.isFor(person)) continue;
            throw new DomainException("error.InternalPhdParticipant.person.already.is.participant", new String[0]);
        }
    }

    public String getName() {
        return this.getPerson().getName();
    }

    public String getQualification() {
        Qualification qualification = this.getPerson().getLastQualification();
        return qualification != null ? qualification.getType().getLocalizedName() : "";
    }

    public String getCategory() {
        if (!StringUtils.isEmpty((String)super.getCategory())) {
            return super.getCategory();
        }
        return this.getTeacher() != null && this.getTeacher().getLastCategory() != null ? this.getTeacher().getLastCategory().getName().getContent() : "";
    }

    public Teacher getTeacher() {
        return this.getPerson().getTeacher();
    }

    public Department getDepartment() {
        if (this.isTeacher()) {
            return this.getTeacher().getDepartment();
        }
        return null;
    }

    public String getWorkLocation() {
        return this.getRootDomainObject().getInstitutionUnit().getName();
    }

    public String getInstitution() {
        return this.getRootDomainObject().getInstitutionUnit().getParentUnits().iterator().next().getName();
    }

    public String getAddress() {
        PhysicalAddress address = this.getPerson().getDefaultPhysicalAddress();
        return address != null ? this.writeAddress(address) : "";
    }

    private String writeAddress(PhysicalAddress address) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringUtils.isEmpty((String)address.getAddress()) ? "" : address.getAddress());
        if (!StringUtils.isEmpty((String)address.getAreaCode())) {
            buffer.append(", ").append(address.getAreaCode());
        }
        if (!StringUtils.isEmpty((String)address.getAreaOfAreaCode())) {
            buffer.append(", ").append(address.getAreaOfAreaCode());
        }
        return buffer.toString();
    }

    public String getEmail() {
        return this.getPerson().getEmailForSendingEmails();
    }

    public String getPhone() {
        String phone = this.getPerson().getDefaultPhoneNumber();
        return !StringUtils.isEmpty((String)phone) ? phone : this.getPerson().getDefaultMobilePhoneNumber();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getIndividualProcess().isCoordinatorForPhdProgram(this.getPerson())) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.cannotdeletePhdParticipant", (String[])new String[0]));
        }
    }

    protected void disconnect() {
        this.setPerson(null);
        super.disconnect();
    }

    public boolean isFor(Person person) {
        return this.getPerson() == person;
    }

    public boolean isInternal() {
        return true;
    }

    public boolean isTeacher() {
        return this.getTeacher() != null;
    }

    public String getRoleOnProcess() {
        if (this.getIndividualProcess().isGuider(this.getPerson())) {
            return BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.guiding", (String[])new String[0]);
        }
        if (this.getIndividualProcess().isAssistantGuider(this.getPerson())) {
            return BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.assistant.guiding", (String[])new String[0]);
        }
        return null;
    }

    static {
        InternalPhdParticipant.getRelationInternalPhdParticipantPerson().addListener((RelationListener)new RelationAdapter<Person, InternalPhdParticipant>(){

            public void beforeAdd(Person person, InternalPhdParticipant participant) {
                if (participant != null && person != null) {
                    for (PhdParticipant each : participant.getIndividualProcess().getParticipantsSet()) {
                        if (!each.isInternal() || !((InternalPhdParticipant)((Object)each)).isFor(person)) continue;
                        throw new DomainException("phd.InternalPhdParticipant.process.already.has.participant.for.person", new String[0]);
                    }
                }
            }
        });
    }
}

