/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.DegreeCandidacy;
import org.fenixedu.academic.domain.candidacy.IMDCandidacy;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.MDCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.Formation;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyInternalPersonDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy_Base;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationForIndividualCandidacyFactory;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public abstract class IndividualCandidacy
extends IndividualCandidacy_Base {
    protected IndividualCandidacy() {
        super.setWhenCreated(new DateTime());
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected Person init(IndividualCandidacyProcessBean bean, IndividualCandidacyProcess process2) {
        Person person = null;
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            person = bean.getOrCreatePersonFromBean();
        }
        this.checkParameters(person, process2, bean);
        bean.getPersonBean().setPerson(person);
        IndividualCandidacyPersonalDetails.createDetails(this, bean);
        this.setCandidacyProcess(process2);
        this.setCandidacyDate(bean.getCandidacyDate());
        this.setState(IndividualCandidacyState.STAND_BY);
        this.editObservations(bean);
        this.setUtlStudent(bean.getUtlStudent());
        this.createPrecedentDegreeInformation(bean);
        return person;
    }

    protected abstract void checkParameters(Person var1, IndividualCandidacyProcess var2, IndividualCandidacyProcessBean var3);

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, LocalDate candidacyDate) {
        if (process2 == null) {
            throw new DomainException("error.IndividualCandidacy.invalid.process", new String[0]);
        }
        if (candidacyDate == null || !process2.hasOpenCandidacyPeriod(candidacyDate.toDateTimeAtCurrentTime())) {
            throw new DomainException("error.IndividualCandidacy.invalid.candidacyDate", process2.getCandidacyStart().toString("dd/MM/yyyy"), process2.getCandidacyEnd().toString("dd/MM/yyyy"));
        }
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.IndividualCandidacy.cannot.modify.when.created", new String[0]);
    }

    public boolean hasAnyPayment() {
        return this.getEvent() != null && this.getEvent().hasAnyPayments();
    }

    public void editPersonalCandidacyInformation(PersonBean personBean) {
        this.getPersonalDetails().edit(personBean);
    }

    public void editPersonalCandidacyInformationPublic(PersonBean personBean) {
        this.getPersonalDetails().editPublic(personBean);
    }

    public void cancel(Person person) {
        this.checkRulesToCancel();
        this.setState(IndividualCandidacyState.CANCELLED);
        this.setResponsible(person.getUsername());
        if (this.getEvent() != null) {
            this.getEvent().cancel("IndividualCandidacy.canceled");
        }
    }

    public void reject(Person person) {
        this.setState(IndividualCandidacyState.REJECTED);
        this.setResponsible(person.getUsername());
    }

    public void revertToStandBy(Person person) {
        this.setState(IndividualCandidacyState.STAND_BY);
        this.setResponsible(person.getUsername());
    }

    protected void checkRulesToCancel() {
        if (this.getEvent() != null && this.hasAnyPayment()) {
            throw new DomainException("error.IndividualCandidacy.cannot.cancel.candidacy.with.payments", new String[0]);
        }
    }

    public Person getResponsiblePerson() {
        return Person.readPersonByUsername(this.getResponsible());
    }

    public boolean isInStandBy() {
        return this.getState() == IndividualCandidacyState.STAND_BY;
    }

    public boolean isAccepted() {
        return this.getState() == IndividualCandidacyState.ACCEPTED;
    }

    public boolean isNotAccepted() {
        return this.getState() == IndividualCandidacyState.NOT_ACCEPTED;
    }

    public boolean isCancelled() {
        return this.getState() == IndividualCandidacyState.CANCELLED;
    }

    public boolean isRejected() {
        return this.getState() == IndividualCandidacyState.REJECTED;
    }

    public boolean isDebtPayed() {
        return this.getEvent() == null || this.getEvent() != null && this.getEvent().isClosed();
    }

    public boolean isFor(ExecutionInterval executionInterval) {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isFor(executionInterval);
    }

    protected boolean isCandidacyResultStateValid(IndividualCandidacyState state) {
        return state == IndividualCandidacyState.ACCEPTED || state == IndividualCandidacyState.REJECTED;
    }

    protected void createPrecedentDegreeInformation(IndividualCandidacyProcessBean processBean) {
        PrecedentDegreeInformationForIndividualCandidacyFactory.create(this, processBean);
    }

    public Registration createRegistration(DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        if (this.getRegistration() != null) {
            throw new DomainException("error.IndividualCandidacy.person.with.registration", degreeCurricularPlan.getPresentationName());
        }
        if (this.hasActiveRegistration(degreeCurricularPlan)) {
            Registration registration = this.getStudent().getActiveRegistrationFor(degreeCurricularPlan);
            this.setRegistration(registration);
            return registration;
        }
        this.getPersonalDetails().ensurePersonInternalization();
        return this.createRegistration(this.getPersonalDetails().getPerson(), degreeCurricularPlan, cycleType, ingressionType);
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = new Registration(person, degreeCurricularPlan, cycleType);
        registration.setEntryPhase(EntryPhase.FIRST_PHASE);
        registration.setIngressionType(ingressionType);
        registration.editStartDates(this.getStartDate(), registration.getHomologationDate(), registration.getStudiesStartDate());
        this.createRaidesInformation(registration);
        this.setRegistration(registration);
        return registration;
    }

    protected void createRaidesInformation(Registration registration) {
        Degree degree = registration.getDegree();
        ExecutionYear startExecutionYear = registration.getStartExecutionYear();
        ExecutionDegree executionDegree = ExecutionDegree.getAllByDegreeAndExecutionYear(degree, startExecutionYear.getName()).iterator().next();
        Object studentCandidacy = null;
        if (registration.getDegree().getDegreeType().isIntegratedMasterDegree()) {
            studentCandidacy = new IMDCandidacy(registration.getPerson(), executionDegree);
        } else if (registration.getDegree().getDegreeType().isDegree()) {
            studentCandidacy = new DegreeCandidacy(registration.getPerson(), executionDegree);
        } else if (registration.getDegree().getDegreeType().isMasterDegree()) {
            studentCandidacy = new MDCandidacy(registration.getPerson(), executionDegree);
        }
        studentCandidacy.getPrecedentDegreeInformation().delete();
        PrecedentDegreeInformation refactoredPrecedentDegreeInformation = this.getRefactoredPrecedentDegreeInformation();
        refactoredPrecedentDegreeInformation.setRegistration(registration);
        studentCandidacy.setPrecedentDegreeInformation(refactoredPrecedentDegreeInformation);
        studentCandidacy.setRegistration(registration);
        PersonalIngressionData personalIngressionDataByExecutionYear = registration.getStudent().getPersonalIngressionDataByExecutionYear(startExecutionYear);
        if (personalIngressionDataByExecutionYear != null) {
            personalIngressionDataByExecutionYear.addPrecedentDegreesInformations(refactoredPrecedentDegreeInformation);
        } else {
            new PersonalIngressionData(registration.getStudent(), startExecutionYear, refactoredPrecedentDegreeInformation);
        }
    }

    protected boolean hasActiveRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getPersonalDetails().hasStudent() && this.getPersonalDetails().getStudent().hasActiveRegistrationFor(degreeCurricularPlan);
    }

    protected YearMonthDay getStartDate() {
        ExecutionInterval interval = this.getCandidacyExecutionInterval();
        return interval.isCurrent() ? new YearMonthDay() : interval.getBeginDateYearMonthDay();
    }

    public Student getStudent() {
        return this.getPersonalDetails().getStudent();
    }

    public boolean hasStudent() {
        return this.getStudent() != null;
    }

    protected ExecutionInterval getCandidacyExecutionInterval() {
        return this.getCandidacyProcess() != null ? this.getCandidacyProcess().getCandidacyExecutionInterval() : null;
    }

    public abstract Collection<Degree> getAllDegrees();

    protected boolean personHasDegree(Person person, Degree selectedDegree) {
        if (person.getStudent() == null) {
            return false;
        }
        List<Registration> registrationsFor = this.getNotCanceledRegistrationsFor(person, selectedDegree);
        if (registrationsFor.isEmpty()) {
            return false;
        }
        return registrationsFor.size() != 1 || registrationsFor.iterator().next() != this.getRegistration();
    }

    private List<Registration> getNotCanceledRegistrationsFor(Person person, Degree selectedDegree) {
        List<Registration> registrationsFor = person.getStudent().getRegistrationsFor(selectedDegree);
        ArrayList<Registration> notCanceledRegistrationsForDegree = new ArrayList<Registration>();
        for (Registration registration : registrationsFor) {
            if (registration.isCanceled()) continue;
            notCanceledRegistrationsForDegree.add(registration);
        }
        return notCanceledRegistrationsForDegree;
    }

    protected boolean personHasOneOfDegrees(Person person, Set<Degree> selectedDegrees) {
        if (person.getStudent() == null) {
            return false;
        }
        for (Degree degree : selectedDegrees) {
            if (!person.getStudent().hasActiveRegistrationFor(degree)) continue;
            return true;
        }
        return false;
    }

    public void editObservations(IndividualCandidacyProcessBean bean) {
        this.setObservations(bean.getObservations());
    }

    public Boolean isCandidacyInternal() {
        return this.getPersonalDetails() instanceof IndividualCandidacyInternalPersonDetails;
    }

    protected abstract void createDebt(Person var1);

    public void bindPerson(ChoosePersonBean bean) {
        if (this.isCandidacyInternal().booleanValue()) {
            throw new DomainException("error.bind.candidacy.internal", new String[0]);
        }
        Person selectedPerson = bean.getPerson();
        if (selectedPerson != null) {
            selectedPerson.edit(this.getPersonalDetails());
            this.setPersonalDetails((IndividualCandidacyPersonalDetails)((Object)new IndividualCandidacyInternalPersonDetails(this, selectedPerson)));
        } else {
            selectedPerson = new Person(this.getPersonalDetails());
            this.setPersonalDetails((IndividualCandidacyPersonalDetails)((Object)new IndividualCandidacyInternalPersonDetails(this, selectedPerson)));
        }
        this.createDebt(this.getPersonalDetails().getPerson());
    }

    protected void createFormationEntries(List<FormationBean> formationConcludedBeanList, List<FormationBean> formationNonConcludedBeanList) {
        for (FormationBean formation : formationConcludedBeanList) {
            this.addFormations(new Formation(this, formation));
        }
        for (FormationBean formation : formationNonConcludedBeanList) {
            this.addFormations(new Formation(this, formation));
        }
    }

    public List<Formation> getConcludedFormationList() {
        return new ArrayList<Formation>(CollectionUtils.select((Collection)this.getFormationsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((Formation)((Object)arg0)).getConcluded();
            }
        }));
    }

    public List<Formation> getNonConcludedFormationList() {
        return new ArrayList<Formation>(CollectionUtils.select((Collection)this.getFormationsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((Formation)((Object)arg0)).getConcluded() == false;
            }
        }));
    }

    public void editFormationEntries(List<FormationBean> formationConcludedBeanList, List<FormationBean> formationNonConcludedBeanList) {
        ArrayList<Formation> formationsToBeRemovedList = new ArrayList<Formation>();
        for (Formation formation : this.getFormationsSet()) {
            if (!formation.getConcluded().booleanValue()) continue;
            this.editFormationEntry(formationConcludedBeanList, formationsToBeRemovedList, formation);
        }
        for (Formation formation : this.getFormationsSet()) {
            if (formation.getConcluded().booleanValue()) continue;
            this.editFormationEntry(formationNonConcludedBeanList, formationsToBeRemovedList, formation);
        }
        for (Formation formation : formationsToBeRemovedList) {
            this.getFormationsSet().remove((Object)formation);
            formation.delete();
        }
        for (FormationBean bean : formationConcludedBeanList) {
            if (bean.getFormation() != null) continue;
            this.addFormations(new Formation(this, bean));
        }
        for (FormationBean bean : formationNonConcludedBeanList) {
            if (bean.getFormation() != null) continue;
            this.addFormations(new Formation(this, bean));
        }
    }

    private void editFormationEntry(List<FormationBean> formationConcludedBeanList, List<Formation> formationsToBeRemovedList, final Formation formation) {
        FormationBean bean = (FormationBean)CollectionUtils.find(formationConcludedBeanList, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                FormationBean bean = (FormationBean)arg0;
                return bean.getFormation() == formation;
            }
        });
        if (bean == null) {
            formationsToBeRemovedList.add(formation);
        } else {
            formation.edit(bean);
        }
    }

    public void exportValues(StringBuilder result) {
        Formatter formatter = new Formatter(result);
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.candidacy", (String[])new String[0]), this.getCandidacyExecutionInterval().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.state", (String[])new String[0]), this.getState().getLocalizedName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.whenCreated", (String[])new String[0]), this.getWhenCreated().toString("yyy-MM-dd"));
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.candidacyDate", (String[])new String[0]), this.getCandidacyDate().toString());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.responsible", (String[])new String[0]), StringUtils.isEmpty((String)this.getResponsible()) ? "" : this.getResponsible());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.notes", (String[])new String[0]), StringUtils.isEmpty((String)this.getNotes()) ? "" : this.getNotes());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.IndividualCandidacy.observations", (String[])new String[0]), StringUtils.isEmpty((String)this.getObservations()) ? "" : this.getObservations());
        for (Formation formation : this.getFormationsSet()) {
            formation.exportValues(result);
        }
        formatter.close();
    }

    public abstract String getDescription();

    public boolean isDegreeCandidacyForGraduatedPerson() {
        return false;
    }

    public boolean isDegreeChange() {
        return false;
    }

    public boolean isDegreeTransfer() {
        return false;
    }

    public boolean isErasmus() {
        return false;
    }

    public boolean isOver23() {
        return false;
    }

    public boolean isSecondCycle() {
        return false;
    }

    public boolean isStandalone() {
        return false;
    }

    void editPrecedentDegreeInformation(IndividualCandidacyProcessBean bean) {
        PrecedentDegreeInformationForIndividualCandidacyFactory.edit(bean);
    }
}

