/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.installments;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.installments.PartialRegimeInstallment_Base;
import org.fenixedu.academic.domain.accounting.paymentPlans.FullGratuityPaymentPlanForPartialRegime;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class PartialRegimeInstallment
extends PartialRegimeInstallment_Base {
    protected PartialRegimeInstallment() {
    }

    public PartialRegimeInstallment(FullGratuityPaymentPlanForPartialRegime paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal ectsForAmount, List<ExecutionSemester> executionSemesters) {
        this();
        this.init(paymentPlan, amount, startDate, endDate, false, null, null, null, ectsForAmount, executionSemesters);
    }

    private void init(FullGratuityPaymentPlanForPartialRegime paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, boolean penaltyAppliable, BigDecimal penaltyPercentage, YearMonthDay whenStartToApplyPenalty, Integer maxMonthsToApplyPenalty, BigDecimal ectsForAmount, List<ExecutionSemester> executionSemesters) {
        if (penaltyAppliable) {
            super.init((PaymentPlan)((Object)paymentPlan), amount, startDate, endDate, penaltyPercentage, whenStartToApplyPenalty, maxMonthsToApplyPenalty);
        } else {
            super.init((PaymentPlan)((Object)paymentPlan), amount, startDate, endDate);
        }
        this.checkParameters(ectsForAmount, executionSemesters);
        super.setPenaltyAppliable(Boolean.valueOf(penaltyAppliable));
        super.setEctsForAmount(ectsForAmount);
        for (ExecutionSemester executionSemester : executionSemesters) {
            super.addExecutionSemesters(executionSemester);
        }
    }

    private void checkParameters(BigDecimal ectsForAmount, List<ExecutionSemester> executionSemesters) {
        if (ectsForAmount == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.installments.PartialRegimeInstallment.ectsForAmount.cannot.be.null", new String[0]);
        }
        if (executionSemesters == null || executionSemesters.isEmpty()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.installments.PartialRegimeInstallment.executionSemesters.cannot.be.null.or.empty", new String[0]);
        }
    }

    public PartialRegimeInstallment(FullGratuityPaymentPlanForPartialRegime paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage, YearMonthDay whenStartToApplyPenalty, Integer maxMonthsToApplyPenalty, BigDecimal ectsForAmount, List<ExecutionSemester> executionSemesters) {
        this();
        this.init(paymentPlan, amount, startDate, endDate, true, penaltyPercentage, whenStartToApplyPenalty, maxMonthsToApplyPenalty, ectsForAmount, executionSemesters);
    }

    protected Money calculateBaseAmount(Event event) {
        BigDecimal enroledEcts = this.getEnroledEcts((GratuityEvent)((Object)event));
        if (enroledEcts.compareTo(BigDecimal.ZERO) == 0) {
            return Money.ZERO;
        }
        BigDecimal proporcionToPay = enroledEcts.divide(this.getEctsForAmount());
        BigDecimal amount = this.getAmount().getAmount().setScale(10);
        return new Money(amount.multiply(new BigDecimal("0.5")).multiply(BigDecimal.ONE.add(proporcionToPay)));
    }

    protected Money calculatePenaltyAmount(Event event, DateTime when, BigDecimal discountPercentage) {
        if (this.isPenaltyAppliable()) {
            return super.calculatePenaltyAmount(event, when, discountPercentage);
        }
        return Money.ZERO;
    }

    private BigDecimal getEnroledEcts(GratuityEvent gratuityEvent) {
        BigDecimal total = BigDecimal.ZERO;
        for (Enrolment enrolment : this.collectEnrolments(gratuityEvent)) {
            total = total.add(enrolment.getEctsCreditsForCurriculum());
        }
        return total;
    }

    private Set<Enrolment> collectEnrolments(GratuityEvent gratuityEvent) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (ExecutionSemester executionSemester : this.getExecutionSemestersSet()) {
            for (CycleCurriculumGroup cycleCurriculumGroup : gratuityEvent.getStudentCurricularPlan().getCycleCurriculumGroups()) {
                for (Enrolment enrolment : cycleCurriculumGroup.getEnrolmentsBy(executionSemester)) {
                    result.add(enrolment);
                }
            }
        }
        return result;
    }

    public FullGratuityPaymentPlanForPartialRegime getPaymentPlan() {
        return (FullGratuityPaymentPlanForPartialRegime)((Object)super.getPaymentPlan());
    }

    public boolean isPenaltyAppliable() {
        return this.getPenaltyAppliable();
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        if (this.isPenaltyAppliable()) {
            labelFormatter.appendLabel("resources.ApplicationResources", "label.PartialRegimeInstallment.description.with.penalty", this.getInstallmentOrder().toString(), this.getStartDate().toString("dd/MM/yyyy"), this.getEndDate().toString("dd/MM/yyyy"), this.buildExecutionSemesterDescription(), this.getPenaltyPercentage().multiply(BigDecimal.valueOf(100L)).toString(), this.getWhenStartToApplyPenalty().toString("dd/MM/yyyy"));
        } else {
            labelFormatter.appendLabel("resources.ApplicationResources", "label.PartialRegimeInstallment.description.without.penalty", this.getInstallmentOrder().toString(), this.getStartDate().toString("dd/MM/yyyy"), this.getEndDate().toString("dd/MM/yyyy"), this.buildExecutionSemesterDescription());
        }
        return labelFormatter;
    }

    private String buildExecutionSemesterDescription() {
        StringBuilder result = new StringBuilder();
        for (ExecutionSemester executionSemester : this.getExecutionSemestersSet()) {
            result.append(executionSemester.getName()).append(", ");
        }
        if (result.length() > 0 && result.toString().endsWith(", ")) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }

    public void delete() {
        this.getExecutionSemestersSet().clear();
        super.delete();
    }

    public void edit(InstallmentBean bean) {
        ArrayList<ExecutionSemester> executionSemesters = new ArrayList<ExecutionSemester>(bean.getExecutionSemesters());
        BigDecimal ectsForAmount = bean.getEctsForAmount();
        this.checkParameters(ectsForAmount, executionSemesters);
        for (ExecutionSemester executionSemester : executionSemesters) {
            super.addExecutionSemesters(executionSemester);
        }
        super.setEctsForAmount(ectsForAmount);
        super.edit(bean);
    }
}

