/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExternalDegreeEnrolment_Base;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.enrolment.ExternalDegreeEnrolmentWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.academic.util.MultiLanguageString;

public class ExternalDegreeEnrolment
extends ExternalDegreeEnrolment_Base {
    public ExternalDegreeEnrolment() {
    }

    public ExternalDegreeEnrolment(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this();
        this.checkParameters(studentCurricularPlan, curriculumGroup, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.checkInitConstraints(studentCurricularPlan, curricularCourse, executionSemester);
        this.initializeAsNew(studentCurricularPlan, curriculumGroup, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    private void checkParameters(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        if (studentCurricularPlan == null || curriculumGroup == null || curricularCourse == null || executionSemester == null || enrolmentCondition == null || createdBy == null) {
            throw new DomainException("error.ExternalDegreeEnrolment.invalid.parameters", new String[0]);
        }
    }

    public MultiLanguageString getName() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (!StringUtils.isEmpty((String)this.getDegreeModule().getName())) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getDegreeModule().getName() + " (" + this.getDegreeCurricularPlanOfDegreeModule().getName() + ")");
        }
        if (!StringUtils.isEmpty((String)this.getDegreeModule().getNameEn())) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getDegreeModule().getNameEn() + " (" + this.getDegreeCurricularPlanOfDegreeModule().getName() + ")");
        }
        return multiLanguageString;
    }

    public final StringBuilder print(String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append("[E ").append(this.getDegreeModule().getName()).append(" (");
        builder.append(this.getDegreeCurricularPlanOfDegreeModule().getName()).append(") ]\n");
        return builder;
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        if (this.isValid(executionSemester) && this.isEnroled()) {
            return Collections.singleton(new ExternalDegreeEnrolmentWrapper((Enrolment)((Object)this), executionSemester));
        }
        return Collections.emptySet();
    }
}

