/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.transition;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.commons.student.StudentNumberBean;
import org.fenixedu.academic.ui.struts.action.commons.transition.AbstractBolonhaTransitionManagementDA;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=ManagerApplications.ManagerBolonhaTransitionApp.class, path="student-curriculum", titleKey="title.student.curriculum")
@Mapping(module="manager", path="/bolonhaTransitionManagement", formBean="bolonhaTransitionManagementForm", scope="request", parameter="method")
@Forwards(value={@Forward(name="chooseStudent", path="/manager/transition/bolonha/chooseStudent.jsp"), @Forward(name="showStudentCurricularPlan", path="/manager/transition/bolonha/showStudentCurricularPlan.jsp"), @Forward(name="chooseRegistration", path="/manager/transition/bolonha/chooseRegistration.jsp")})
public class BolonhaTransitionManagementDA
extends AbstractBolonhaTransitionManagementDA {
    @EntryPoint
    public ActionForward prepareChooseStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentNumberBean", (Object)new StudentNumberBean());
        return mapping.findForward("chooseStudent");
    }

    public ActionForward chooseStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentNumberBean studentNumberBean = (StudentNumberBean)this.getObjectFromViewState("student-number-bean");
        request.setAttribute("studentId", (Object)Student.readStudentByNumber(studentNumberBean.getNumber()).getExternalId());
        return this.prepare(mapping, form, request, response);
    }

    @Override
    protected List<Registration> getRegistrations(HttpServletRequest request) {
        Student student = this.getStudent(request);
        return student != null ? student.getTransitionRegistrations() : Collections.emptyList();
    }

    private Student getStudent(HttpServletRequest request) {
        return (Student)((Object)this.getDomainObject(request, "studentId"));
    }
}

