/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.administrativeOffice.ExecutionDegreeBean;
import org.fenixedu.academic.dto.candidacy.IngressionInformationBean;
import org.fenixedu.academic.dto.candidacy.OriginInformationBean;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.student.administrativeOfficeServices.CreateStudent;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminStudentsApp.class, path="create-student", titleKey="link.studentOperations.createStudent", accessGroup="academic(CREATE_REGISTRATION)")
@Mapping(path="/createStudent", module="academicAdministration")
@Forwards(value={@Forward(name="chooseNewStudentExecutionDegreeAndIdentification", path="/academicAdminOffice/chooseNewStudentExecutionDegreeAndIdentification.jsp"), @Forward(name="fillNewPersonData", path="/academicAdminOffice/fillNewPersonData.jsp"), @Forward(name="fillOriginInformation", path="/academicAdminOffice/fillOriginInformation.jsp"), @Forward(name="createStudentSuccess", path="/academicAdminOffice/createStudentSuccess.jsp"), @Forward(name="showCreateStudentConfirmation", path="/academicAdminOffice/showCreateStudentConfirmation.jsp")})
public class StudentOperationsDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareCreateStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", (Object)new ExecutionDegreeBean());
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseDegreePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState().getMetaObject().getObject();
        executionDegreeBean.setDegreeCurricularPlan(null);
        executionDegreeBean.setExecutionDegree(null);
        RenderUtils.invalidateViewState();
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseDegreeCurricularPlanPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState().getMetaObject().getObject();
        ExecutionDegree executionDegree = null;
        if (executionDegreeBean.getDegreeCurricularPlan() != null) {
            executionDegree = executionDegreeBean.getDegreeCurricularPlan().getExecutionDegreeByYear(executionDegreeBean.getExecutionYear());
        }
        executionDegreeBean.setExecutionDegree(executionDegree);
        RenderUtils.invalidateViewState();
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        request.setAttribute("ingressionInformationBean", (Object)new IngressionInformationBean());
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseAgreementPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState((String)"executionDegree").getMetaObject().getObject();
        IngressionInformationBean ingressionInformationBean = (IngressionInformationBean)RenderUtils.getViewState((String)"chooseIngression").getMetaObject().getObject();
        RenderUtils.invalidateViewState();
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        request.setAttribute("ingressionInformationBean", (Object)ingressionInformationBean);
        if (ingressionInformationBean.getRegistrationProtocol() != null && !ingressionInformationBean.getRegistrationProtocol().isEnrolmentByStudentAllowed()) {
            request.setAttribute("choosePersonBean", (Object)new ChoosePersonBean());
        }
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseIngressionPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState((String)"executionDegree").getMetaObject().getObject();
        IngressionInformationBean ingressionInformationBean = (IngressionInformationBean)RenderUtils.getViewState((String)"chooseIngression").getMetaObject().getObject();
        RenderUtils.invalidateViewState();
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        request.setAttribute("ingressionInformationBean", (Object)ingressionInformationBean);
        if (ingressionInformationBean.getIngressionType() != null && !ingressionInformationBean.getIngressionType().hasEntryPhase()) {
            ingressionInformationBean.clearEntryPhase();
            request.setAttribute("choosePersonBean", (Object)new ChoosePersonBean());
        }
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseEntryPhasePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState((String)"executionDegree").getMetaObject().getObject();
        IngressionInformationBean ingressionInformationBean = (IngressionInformationBean)RenderUtils.getViewState((String)"chooseIngression").getMetaObject().getObject();
        RenderUtils.invalidateViewState((String)"executionDegree");
        RenderUtils.invalidateViewState((String)"chooseIngression");
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        request.setAttribute("ingressionInformationBean", (Object)ingressionInformationBean);
        request.setAttribute("choosePersonBean", (Object)new ChoosePersonBean());
        return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
    }

    public ActionForward chooseExecutionDegreeInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", RenderUtils.getViewState().getMetaObject().getObject());
        return mapping.getInputForward();
    }

    public ActionForward choosePerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeBean executionDegreeBean = (ExecutionDegreeBean)RenderUtils.getViewState((String)"executionDegree").getMetaObject().getObject();
        IngressionInformationBean ingressionInformationBean = (IngressionInformationBean)RenderUtils.getViewState((String)"chooseIngression").getMetaObject().getObject();
        PrecedentDegreeInformationBean precedentDegreeInformationBean = RenderUtils.getViewState((String)"precedentDegreeInformation") == null ? new PrecedentDegreeInformationBean() : (PrecedentDegreeInformationBean)RenderUtils.getViewState((String)"precedentDegreeInformation").getMetaObject().getObject();
        request.setAttribute("executionDegreeBean", (Object)executionDegreeBean);
        request.setAttribute("ingressionInformationBean", (Object)ingressionInformationBean);
        request.setAttribute("precedentDegreeInformationBean", (Object)precedentDegreeInformationBean);
        PersonBean personBean = null;
        Person person = null;
        if (RenderUtils.getViewState((String)"person") != null) {
            request.setAttribute("personBean", RenderUtils.getViewState((String)"person").getMetaObject().getObject());
            return mapping.findForward("fillNewPersonData");
        }
        ChoosePersonBean choosePersonBean = (ChoosePersonBean)RenderUtils.getViewState((String)"choosePerson").getMetaObject().getObject();
        String identificationNumber = choosePersonBean.getIdentificationNumber();
        YearMonthDay dateOfBirth = choosePersonBean.getDateOfBirth();
        if (choosePersonBean.getPerson() == null) {
            Collection<Person> persons = Person.findPersonByDocumentID(identificationNumber);
            if (choosePersonBean.isFirstTimeSearch()) {
                choosePersonBean.setFirstTimeSearch(false);
                if (!persons.isEmpty() || !Person.findByDateOfBirth(dateOfBirth, Person.findPersonMatchingFirstAndLastName(choosePersonBean.getName())).isEmpty() || choosePersonBean.getStudentNumber() != null && Student.readStudentByNumber(choosePersonBean.getStudentNumber()) != null) {
                    RenderUtils.invalidateViewState();
                    request.setAttribute("choosePersonBean", (Object)choosePersonBean);
                    return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
                }
            }
        } else {
            person = choosePersonBean.getPerson();
        }
        if (!this.checkIngression(request, executionDegreeBean, ingressionInformationBean, person, choosePersonBean)) {
            return mapping.findForward("chooseNewStudentExecutionDegreeAndIdentification");
        }
        if (person != null) {
            personBean = new PersonBean(person);
            personBean.setStudentNumber(person.getStudent() != null ? person.getStudent().getNumber() : choosePersonBean.getStudentNumber());
        } else {
            personBean = new PersonBean(choosePersonBean.getName(), identificationNumber, choosePersonBean.getDocumentType(), dateOfBirth, choosePersonBean.getStudentNumber());
        }
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("fillNewPersonData");
    }

    private boolean checkIngression(HttpServletRequest request, ExecutionDegreeBean executionDegreeBean, IngressionInformationBean ingressionInformationBean, Person person, ChoosePersonBean choosePersonBean) {
        try {
            Registration.checkIngression(ingressionInformationBean.getIngressionType(), person, executionDegreeBean.getDegreeCurricularPlan());
        }
        catch (DomainException e) {
            RenderUtils.invalidateViewState();
            request.setAttribute("choosePersonBean", (Object)choosePersonBean);
            this.addActionMessage(request, e.getKey());
            return false;
        }
        return true;
    }

    public ActionForward prepareEditInstitutionPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrecedentDegreeInformationBean pdiBean = (PrecedentDegreeInformationBean)this.getRenderedObject("precedentDegreeInformation");
        pdiBean.resetDegree();
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        request.setAttribute("personBean", this.getRenderedObject("person"));
        request.setAttribute("precedentDegreeInformationBean", (Object)pdiBean);
        request.setAttribute("originInformationBean", this.getRenderedObject("originInformation"));
        RenderUtils.invalidateViewState((String)"precedentDegreeInformation");
        RenderUtils.invalidateViewState((String)"precedentDegreeInformationExternal");
        return mapping.findForward("fillNewPersonData");
    }

    public ActionForward fillNewPersonDataPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrecedentDegreeInformationBean pdiBean = (PrecedentDegreeInformationBean)this.getRenderedObject("precedentDegreeInformation");
        pdiBean.updateCountryHighSchoolLevel();
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        request.setAttribute("personBean", this.getRenderedObject("person"));
        request.setAttribute("precedentDegreeInformationBean", (Object)pdiBean);
        request.setAttribute("originInformationBean", this.getRenderedObject("originInformation"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("fillNewPersonData");
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        request.setAttribute("personBean", this.getRenderedObject("person"));
        request.setAttribute("precedentDegreeInformationBean", this.getRenderedObject("precedentDegreeInformation"));
        request.setAttribute("originInformationBean", this.getRenderedObject("originInformation"));
        return mapping.findForward("fillNewPersonData");
    }

    public ActionForward prepareShowFillOriginInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        Object personBean = this.getRenderedObject("person");
        request.setAttribute("personBean", personBean);
        Object originInformation = this.getRenderedObject("originInformation");
        request.setAttribute("originInformationBean", originInformation != null ? originInformation : new OriginInformationBean((PersonBean)personBean));
        PrecedentDegreeInformationBean precedentDegreeBean = (PrecedentDegreeInformationBean)this.getRenderedObject("precedentDegreeInformation");
        request.setAttribute("precedentDegreeInformationBean", (Object)precedentDegreeBean);
        try {
            precedentDegreeBean.validate();
        }
        catch (DomainException e) {
            RenderUtils.invalidateViewState();
            this.addActionMessage(request, e.getKey());
            return mapping.findForward("fillNewPersonData");
        }
        return mapping.findForward("fillOriginInformation");
    }

    public ActionForward prepareShowCreateStudentConfirmation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        request.setAttribute("personBean", this.getRenderedObject("person"));
        request.setAttribute("precedentDegreeInformationBean", this.getRenderedObject("precedentDegreeInformation"));
        request.setAttribute("originInformationBean", this.getRenderedObject("originInformation"));
        return mapping.findForward("showCreateStudentConfirmation");
    }

    public ActionForward prepareCreateStudentInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionDegreeBean", this.getRenderedObject("executionDegree"));
        request.setAttribute("ingressionInformationBean", this.getRenderedObject("chooseIngression"));
        PersonBean personBean = (PersonBean)this.getRenderedObject("person");
        request.setAttribute("personBean", (Object)personBean);
        request.setAttribute("precedentDegreeInformationBean", this.getRenderedObject("precedentDegreeInformation"));
        request.setAttribute("originInformationBean", this.getRenderedObject("originInformation"));
        return mapping.findForward("fillNewPersonData");
    }

    public ActionForward createStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            Registration registration = CreateStudent.run((PersonBean)this.getRenderedObject("person"), (ExecutionDegreeBean)this.getRenderedObject("executionDegree"), (PrecedentDegreeInformationBean)this.getRenderedObject("precedentDegreeInformation"), (IngressionInformationBean)this.getRenderedObject("chooseIngression"), (OriginInformationBean)this.getRenderedObject("originInformation"));
            request.setAttribute("registration", (Object)registration);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareShowCreateStudentConfirmation(mapping, actionForm, request, response);
        }
        return mapping.findForward("createStudentSuccess");
    }
}

