/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.student;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExportGrouping_Base;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.StudentGroup_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingController$callable$createErrorJson;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingService;
import org.fenixedu.bennu.core.rest.JsonAwareResource;
import org.fenixedu.bennu.spring.portal.SpringApplication;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringApplication(description="link.student.group", path="enroll-spring", group="anyone", hint="Student", title="label.enroll")
@SpringFunctionality(app=StudentGroupingController.class, title="label.groupEnrolment")
@RequestMapping(value={"/student/groups"})
public class StudentGroupingController
extends JsonAwareResource {
    @Autowired
    StudentGroupingService studentGroupingService;
    public static final Advice advice$createErrorJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping(method={RequestMethod.GET})
    public String home() {
        return "student/groupings/showGroupings";
    }

    @RequestMapping(value={"/groupings"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getOpenEnrollmentGroupings() {
        return new ResponseEntity((Object)this.view(AccessControl.getPerson().getStudent().getRegistrationsSet().stream().flatMap(registration -> registration.getAssociatedAttendsSet().stream()).map(Attends::getExecutionCourse).filter(executionCourse -> executionCourse.getExecutionPeriod() == ExecutionSemester.readActualExecutionSemester()).flatMap(executionCourse -> executionCourse.getGroupings().stream()).filter(grouping -> grouping.getAttendsSet().stream().anyMatch(attends -> attends.getRegistration().getPerson() == AccessControl.getPerson())).filter(grouping -> StudentGroupingController.checkEnrolmentDate(grouping)).collect(Collectors.toList())), HttpStatus.OK);
    }

    @RequestMapping(value={"/grouping/{grouping}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getGrouping(Grouping grouping) {
        if (!this.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        if (!this.personInGroupingAttends(grouping, AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view((Object)grouping), HttpStatus.OK);
    }

    @RequestMapping(value={"/shift/{shift}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getShift(Shift shift) {
        if (shift.getAssociatedStudentGroupsSet().stream().map(StudentGroup_Base::getGrouping).noneMatch(grouping -> this.personInGroupingAttends((Grouping)((Object)grouping), AccessControl.getPerson()))) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view((Object)shift), HttpStatus.OK);
    }

    @RequestMapping(value={"/studentGroup/{studentGroup}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getStudentGroup(StudentGroup studentGroup) {
        if (!this.personInGroupingAttends(studentGroup.getGrouping(), AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (!this.groupingIsOpenForEnrollment(studentGroup.getGrouping()).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        return new ResponseEntity((Object)this.view((Object)studentGroup), HttpStatus.OK);
    }

    @RequestMapping(value={"{grouping}/shifts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getShitsForGrouping(@PathVariable Grouping grouping) {
        if (!this.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notOpenToEnrollment", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (grouping.getShiftType() == null) {
            return new ResponseEntity((Object)"[]", HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.view(grouping.getExportGroupingsSet().stream().map(ExportGrouping_Base::getExecutionCourse).flatMap(executionCourse -> executionCourse.getAssociatedShifts().stream()).filter(shift -> shift.getTypes().contains((Object)grouping.getShiftType())).collect(Collectors.toList())), HttpStatus.OK);
    }

    @RequestMapping(value={"{grouping}/studentGroupsEnrolledByStudent"})
    @ResponseBody
    public ResponseEntity<String> getStudentGroupsEnrolledByStudent(@PathVariable Grouping grouping) {
        if (!this.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notOpenToEnrollment", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (!this.personInGroupingAttends(grouping, AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view(grouping.getStudentGroupsSet().stream().filter(studentGroup -> studentGroup.getAttendsSet().stream().anyMatch(attends -> attends.getRegistration().getPerson() == AccessControl.getPerson()))), HttpStatus.OK);
    }

    @RequestMapping(value={"{grouping}/studentGroups"})
    @ResponseBody
    public ResponseEntity<String> getStudentGroups(@PathVariable Grouping grouping) {
        if (!this.personInGroupingAttends(grouping, AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (!this.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notOpenToEnrollment", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view(grouping.getStudentGroupsSet()), HttpStatus.OK);
    }

    @RequestMapping(value={"{grouping}/studentsToEnroll"})
    @ResponseBody
    public ResponseEntity<String> getStudentsToEnroll(@PathVariable Grouping grouping) {
        if (!this.personInGroupingAttends(grouping, AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (!this.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.studentGroupShift.notOpen", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view(grouping.getAttendsSet().stream().filter(attends -> grouping.getStudentGroupsSet().stream().noneMatch(sg -> sg.getAttendsSet().stream().anyMatch(at -> at.equals((Object)attends)))).map(Attends::getRegistration).map(Registration::getPerson).collect(Collectors.toList())), HttpStatus.OK);
    }

    @RequestMapping(value={"/studentGroup/{studentGroup}/enrolled"})
    @ResponseBody
    public ResponseEntity<String> getStudentsEnrolled(@PathVariable StudentGroup studentGroup) {
        if (!this.personInGroupingAttends(studentGroup.getGrouping(), AccessControl.getPerson()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notEnroled", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        if (!this.groupingIsOpenForEnrollment(studentGroup.getGrouping()).booleanValue()) {
            return new ResponseEntity((Object)this.createErrorJson(new DomainException("error.grouping.notOpenToEnrollment", new String[0]).getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)this.view(studentGroup.getAttendsSet().stream().map(Attends::getRegistration).map(Registration::getPerson).collect(Collectors.toList())), HttpStatus.OK);
    }

    @RequestMapping(value={"/studentGroup/{studentGroup}/enroll"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> enroll(@PathVariable StudentGroup studentGroup) {
        try {
            this.studentGroupingService.enroll(studentGroup, AccessControl.getPerson());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/studentGroup/{studentGroup}/unenroll"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> unenroll(@PathVariable StudentGroup studentGroup) {
        try {
            this.studentGroupingService.unenroll(studentGroup, AccessControl.getPerson());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/studentGroup/{studentGroup}/changeShift"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> changeShift(@PathVariable StudentGroup studentGroup, @RequestBody String shiftJson) {
        try {
            Shift newShift = (Shift)FenixFramework.getDomainObject((String)new JsonParser().parse(shiftJson).getAsJsonObject().get("id").getAsString());
            this.studentGroupingService.changeShift(studentGroup, newShift);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/createStudentGroup/{grouping}/"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> createStudentGroup(@PathVariable Grouping grouping, @RequestBody String studentsToEnrollJson) {
        return this.createStudentGroup(grouping, null, studentsToEnrollJson);
    }

    @RequestMapping(value={"/createStudentGroup/{grouping}/{shift}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> createStudentGroup(@PathVariable Grouping grouping, @PathVariable Shift shift, @RequestBody String studentsToEnrollJson) {
        try {
            ArrayList<Person> studentsToEnroll = new ArrayList<Person>();
            for (JsonElement elem : new JsonParser().parse(studentsToEnrollJson).getAsJsonArray()) {
                JsonObject object = elem.getAsJsonObject();
                studentsToEnroll.add((Person)FenixFramework.getDomainObject((String)object.get("id").getAsString()));
            }
            this.studentGroupingService.createStudentGroup(grouping, shift, studentsToEnroll);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    private String createErrorJson(String string) {
        return (String)advice$createErrorJson.perform((Callable)new StudentGroupingController$callable$createErrorJson(this, string));
    }

    static /* synthetic */ String advised$createErrorJson(StudentGroupingController this_, String message) {
        JsonObject object = new JsonObject();
        object.addProperty("message", message);
        return object.toString();
    }

    public Boolean groupingIsOpenForEnrollment(Grouping grouping) {
        return grouping.getEnrolmentBeginDayDateDateTime().isBeforeNow() && grouping.getEnrolmentEndDayDateDateTime().isAfterNow();
    }

    public Boolean personInGroupingAttends(Grouping grouping, Person person) {
        return grouping.getAttendsSet().stream().map(Attends::getRegistration).map(Registration::getPerson).anyMatch(p -> p.equals((Object)AccessControl.getPerson()));
    }

    public static boolean checkEnrolmentDate(Grouping grouping) {
        if (grouping.getEnrolmentBeginDay() == null || grouping.getEnrolmentBeginDay().before(Calendar.getInstance())) {
            return grouping.getEnrolmentEndDay() == null || grouping.getEnrolmentEndDay().after(Calendar.getInstance());
        }
        return false;
    }
}

