/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller;

import com.google.common.base.Strings;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.EventTypes;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.ui.spring.controller.AcademicAdministrationSpringApplication;
import org.fenixedu.academic.ui.spring.service.ProgramConclusionService;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@SpringFunctionality(app=AcademicAdministrationSpringApplication.class, title="program.conclusion.title", accessGroup="academic(MANAGE_DEGREE_CURRICULAR_PLANS)")
@RequestMapping(value={"/program-conclusion-management"})
public class ProgramConclusionController {
    @Autowired
    ProgramConclusionService service;

    private String view(String jspfile) {
        return "fenixedu-academic/program-conclusion/" + jspfile;
    }

    protected String redirectHome() {
        return "redirect:/program-conclusion-management";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model) {
        model.addAttribute("conclusions", this.service.getProgramConclusions());
        return this.view("show");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("allEventTypes", this.service.getEventTypes());
        model.addAttribute("registrationStates", (Object)RegistrationStateType.values());
        return this.view("create");
    }

    private RegistrationStateType getRegistrationStateType(String targetState) {
        return Strings.isNullOrEmpty((String)targetState) ? null : RegistrationStateType.valueOf(targetState);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public String create(Model model, @RequestParam LocalizedString name, @RequestParam(defaultValue="{}") LocalizedString description, @RequestParam(defaultValue="{}") LocalizedString graduationTitle, @RequestParam(defaultValue="{}") LocalizedString graduationLevel, @RequestParam(defaultValue="false") boolean isAverageEditable, @RequestParam(defaultValue="false") boolean isAlumniProvider, @RequestParam(defaultValue="false") boolean isSkipValidation, @RequestParam(defaultValue="") String targetState, @RequestParam(defaultValue="#{new java.util.HashSet()}") Set<EventType> eventTypes) {
        try {
            this.service.createProgramConclusion(name, description, graduationTitle, graduationLevel, isAverageEditable, isAlumniProvider, isSkipValidation, this.getRegistrationStateType(targetState), new EventTypes(eventTypes));
            return "redirect:/program-conclusion-management";
        }
        catch (DomainException de) {
            model.addAttribute("error", (Object)de.getLocalizedMessage());
            return this.create(model);
        }
    }

    @RequestMapping(value={"/{programConclusion}"}, method={RequestMethod.GET})
    public String edit(Model model, @PathVariable ProgramConclusion programConclusion) {
        model.addAttribute("allEventTypes", this.service.getEventTypes());
        model.addAttribute("registrationStates", (Object)RegistrationStateType.values());
        model.addAttribute("programConclusion", (Object)programConclusion);
        return this.view("create");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{programConclusion}"})
    public String edit(Model model, @PathVariable ProgramConclusion programConclusion, @RequestParam LocalizedString name, @RequestParam(defaultValue="{}") LocalizedString description, @RequestParam(defaultValue="{}") LocalizedString graduationTitle, @RequestParam(defaultValue="{}") LocalizedString graduationLevel, @RequestParam(defaultValue="false") boolean isAverageEditable, @RequestParam(defaultValue="false") boolean isAlumniProvider, @RequestParam(defaultValue="false") boolean isSkipValidation, @RequestParam(defaultValue="") String targetState, @RequestParam(defaultValue="#{new java.util.HashSet()}") Set<EventType> eventTypes) {
        try {
            this.service.editProgramConclusion(programConclusion, name, description, graduationTitle, graduationLevel, isAverageEditable, isAlumniProvider, isSkipValidation, this.getRegistrationStateType(targetState), new EventTypes(eventTypes));
            return "redirect:/program-conclusion-management";
        }
        catch (DomainException de) {
            model.addAttribute("error", (Object)de.getLocalizedMessage());
            return this.edit(model, programConclusion);
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{programConclusion}"})
    public ResponseEntity<String> delete(Model model, @PathVariable ProgramConclusion programConclusion) {
        try {
            this.service.delete(programConclusion);
            return new ResponseEntity(HttpStatus.ACCEPTED);
        }
        catch (DomainException de) {
            return new ResponseEntity((Object)de.getLocalizedMessage(), HttpStatus.PRECONDITION_FAILED);
        }
    }
}

