/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.AlterExecutionPeriodState$callable$run;
import org.fenixedu.academic.util.PeriodState;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AlterExecutionPeriodState {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(String string, Integer n, PeriodState periodState) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new AlterExecutionPeriodState$callable$run(string, n, periodState));
    }

    static /* synthetic */ void advised$run(String year, Integer semester, PeriodState periodState) throws FenixServiceException {
        ExecutionYear executionYear = ExecutionYear.readExecutionYearByName(year);
        ExecutionSemester executionSemester = executionYear.getExecutionSemesterFor(semester);
        if (executionSemester == null) {
            throw new InvalidExecutionPeriod();
        }
        if (periodState.getStateCode().equals(PeriodState.CURRENT.getStateCode())) {
            ExecutionSemester currentExecutionPeriod = ExecutionSemester.readActualExecutionSemester();
            if (currentExecutionPeriod != null) {
                ExecutionYear currentExecutionYear = currentExecutionPeriod.getExecutionYear();
                currentExecutionPeriod.setState(PeriodState.OPEN);
                currentExecutionYear.setState(PeriodState.OPEN);
            }
            executionSemester.setState(periodState);
            executionSemester.getExecutionYear().setState(periodState);
        } else {
            executionSemester.setState(periodState);
            PeriodState currentPeriodState = periodState;
            for (ExecutionSemester otherExecutionPeriod : executionYear.getExecutionPeriodsSet()) {
                if (currentPeriodState == null || otherExecutionPeriod.getState().getStateCode().equals(currentPeriodState.getStateCode())) continue;
                currentPeriodState = null;
            }
            if (currentPeriodState != null) {
                executionYear.setState(currentPeriodState);
            }
        }
    }

    public static class InvalidExecutionPeriod
    extends FenixServiceException {
        InvalidExecutionPeriod() {
        }
    }
}

