/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class RegistrationDeclaration
extends AdministrativeOfficeDocument {
    protected RegistrationDeclaration(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected void fillReport() {
        super.fillReport();
    }

    @Override
    protected DocumentRequest getDocumentRequest() {
        return (DocumentRequest)super.getDocumentRequest();
    }

    @Override
    protected String getDegreeDescription() {
        Registration registration = this.getDocumentRequest().getRegistration();
        DegreeType degreeType = registration.getDegreeType();
        CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
        return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
    }

    @Override
    protected void setDocumentTitle() {
        this.addParameter("documentTitle", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.title.declaration", (String[])new String[0]));
    }

    @Override
    protected void newFillReport() {
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        Registration registration = this.getDocumentRequest().getRegistration();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        String studentRegistered = registration.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.maleRegistered", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.femaleRegistered", (String[])new String[0]);
        this.fillFirstParagraph(coordinator, coordinatorTitle);
        this.fillSecondParagraph(registration);
        this.fillSeventhParagraph(registration, studentRegistered);
        this.setFooter(this.getDocumentRequest());
        this.fillInstitutionAndStaffFields();
    }

    protected void fillFirstParagraph(Person coordinator, String coordinatorTitle) {
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(this.getLocale()), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
    }

    protected void fillSecondParagraph(Registration registration) {
        String student = registration.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.theMaleStudent", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.theFemaleStudent", (String[])new String[0]);
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.secondParagraph", (String[])new String[0]);
        this.addParameter("secondParagraph", "      " + MessageFormat.format(stringTemplate, student, registration.getNumber().toString()));
    }

    protected void fillSeventhParagraph(Registration registration, String studentRegistered) {
        String situation = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)(this.getExecutionYear().containsDate(new DateTime()) ? "label.is" : "label.was"), (String[])new String[0]);
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.seventhParagraph", (String[])new String[0]);
        this.addParameter("seventhParagraph", MessageFormat.format(stringTemplate, situation, studentRegistered.toUpperCase(this.getLocale()), this.getExecutionYear().getYear(), this.getDegreeDescription()));
    }
}

