/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class EnrolmentDeclaration
extends AdministrativeOfficeDocument {
    protected EnrolmentDeclaration(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected void fillReport() {
        String studentEnrolment;
        String student;
        super.fillReport();
        Registration registration = this.getDocumentRequest().getRegistration();
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        List enrolments = (List)this.getDocumentRequest().getRegistration().getEnrolments(this.getExecutionYear());
        Integer numberEnrolments = enrolments.size();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        if (registration.getStudent().getPerson().isMale()) {
            student = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.theMaleStudent", (String[])new String[0]);
            studentEnrolment = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.maleEnrolment", (String[])new String[0]);
        } else {
            student = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.theFemaleStudent", (String[])new String[0]);
            studentEnrolment = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.femaleEnrolment", (String[])new String[0]);
        }
        this.addParameter("documentTitle", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.title.declaration", (String[])new String[0]));
        this.addParameter("documentPurpose", this.getDocumentPurpose());
        this.fillFirstParagraph(coordinatorTitle, coordinator);
        this.fillSecondParagraph(registration, student);
        this.fillthirdthParagraph(registration, numberEnrolments, studentEnrolment);
        this.fillInstitutionAndStaffFields();
        this.setFooter(this.getDocumentRequest());
    }

    private void fillthirdthParagraph(Registration registration, Integer numberEnrolments, String studentEnrolment) {
        String situation = "";
        if (this.getDocumentRequest().getExecutionYear() != null) {
            situation = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)(this.getExecutionYear().containsDate(new DateTime()) ? "label.is" : "label.was"), (String[])new String[0]);
        }
        String executionYear = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.declaration.registration.execution.year.prefix", (String[])new String[0]);
        String stringTemplate1 = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.academicDocument.enrolment.declaration", (String[])new String[0]);
        this.addParameter("thirdParagraph", MessageFormat.format(stringTemplate1, situation, studentEnrolment, executionYear, this.getDocumentRequest().getExecutionYear().getYear().toString(), this.getCurricularYear(), this.getDegreeDescription(), numberEnrolments, this.getApprovementInfo()));
    }

    protected void fillFirstParagraph(String coordinatorTitle, Person coordinator) {
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
    }

    protected void fillSecondParagraph(Registration registration, String student) {
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.secondParagraph", (String[])new String[0]);
        this.addParameter("secondParagraph", "      " + MessageFormat.format(stringTemplate, student, registration.getNumber().toString()));
    }

    @Override
    protected String getDegreeDescription() {
        Registration registration = this.getDocumentRequest().getRegistration();
        if (registration.getDegreeType().isComposite()) {
            return registration.getDegreeDescription(this.getDocumentRequest().getExecutionYear(), (ProgramConclusion)null, this.getLocale());
        }
        DegreeType degreeType = registration.getDegreeType();
        CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
        return registration.getDegreeDescription(this.getExecutionYear(), cycleType, this.getLocale());
    }

    @Override
    protected DocumentRequest getDocumentRequest() {
        return (DocumentRequest)super.getDocumentRequest();
    }

    private final String getCurricularYear() {
        StringBuilder result = new StringBuilder();
        DegreeCurricularPlan degreeCurricularPlan = this.getDocumentRequest().getRegistration().getStudentCurricularPlan(this.getExecutionYear()).getDegreeCurricularPlan();
        if (degreeCurricularPlan.getDurationInYears() != 1) {
            Integer curricularYear = this.getDocumentRequest().getRegistration().getCurricularYear(this.getExecutionYear());
            result.append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)(curricularYear.toString() + ".ordinal"), (String[])new String[0]).toUpperCase());
            result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.enrolment.declaration.curricularYear", (String[])new String[0]));
        }
        return result.toString();
    }

    private final String getApprovementInfo() {
        StringBuilder result = new StringBuilder();
        EnrolmentDeclarationRequest enrolmentDeclarationRequest = (EnrolmentDeclarationRequest)((Object)this.getDocumentRequest());
        if (enrolmentDeclarationRequest.getDocumentPurposeType() == DocumentPurposeType.PPRE) {
            Registration registration = this.getDocumentRequest().getRegistration();
            ExecutionYear executionYear = enrolmentDeclarationRequest.getExecutionYear();
            boolean transition = registration.isTransition(executionYear);
            if (registration.isFirstTime(executionYear) && !transition) {
                result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.academicDocument.enrolment.declaration.approvement.firstTime", (String[])new String[0]));
            } else {
                Registration registrationToInspect;
                Registration registration2 = registrationToInspect = transition ? registration.getSourceRegistration() : registration;
                if (registrationToInspect.hasApprovement(executionYear.getPreviousExecutionYear())) {
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.academicDocument.enrolment.declaration.approvement.have", (String[])new String[0]) + executionYear.getPreviousExecutionYear().getYear());
                } else {
                    result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.academicDocument.enrolment.declaration.approvement.notHave", (String[])new String[0]) + executionYear.getPreviousExecutionYear().getYear());
                }
            }
        }
        return result.toString();
    }

    private final String getDocumentPurpose() {
        StringBuilder result = new StringBuilder();
        EnrolmentDeclarationRequest enrolmentDeclarationRequest = (EnrolmentDeclarationRequest)((Object)this.getDocumentRequest());
        if (enrolmentDeclarationRequest.getDocumentPurposeType() != null) {
            result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.declaration.valid.purpose", (String[])new String[0])).append(" ");
            if (enrolmentDeclarationRequest.getDocumentPurposeType() == DocumentPurposeType.OTHER && !StringUtils.isEmpty((String)enrolmentDeclarationRequest.getOtherDocumentPurposeTypeDescription())) {
                result.append(enrolmentDeclarationRequest.getOtherDocumentPurposeTypeDescription().toUpperCase());
            } else {
                result.append(BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)enrolmentDeclarationRequest.getDocumentPurposeType().name(), (String[])new String[0]).toUpperCase());
            }
            result.append(".");
        }
        return result.toString();
    }
}

