/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.NonAffiliatedTeacher;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.dto.InfoCurricularCourseScope;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoGrouping;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.teacher.InfoNonAffiliatedTeacher;

public class InfoExecutionCourse
extends InfoObject {
    private final ExecutionCourse executionCourseDomainReference;
    private Integer curricularYear;
    private Double occupancy;
    private List<InfoCurricularCourse> filteredAssociatedInfoCurricularCourses;
    private List<InfoExam> filteredAssociatedInfoExams;
    private List<InfoGrouping> filteredInfoGroupings;

    public InfoExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourseDomainReference = executionCourse;
    }

    public static InfoExecutionCourse newInfoFromDomain(ExecutionCourse executionCourse) {
        return executionCourse == null ? null : new InfoExecutionCourse(executionCourse);
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourseDomainReference;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoExecutionCourse && this.getExecutionCourse() == ((InfoExecutionCourse)obj).getExecutionCourse();
    }

    @Override
    public int hashCode() {
        return this.getExecutionCourse().hashCode();
    }

    @Override
    public String getExternalId() {
        return this.getExecutionCourse().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public Double getWeeklyTheoreticalHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.TEORICA).doubleValue();
    }

    public Double getWeeklyPraticalHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.PRATICA).doubleValue();
    }

    public Double getWeeklyTheoPratHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.TEORICO_PRATICA).doubleValue();
    }

    public Double getWeeklyLabHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.LABORATORIAL).doubleValue();
    }

    public Double getWeeklyFieldWorkHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.FIELD_WORK).doubleValue();
    }

    public Double getWeeklyProblemsHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.PROBLEMS).doubleValue();
    }

    public Double getWeeklySeminaryHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.SEMINARY).doubleValue();
    }

    public Double getWeeklyTrainingPeriodHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.TRAINING_PERIOD).doubleValue();
    }

    public Double getWeeklyTutorialOrientationHours() {
        return this.getExecutionCourse().getWeeklyCourseLoadTotalQuantityByShiftType(ShiftType.TUTORIAL_ORIENTATION).doubleValue();
    }

    public String getNome() {
        return this.getExecutionCourse().getNome();
    }

    public String getSigla() {
        return this.getExecutionCourse().getSigla();
    }

    public String getComment() {
        return this.getExecutionCourse().getComment();
    }

    public Integer getNumberOfAttendingStudents() {
        return this.getExecutionCourse().getAttendsSet().size();
    }

    public String getEqualLoad() {
        return this.getExecutionCourse().getEqualLoad();
    }

    public Boolean getAvailableGradeSubmission() {
        return this.getExecutionCourse().getAvailableGradeSubmission();
    }

    @Deprecated
    public InfoExecutionPeriod getInfoExecutionPeriod() {
        return InfoExecutionPeriod.newInfoFromDomain(this.getExecutionCourse().getExecutionPeriod());
    }

    public AcademicInterval getAcademicInterval() {
        return this.getExecutionCourse().getAcademicInterval();
    }

    public List<InfoShift> getAssociatedInfoShifts() {
        ArrayList<InfoShift> result = new ArrayList<InfoShift>();
        for (Shift shift : this.getExecutionCourse().getAssociatedShifts()) {
            result.add(InfoShift.newInfoFromDomain(shift));
        }
        return result;
    }

    public List<InfoNonAffiliatedTeacher> getNonAffiliatedTeachers() {
        ArrayList<InfoNonAffiliatedTeacher> result = new ArrayList<InfoNonAffiliatedTeacher>();
        for (NonAffiliatedTeacher nonAffiliatedTeacher : this.getExecutionCourse().getNonAffiliatedTeachersSet()) {
            result.add(InfoNonAffiliatedTeacher.newInfoFromDomain(nonAffiliatedTeacher));
        }
        return result;
    }

    public List<InfoEvaluation> getAssociatedInfoEvaluations() {
        ArrayList<InfoEvaluation> result = new ArrayList<InfoEvaluation>();
        for (Evaluation nonAffiliatedTeacher : this.getExecutionCourse().getAssociatedEvaluationsSet()) {
            result.add(InfoEvaluation.newInfoFromDomain(nonAffiliatedTeacher));
        }
        return result;
    }

    public List<InfoCurricularCourse> getAssociatedInfoCurricularCourses() {
        if (this.filteredAssociatedInfoCurricularCourses == null) {
            ArrayList<InfoCurricularCourse> result = new ArrayList<InfoCurricularCourse>();
            for (CurricularCourse curricularCourse : this.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
                InfoCurricularCourse infoCurricularCourse = InfoCurricularCourse.newInfoFromDomain(curricularCourse);
                infoCurricularCourse.setInfoScopes(this.getInfoScopes(curricularCourse.getScopesSet()));
                result.add(infoCurricularCourse);
            }
            this.setFilteredAssociatedInfoCurricularCourses(result);
            return result;
        }
        return this.getFilteredAssociatedInfoCurricularCourses();
    }

    public boolean getCanRemoveCurricularCourses() {
        return this.getAssociatedInfoCurricularCourses().size() > 1;
    }

    private List<InfoCurricularCourseScope> getInfoScopes(Collection<CurricularCourseScope> curricularCourseScopes) {
        ArrayList<InfoCurricularCourseScope> result = new ArrayList<InfoCurricularCourseScope>();
        for (CurricularCourseScope curricularCourseScope : curricularCourseScopes) {
            result.add(InfoCurricularCourseScope.newInfoFromDomain(curricularCourseScope));
        }
        return result;
    }

    public List<InfoCurricularCourse> getAssociatedInfoCurricularCourses(ExecutionYear executionYear) {
        ArrayList<InfoCurricularCourse> result = new ArrayList<InfoCurricularCourse>();
        for (CurricularCourse curricularCourse : this.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            InfoCurricularCourse infoCurricularCourse = InfoCurricularCourse.newInfoFromDomain(curricularCourse);
            infoCurricularCourse.setInfoScopes(this.getInfoScopes(curricularCourse.findCurricularCourseScopesIntersectingPeriod(executionYear.getBeginDate(), executionYear.getEndDate())));
            result.add(infoCurricularCourse);
        }
        return result;
    }

    public List<InfoExam> getAssociatedInfoExams() {
        if (this.filteredAssociatedInfoExams == null) {
            ArrayList<InfoExam> result = new ArrayList<InfoExam>();
            for (Exam exam : this.getExecutionCourse().getAssociatedExams()) {
                result.add(InfoExam.newInfoFromDomain(exam));
            }
            return result;
        }
        return this.getFilteredAssociatedInfoExams();
    }

    public List<InfoGrouping> getInfoGroupings() {
        if (this.filteredInfoGroupings == null) {
            ArrayList<InfoGrouping> result = new ArrayList<InfoGrouping>();
            for (Grouping grouping : this.getExecutionCourse().getGroupings()) {
                result.add(InfoGrouping.newInfoFromDomain(grouping));
            }
            return result;
        }
        return this.getFilteredInfoGroupings();
    }

    public Collection<CourseLoad> getCourseLoads() {
        return this.getExecutionCourse().getCourseLoadsSet();
    }

    public Integer getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(Integer integer) {
        this.curricularYear = integer;
    }

    public Double getOccupancy() {
        return this.occupancy;
    }

    public void setOccupancy(Double occupancy) {
        this.occupancy = occupancy;
    }

    private List<InfoCurricularCourse> getFilteredAssociatedInfoCurricularCourses() {
        return this.filteredAssociatedInfoCurricularCourses;
    }

    public void setFilteredAssociatedInfoCurricularCourses(List<InfoCurricularCourse> filteredAssociatedInfoCurricularCourses) {
        this.filteredAssociatedInfoCurricularCourses = filteredAssociatedInfoCurricularCourses;
    }

    private List<InfoExam> getFilteredAssociatedInfoExams() {
        return this.filteredAssociatedInfoExams;
    }

    public void setFilteredAssociatedInfoExams(List<InfoExam> filteredAssociatedInfoExams) {
        this.filteredAssociatedInfoExams = filteredAssociatedInfoExams;
    }

    public String toString() {
        return this.getExecutionCourse().toString();
    }

    private List<InfoGrouping> getFilteredInfoGroupings() {
        return this.filteredInfoGroupings;
    }

    public void setFilteredInfoGroupings(List<InfoGrouping> filteredInfoGroupings) {
        this.filteredInfoGroupings = filteredInfoGroupings;
    }

    public EntryPhase getEntryPhase() {
        return this.getExecutionCourse().getEntryPhase();
    }
}

