/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.email;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.StudentGroup;
import org.fenixedu.academic.domain.accessControl.TeacherGroup;
import org.fenixedu.academic.domain.accessControl.TeacherResponsibleOfExecutionCourseGroup;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.util.email.CurrentUserReplyTo;
import org.fenixedu.academic.domain.util.email.ExecutionCourseReplyTo;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender$callable$newInstance;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender_Base;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExecutionCourseSender
extends ExecutionCourseSender_Base {
    public static Comparator<ExecutionCourseSender> COMPARATOR_BY_EXECUTION_COURSE_SENDER;
    public static final Advice advice$newInstance;

    public ExecutionCourseSender(ExecutionCourse executionCourse) {
        this.setCourse(executionCourse);
        this.setFromAddress(Bennu.getInstance().getSystemSender().getFromAddress());
        this.addReplyTos((ReplyTo)((Object)new ExecutionCourseReplyTo()));
        this.addReplyTos((ReplyTo)((Object)new CurrentUserReplyTo()));
        this.setMembers((Group)TeacherGroup.get(executionCourse));
        String labelECTeachers = BundleUtil.getString((String)"resources.SiteResources", (String)"label.org.fenixedu.academic.domain.accessControl.ExecutionCourseTeachersGroupWithName", (String[])new String[]{executionCourse.getNome()});
        String labelECStudents = BundleUtil.getString((String)"resources.SiteResources", (String)"label.org.fenixedu.academic.domain.accessControl.ExecutionCourseStudentsGroupWithName", (String[])new String[]{executionCourse.getNome()});
        String labelECResponsibleTeachers = BundleUtil.getString((String)"resources.SiteResources", (String)"label.org.fenixedu.academic.domain.accessControl.ExecutionCourseResponsibleTeachersGroupWithName", (String[])new String[]{executionCourse.getNome()});
        this.addRecipients(new Recipient(labelECTeachers, (Group)TeacherGroup.get(executionCourse)));
        this.addRecipients(new Recipient(labelECStudents, (Group)StudentGroup.get(executionCourse)));
        this.addRecipients(new Recipient(labelECResponsibleTeachers, (Group)TeacherResponsibleOfExecutionCourseGroup.get(executionCourse)));
        this.setFromName(this.createFromName());
    }

    public String createFromName() {
        if (this.getCourse() != null && this.getCourse().getExecutionPeriod() != null && this.getCourse().getExecutionPeriod().getQualifiedName() != null) {
            String degreeName = this.getCourse().getDegreePresentationString();
            String courseName = this.getCourse().getNome();
            String period = this.getCourse().getExecutionPeriod().getQualifiedName().replace('/', '-');
            return String.format("%s (%s: %s, %s)", Unit.getInstitutionAcronym(), degreeName, courseName, period);
        }
        return this.getFromName();
    }

    public void delete() {
        this.setCourse(null);
        super.delete();
    }

    public static ExecutionCourseSender newInstance(ExecutionCourse executionCourse) {
        return (ExecutionCourseSender)((Object)advice$newInstance.perform((Callable)new ExecutionCourseSender$callable$newInstance(executionCourse)));
    }

    static /* synthetic */ ExecutionCourseSender advised$newInstance(ExecutionCourse ec) {
        ExecutionCourseSender sender = ec.getSender();
        return sender == null ? new ExecutionCourseSender(ec) : sender;
    }

    static {
        advice$newInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_EXECUTION_COURSE_SENDER = new Comparator<ExecutionCourseSender>(){

            @Override
            public int compare(ExecutionCourseSender executionCourseSender1, ExecutionCourseSender executionCourseSender2) {
                ExecutionSemester executionSemester2;
                ExecutionCourse executionCourse1 = executionCourseSender1.getCourse();
                ExecutionCourse executionCourse2 = executionCourseSender2.getCourse();
                ExecutionSemester executionSemester1 = executionCourse1.getExecutionPeriod();
                int p = executionSemester1.compareTo(executionSemester2 = executionCourse2.getExecutionPeriod());
                if (p == 0) {
                    int n = executionCourse1.getName().compareTo(executionCourse2.getName());
                    return n == 0 ? executionCourseSender1.hashCode() - executionCourseSender2.hashCode() : n;
                }
                return p;
            }
        };
    }
}

